ROUTINE(logli1,		iterative proportional log-linear fit)
#     algorithm as51  appl. statist. (1972) vol 21, no 2
subroutine logli1(nvar,dim,ncon,config,ntab,table,fit,locmar,nmar,marg,nu,u,maxdev,maxit,dev,nlast)
real marg(nmar),u(nu),table(ntab),fit(ntab),maxdev,dev(maxit)
define(`MAXVAR',15)
integer dim(nvar),check(MAXVAR),config(nvar,ncon),locmar(ncon),point,size,icon(MAXVAR)
integer nvar,ncon,ntab,nmar,nu,maxit,nlast
integer i,j,k,n; real x,y,xmax

if(nvar<1|nvar>MAXVAR|maxit<1)ERROR(Bad nvar or maxit)
size = 1	# look at table and fit constants
do j = 1,nvar {
	if (dim(j)<=0) ERROR(Non-positive dimension)
	size = size*dim(j)
	}
if(size>ntab)ERROR(Table size too small)
x = 0.0; y = 0.0
do i = 1,size {
	if (table(i)<0.0||fit(i)<0.0) ERROR(Table or Fit negative)
	x = x+table(i)
	y = y+fit(i)
	}
if (y==0.0) ERROR(All fit values zero)
x = x/y
do i = 1,size	# preliminary adjustment to obtain fit to empty configuration list
	fit(i) = x*fit(i)
point = 1	# allocate marginal table
for(i=1; i<=ncon; i=i+1){
	if (config(1,i)==0) break	# zero beginning a configuration indicates that the list is completed
	size = 1
	do j = 1,nvar	# get marginal table size
		check(j) = 0
	do j = 1,nvar {
		k = config(j,i)
		if (k==0) break	# zero indicates end of string
		if (k<0||k>nvar) ERROR(Margin specification bad)
		if (check(k)==1) ERROR(Margin contains duplicates)
		check(k) = 1
		size = size*dim(k)
		}
	if (size>nu) ERROR(Table U too small)
	locmar(i) = point	# locmar points to marginal tables to be placed in marg
	point = point+size
	}
n = i-1	# number of valid configurations
if (point>nmar+1) ERROR(Too little space for marginal tables)
do i = 1,n {	# obtain marginal tables
	do j = 1,nvar
		icon(j) = config(j,i)
	call collap(nvar,table,marg,1,locmar(i),ntab,nmar,dim,icon,TRUE)
	}
for(k=1; k<=maxit; k=k+1) {	# perform iterations
	xmax = 0.0	#  maximum deviation observed between fitted and true marginal during a cycle
	do i = 1,n {
		do j = 1,nvar
			icon(j) = config(j,i)
		call collap(nvar,fit,u,1,1,ntab,nu,dim,icon,TRUE)
		call adjust(nvar,fit,u,marg,1,1,locmar(i),ntab,nu,nmar,dim,icon,xmax)
		}
	dev(k) = xmax
	if (xmax<maxdev) break
	}
nlast=k		# may be > maxit (no convergence)
return
end
