ROUTINE(loglin,		log-linear fit by iterative proportional adjustment)
subroutine loglin(table,nvar,dim,config,fit,maxdev,maxit,dev,nlast)
real table(1),fit(1),maxdev,dev
integer dim(nvar),config(1),nvar,maxit,nlast
INCLUDE(stack)
POINTER dtab,ltab,ctab,utab,mtab,p,jstkgt
integer ncon,usize,msize,tsize,csize,i,j,k
ncon=0
for(i=1; i<500; i=i+1)
	if(config(i)==0){
		ncon=ncon+1
		if(config(i+1)==0)break
		}
ctab=jstkgt(ncon*nvar,INT)
call ifill(0,is(ctab),ncon*nvar)
tsize=1	#size of table
for(i=1; i<=nvar; i=i+1) tsize=tsize*dim(i)
if(fit(1)<0.)call rfill(1.0,fit,tsize)	# init fit to 1 if first element negative
ncon=0	#fill config matrix
p=ctab; k=0
for(i=1;i<500;i=i+1)
	if(config(i)!=0){
		is(p+k)=config(i)
		k=k+1
		}
	else{
		if(k==0)break
		k=0
		ncon=ncon+1
		p=p+nvar	# advance to next column
		}
msize=0	#total margin size
usize=0	#maximum margin table size
p=ctab
for(i=1; i<=ncon; i=i+1){
	csize=1
	for(j=0;j<nvar;j=j+1){
		k=is(p+j)
		if(k==0)break
		csize=csize*dim(k)
		}
	usize=max(csize,usize)
	msize=msize+csize
	p=p+nvar	#next column of config
	}
dtab=jstkgt(maxit,REAL); ltab=jstkgt(ncon,INT)
mtab=jstkgt(msize,REAL); utab=jstkgt(usize,REAL)

call logli1(nvar,dim,ncon,is(ctab),tsize,table,fit,is(ltab),msize,rs(mtab),usize,rs(utab),
	maxdev,maxit,rs(dtab),nlast)

dev=rs(dtab+min0(nlast,maxit)-1)	# nlast may be > maxit if no convergence
call jstkrl(5)
return
end
