ROUTINE(pgamm,probability variable from gamma shape eta less than quant)
real function pgamm(quant,eta)
real quant,eta

real e,term,sum,gamlog,eps,r,test
integer last,j
if(quant<0.)ERROR(Quantile negative)
if(eta<=0.)ERROR(Parameter ETA not positive)
e = eta
term = 1.
sum = 1.
if(quant==0.)
	pgamm = 0.
else if (quant>=eta&&quant>=7.0) {	#asymptotic expansion for large quant.
	last = ifix(eta)+10
	if (quant<11.)
		last = ifix(quant+eta)-1
	do j = 1,last {
		e = e-1.
		term = term*e/quant
		sum = sum+term
		}
#       correction term
	term = term*(e-1.)
	sum = sum+term/(quant-e+2.)
	pgamm = 1.-exp(-quant+(eta-1.)*alog(quant)+alog(sum)-gamlog(eta))
	}
else {	#       series for small quant
	eps = PRECISION
	repeat {
		e = e+1.
		r = quant/e
		term = term*r
		sum = sum+term
		if (r<=0.5) {
			test = term/sum
			if (test<=eps)
				break 1
			}
		}
	pgamm = exp(eta*alog(quant)-quant+alog(sum)-gamlog(eta))/eta
	}
return
end
