ROUTINE(ptdis,probability variable from "t" (real) df degrees freedom less than quant)
real function ptdis(quant,df)
real quant,df

real pnorms,tp,t,fn,z,y,b,a,fj,studen,zrotol,a1plus
integer n,j
#adaptation of  ACM algorithm 395 (G. W. Hill, v. 13(1970), 617-619)

logical test
data zrotol/SMALL/
if (df<=0.0) ERROR(df less or equal zero)
a1plus=1+PRECISION
tp = quant
t = tp
n = df
fn = df
# test df and t to determine correct series to calculate
z = 1.
t = t**2
y = t/fn
b = 1.+y
test = (abs(fn-float(n))>=1.e-6)||((n>=20)&&(t<fn))||(n>200)
if (test) {	# asymptotic series for large or non-integer n
	if (y>1.e-6)
		y = alog(b)
	a = fn-0.5
	b = 48.0*a**2
	y = a*y
	y = (((((-0.4*y-3.3)*y-24.)*y-85.5)/(0.8*y**2+100.0+b)+y+3.0)/b+1.0)*sqrt(y)
	studen = 2.0*pnorms(-y)
	}
else {
	test = (n<20)&&(t<4.)
	if (test) {	# nested summation of "cosine" series
		a = sqrt(y)
		y = a
		if (n==1)
			a = 0.0
		}
	else {	#   "tail" series expansion for large t-values
		a = sqrt(b)
		y = a*fn
		j = 0
		repeat {
			j = j+2
			if (abs(a-z)<=zrotol)
				break 1
			z = a
			fj = float(j)
			y = y*float(j-1)/(b*fj)
			a = a+y/(fn+fj)
			}
		fn = fn+2.
		y = 0.
		z = 0.
		a = -a
		}
	repeat {
		fn = fn-2.
		if (fn<=a1plus)
			break 1
		a = ((fn-1.)/(b*fn))*a+y
		}
	if (abs(fn)>zrotol)
		a = (atan(y)+a/b)*0.636619772	#   2/pi=0.63661977236...
	else
		a = a/sqrt(b)
	studen = z-a
	}
#
if(tp>=0.) return( 1.-0.5*studen )
else return( 0.5*studen )
end
