ROUTINE(qantle,		quantiles of an ordered sample)
# note returned quantiles are constrained to be at data points or midway between
subroutine qantle(x,nx,quant,prob,nqp)
integer nx,nqp
real x(nx),quant(nqp),prob(nqp)

integer r,k,ipn; real pn,small,p
data small/1.0e-5/
if(nx<0 | nqp<0)ERROR(number of items < 0)
if(nx==0 | nqp==0) return
do k = 1,nqp {
	if (prob(k)>0.5) p = 1.0-prob(k); else p = prob(k)
	pn = p*float(nx)
	ipn = pn+small
	if(prob(k)<=0.5)r = ipn+1; else r = nx-ipn
	if(abs(pn-float(ipn))>small) quant(k) = x(r)	# pn is not integer
	else if(prob(k)<=0.5) quant(k) = 0.5*(x(r-1)+x(r))
	else quant(k) = 0.5*(x(r+1)+x(r))
	}
return
end
