ROUTINE(qf,		quantiles from the F distribution)
real function qf(p,df1,df2)
real p,df1,df2
#return the quantile corresponding to probaility p, degrees of freedom
#df1, df2 for numerator, denominator

real qbeta,q

if(df1<=0. | df2<=0.)FATAL(degrees of freedom not positive)
if(p<0. | p>=1.)FATAL(probability out of range)
q=qbeta(p,df1*.5,df2*.5)
return( (df2/df1)*(q/(1.-q)) )
end
