ROUTINE(stred1,		reduce to tri-diagonal form, single precision)
subroutine stred1(nm,n,a,d,e,e2)
#
integer i,j,k,l,n,ii,nm,jp1
real a(nm,n),d(n),e(n),e2(n)
real f,g,h,scale
real sqrt,abs,sign
#
#     this subroutine is a translation of the algol procedure tred1,
#     num. math. 11, 181-195(1968) by martin, reinsch, and wilkinson.
#     handbook for auto. comp., vol.ii-linear algebra, 212-226(1971).

#     this subroutine reduces a real symmetric matrix
#     to a symmetric tridiagonal matrix using
#     orthogonal similarity transformations.
#
#     on input-
#
#        nm must be set to the row dimension of two-dimensional
#          array parameters as declared in the calling program
#          dimension statement,
#
#        n is the order of the matrix,
#
#        a contains the real symmetric input matrix.  only the
#          lower triangle of the matrix need be supplied.
#
#     on output-
#
#        a contains information about the orthogonal trans-
#          formations used in the reduction in its strict lower
#          triangle.  the full upper triangle of a is unaltered,
#
#        d contains the diagonal elements of the tridiagonal matrix,
#
#        e contains the subdiagonal elements of the tridiagonal
#          matrix in its last n-1 positions.  e(1) is set to zero,
#
#        e2 contains the squares of the corresponding elements of e.
#          e2 may coincide with e if the squares are not needed.
#
#     questions and comments should be directed to b. s. garbow,
#     applied mathematics division, argonne national laboratory
#
#     ------------------------------------------------------------------77445047
#
do i = 1,n
	d(i) = a(i,i)
#     ********** for i=n step -1 until 1 do -- **********
do ii = 1,n {
	i = n+1-ii
	l = i-1
	h = 0.0
	scale = 0.0
	if (l>=1) {
#     ********** scale row (algol tol then not needed) **********
		do k = 1,l
			scale = scale+abs(a(i,k))
#
		if (scale!=0.0) {
#
			do k = 1,l {
				a(i,k) = a(i,k)/scale
				h = h+a(i,k)*a(i,k)
				}
#
			e2(i) = scale*scale*h
			f = a(i,l)
			g = -sign(sqrt(h),f)
			e(i) = scale*g
			h = h-f*g
			a(i,l) = f-g
			if (l!=1) {
				f = 0.0
#
				do j = 1,l {
					g = 0.0
#     ********** form element of a*u **********
					do k = 1,j
						g = g+a(j,k)*a(i,k)
#
					jp1 = j+1
					if (l>=jp1)
#
						do k = jp1,l
							g = g+a(k,j)*a(i,k)
#     ********** form element of p **********
					e(j) = g/h
					f = f+e(j)*a(i,j)
					}
#
				h = f/(h+h)
#     ********** form reduced a **********
				do j = 1,l {
					f = a(i,j)
					g = e(j)-h*f
					e(j) = g
#
					do k = 1,j
						a(j,k) = a(j,k)-f*e(k)-g*a(i,k)
					}
				}
#
			do k = 1,l
				a(i,k) = scale*a(i,k)
			go to 10
			}
		}
	e(i) = 0.0
	e2(i) = 0.0
#
	10  h = d(i)
	d(i) = a(i,i)
	a(i,i) = h
	}
return
end



