ROUTINE(trvar,trimmed variance of sorted data)
real function trvar(x,n,alpha)
integer n
real x(n),alpha

real qnorms,const,u,trmean,xxc,xn,atr,sum,btr
integer nup,low,i
if(alpha<0. | alpha >=.5) ERROR(alpha must be positive and less than .5)
if(n<1) ERROR(must be at least 1 point)
if(n==1) return(0.)
if (alpha==0) const=1.
else {
	u = qnorms(1.-alpha)
	const = 1.-(.7978845/(1.-2.*alpha))*(u/exp(u**2/2.))
	}
xxc = trmean(x,n,alpha)
xn = n
atr = alpha*xn
nup = xn-atr+.000001
xn = xn-atr*2.-1.
if (xn>0.) {
	low = n-nup+1
	sum = 0.0
	for(i=low; i<=nup; i=i+1)
		sum = sum+(x(i)-xxc)**2
	btr = float(low-1)-atr
	if (btr>.000001)
		sum = sum+((x(low-1)-xxc)**2+(x(nup+1)-xxc)**2)*btr
	return( (sum/xn)/const )
	}
else return(0.)
end
