#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "S.h"
#include "device.h"

#define NLOCAL 12

#define ask ((long *)(cur_device->local_params))[0]
#define oldcolor ((long *)(cur_device->local_params))[1]
#define opened ((long *)(cur_device->local_params))[2]
#define oldsize ((float *)(cur_device->local_params))[3]
#define oldrot ((long *)(cur_device->local_params))[4]
#define xsize ((float *)(cur_device->local_params))[5]
#define ysize ((float *)(cur_device->local_params))[6]
#define oldltype ((long *)(cur_device->local_params))[7]
#define penup ((long *)(cur_device->local_params))[8]
#define auto ((long *)(cur_device->local_params))[9]
#define colormode ((long *)(cur_device->local_params))[10]
#define rotated ((long *)(cur_device->local_params))[11]

#define am(i)		(F77_COM(bgrp)[i-1])
#define Ltype		((int)am(8))
#define Color		((int)am(10))
#define Cex		(am(18))
#define notNew		(am(121))

extern float F77_COM(bgrp)[];
vector *hpgl(), 
	*F77_SUB(bpntsz)(), *F77_SUB(blinsz)(), *F77_SUB(bpolyz)(),
	*F77_SUB(btextz)(), *F77_SUB(bsegsz)(), *F77_SUB(brdpnz)(),
	*F77_SUB(bquxyz)();
static vector  *wrap(), *flush(), *signalled(),
	*clear(), *seek(), *point(), *line(), *getxy();
static turn_on();

static device d_hpgl = {
	FALSE,
	0,
	(float *)NULL,
	NLOCAL,
	(char *)NULL,
	{				/* <R> required <O> optional */
		hpgl,			/* initialize <R> */
		wrap,			/* wrap up <R> */
		flush,			/* flush <R> */
		signalled,		/* caught signal <R> */
		F77_SUB(bpntsz),	/* points <R> (bpntsz) */
		F77_SUB(blinsz),	/* lines <R> (blinsz) */
		F77_SUB(bpolyz),	/* polygon <R> (bpolyz) */
		F77_SUB(btextz),	/* text <R> (btextz) */
		F77_SUB(bsegsz),	/* segments <R> (bsegsz) */
		clear,			/* clear <R> */
		F77_SUB(brdpnz),	/* graphic input <R> (brdpnz) */
		NULL,			/* menu <O> */
		NULL,			/* hook <O> */
		seek,			/* seek <O> (low level) */
		point,			/* point <O> (low level) */
		line,			/* line <O> (low level) */
		NULL,			/* length of string <O> */
		getxy,			/* input <O> (low level) */
	}
};

FILE *outfile;

vector
*hpgl(a_xsize,a_ysize,a_ask,a_auto,a_colormode,a_speed,a_rotated,a_file)
float *a_xsize, *a_ysize;
long *a_ask, *a_auto, *a_colormode, *a_speed, *a_rotated;
char **a_file;
{
	device *d, *new_device();
	int i;

	/* initialize device structure */
	d = new_device(&d_hpgl, 0L);
	set_device(d->which);

	for(i=1; i<=39; i++)
		am(i) = 0.0;
	am(20) = 114.;	/* char size in rasters */
	am(21) = 216.;
	am(22) = 250.;
	am(23) = *a_xsize * 1000. + am(22);
	am(24) = 250.;
	am(25) = *a_ysize * 1000. + am(24);
	am(26) = 1./6.;	/* char addressing offset */
	am(27) = .25;
	am(28) = .001;	/* raster size in inches */
	am(29) = .001;
	am(30) = HPGL;
	am(31) = 1;	/* allow char rotation */
	am(1) = 2.;	/* allow char size change */

	colormode = *a_colormode;
	ask = *a_ask;
	oldcolor = -1;
	opened = 0;
	oldsize = -1;
	oldrot = 0;
	oldltype = -1;
	penup = 1;
	auto = *a_auto;
	xsize = *a_xsize;
	ysize = *a_ysize;
	rotated = *a_rotated;

	if(**a_file){	/* no interaction allowed */
		outfile = fopen(*a_file, "a"); Perm_open(outfile);
		if(outfile == NULL) PROBLEM "Cannot open file" RECOVER(NULL_ENTRY);
		ask = 0;
		if(colormode==1) colormode = 2;
		}
	else outfile = stdout;


	turn_on();
	/* initializate - abort graphics, xon/xoff, defaults */
	fprintf(outfile,"\033.K\033.@:\033.I200;;17:\033.N;19:\033.M;;10:DF;RO%d;",
		*a_rotated?90:0);
	if(*a_speed<40) fprintf(outfile,"VS%ld;",*a_speed);
	flush();

	F77_SUB(defltz)();
	notNew = 1;	/* force erase on first real plotting */
	return(S_void);
}

static vector *
wrap()
{
	turn_on();
	fprintf(outfile,"SP0;");
	flush();
	if(outfile != stdout){ Perm_close(outfile); fclose(outfile);}
	return(S_void);
}

static turn_on()
{
	if(!opened){
		fprintf(outfile,"\033.Y");
		opened = 1;
		}
}

static vector *signalled()
{
	return(S_void);
}

static vector *line(x,y)
long *x,*y;
{
	if(penup) fprintf(outfile,"PD;");
	penup = 0;
	fprintf(outfile,"PA%ld,%ld;",*x,*y);
	return(S_void);
}

static vector *point(ich,crot)
F_CHARTYPE ich; float *crot;
{
	char *p = F_CHARP(ich);
	if(*crot != oldrot){
		fprintf(outfile,"DI%d,%d;",
			(int) (cos(*crot*DEG2RD)*127.),
			(int) (sin(*crot*DEG2RD)*127.));
		oldrot = *crot;
		}
	if(Cex != oldsize){
		fprintf(outfile,"SI%f,%f;",
			am(20)*Cex*2./3.*.0025,
			am(21)*Cex*.5*.0025);
		oldsize = Cex;
		}
	fprintf(outfile,"LB%c\003",*p=='0'?'O':*p);	/* replace zero by oh */
	return(S_void);
}

static vector *seek(x,y)
long *x,*y;
{
	int j, k;
	if(colormode > 0 && Color != oldcolor){
		j = ( (int)Color - 1 ) % 24 + 1;
		if(colormode > 1) {	/* auto color change */
			turn_on();
			fprintf(outfile,"SP%d;",j);
			}
		else {
			flush();
			fprintf(stderr,"Load pen %d\007 ",j);
			fflush(stderr);
			while( getc(stdin)!='\n' ) ;	/* ignore reply */
			}
		oldcolor = Color;
		}
	turn_on();
	if(oldltype != Ltype){
		j = ((int)Ltype - 2) % 6 + 1;
		k = ((int)Ltype - 2) / 6 + 1;
		if(j>3) k += 2;
		if((int)Ltype == 1) fprintf(outfile,"LT;");
		else fprintf(outfile,"LT%d,%d;",j,k);
		oldltype = Ltype;
		}
	fprintf(outfile,"PU;PA%ld,%ld;",*x,*y);
	penup = 1;
	return(S_void);
}


static vector *clear()
{
	if(auto){
		turn_on();
		if(xsize>8) fprintf(outfile,"AF;");
		else fprintf(outfile,"AH;");
		flush();
		}
	else if(ask){
		fprintf(stderr,"GO? ");
		fflush(stderr);
		while( getc(stdin)!='\n' ) ;	/* ignore reply */
		}
	return(S_void);
}


static vector *flush()
{
	if(!penup) fprintf(outfile,"PU;");
	penup = 1;
	if(opened) {
		fprintf(outfile,"\033.Z");
		opened=0;
		}
	fflush(outfile);
	return(S_void);
}

static vector *getxy(x,y,flag)
long *x,*y,*flag;
{
	int i,j,n; char buf[100];
	if(outfile!=stdout) {
		F77_SUB(bquxyz)(x,y,flag);
		return(S_void);
		}
	turn_on();
	fprintf(outfile,"DP;");
	for( i = 1; ; i++){
		if(i>1) sleep((unsigned)2*i/10+2);	/* wait */
		fprintf(outfile,"OS;");
		fgets(buf,100,outfile);
		j = sscanf(buf,"%d",&n);
		if(j!=1 || n&04) break;		/* wait for point ready */
		}
	if(j==1) fprintf(outfile,"OD;");	/* output digitized point */
	fgets(buf,100,outfile);
	n = sscanf(buf,"%ld,%ld,%ld", x, y, flag);
	if(n!=3) {
		*flag = -1;
		fprintf(outfile,"DC;");	/* signal error */
		}
	return(S_void);
}
