/* S device driver for pic
*/

#include <math.h>
#include <stdio.h>
#include <signal.h>
#include "S.h"
#include "device.h"

/* defines that allow easy access of graphical parameters */
#define am(i)		(F77_COM(bgrp)[i-1])
#define Ltype		((int)am(8))
#define Lwd		(am(9))
#define Cex		(am(18))
#define Cwid		(am(20))
#define Chgt		(am(21))
#define Xoffs		(am(26))
#define Yoffs		(am(27))
#define Xrast		(am(28))
#define Yrast		(am(29))
#define Xorigin		(am(36))
#define Xscale		(am(37))
#define Yorigin		(am(38))
#define Yscale		(am(39))
#define Srt		(am(48))
#define UxR(x)		((int)((x) * Xscale + Xorigin))
#define UyR(y)		((int)((y) * Yscale + Yorigin))
#define RxU(x)		(((x) - Xorigin) / Xscale)
#define RyU(y)		(((y) - Yorigin) / Yscale)
#define notNew		(am(121))
#define ok(i,j,k)	((i>=j)&&(i<=k))

extern float F77_COM(bgrp)[];

/* declarations for routines in the device structure
	note that pic() is the only externally-called function
	all the rest are statics appearing in the device structure */
vector *pic(),
	*F77_SUB(bpntsz)(), *F77_SUB(blinsz)(), *F77_SUB(bpolyz)(),
	*F77_SUB(bsegsz)(), *F77_SUB(brdpnz)();
static vector  *wrap(), *flush(), *signalled(), *text(),
	*clear(), *seek(), *point(), *line(), *getxy();

/* structure that describes the device and its functions */
static device d_pic = {
			/* leave these alone */
	FALSE,				/* active flag */
	0,				/* index in list of devices */
	(float *)NULL,			/* copy of parameter array */
	0,				/* number of local parameters */
	(char *)NULL,			/* slot for the local parameters */
			/* functions performed by driver */
	{		/* <R> required <O> optional */
		pic,			/* initialize <R> */
		wrap,			/* wrap up <R> */
		flush,			/* flush <R> */
		signalled,		/* caught signal <R> */
			/* these functions deal with sequences of points,
				lines, segments, etc., and can be
				written specially for this device or 
				can be the parenthesized pre-defined
				functions that call lower-level seek,
				line, character, etc functions */
		F77_SUB(bpntsz),	/* points <R> (bpntsz) */
		F77_SUB(blinsz),	/* lines <R> (blinsz) */
		F77_SUB(bpolyz),	/* polygon <R> (bpolyz) */
		text,			/* text <R> */
		F77_SUB(bsegsz),	/* segments <R> (bsegsz) */
		clear,			/* clear <R> */
		F77_SUB(brdpnz),	/* graphic input <R> (brdpnz) */
		NULL,			/* menu <O> */
		NULL,			/* hook <O> */
			/* these low-level functions must be supplied only if
				bpntsz, blinsz, bsegsz, btextz, brdpnz are
				used above */
		seek,			/* seek <O> (low level) */
		point,			/* point <O> (low level) */
		line,			/* line <O> (low level) */
		NULL,			/* length of string <O> (ignore this) */
		getxy			/* input <O> (low level) */
	}
};

FILE *outfile;

static int is_command, newpage;

vector *pic(where,how)
char **where;
long *how;
{
	device *new_device();
	int i, (*osig)();

	/* initialize device structure */

	set_device(new_device(&d_pic, 0L)->which);

	for(i=1; i<=39; i++)
		am(i) = 0.0;
	am(20) = 100.;	/* char size (x) in rasters */
	am(21) = 120.;	/* char size (y) in rasters */
	am(22) = 0.;	/* minimum x raster coordinate */
	am(23) = 7000.;	/* maximum x raster coordinate */
	am(24) = 0.;	/* minimum y raster coordinate */
	am(25) = 7000.;	/* maximum y raster coordinate */
	am(26) = .5;	/* char addressing offset x */
	am(27) = .26;	/* char addressing offset y */
	am(28) = .001;	/* x raster size in inches */
	am(29) = .001;	/* y raster size in inches */
	am(30) = -2000;	/* arbitrary negative device number (device.h) */
	am(31) = 0;	/* allow char rotation */
	am(1)  = 2.;	/* allow char size change */

	/* pipe output to a command, or write on a file */
	is_command = *how != 0;
	osig = signal(SIGINT, SIG_IGN);
	outfile = is_command ? popen(*where, "w") : fopen(*where, "w");
	signal(SIGINT, osig);
	if(outfile == NULL)
		PROBLEM "Cannot %s %s for pic output",
			is_command ? "exec" : "open", *where
		RECOVER(S_void);

	fprintf(outfile,".PS\n");

	newpage = 1;
	F77_SUB(defltz)();	/* set default values for other parms */
	notNew = 1;	/* force erase on first real plotting */
	return(S_void);
}

/* this function is called to wrap up execution */
static vector *wrap()
{
	fprintf(outfile,".PE\n");
	is_command ? pclose(outfile) : fclose(outfile);
	return(S_void);
}


/* function executed when the device receives a signal (like an interrupt)
	its purpose is to make sure the device is reset to a consistent
	state when interrupted */
static vector *signalled()
{
	fprintf(outfile,"\n");
	clear();
	return(S_void);
}

/* draw a line segment */
static vector *line(x,y)
long *x,*y;
{
	newpage = 0;
	if (Lwd != 1)
		fprintf(outfile,".ps %g\n",10*Lwd);
	fprintf(outfile,"line");
	if (Ltype>1)
		fprintf(outfile," dashed %g",1./Ltype);
	else if (Ltype<0)
		fprintf(outfile," dotted %g",-1./Ltype);
	fprintf(outfile," to %g,%g\n",*x/1000.,*y/1000.);
	if (Lwd != 1)
		fprintf(outfile,".ps\n");
	return(S_void);
}

/* put out a single character at current position */
static vector *point(ich,crot)
F_CHARTYPE ich;
float *crot;
{
	newpage = 0;
	if (Cex != 1)
		fprintf(outfile,".ps %g\n",10.*Cex);
	fprintf(outfile,"\"%c\"\n",*F_CHARP(ich));
	if (Cex != 1)
		fprintf(outfile,".ps\n");
	return(S_void);
}

/* position the device at x,y coords */

static vector *seek(x,y)
long *x,*y;
{
	newpage = 0;
	fprintf(outfile,"move to %g,%g\n",*x/1000.,*y/1000.);
	return(S_void);
}

/* clear the graphic area */
static vector *clear()
{
	if(!newpage)
		fprintf(outfile,".PE\n.bp\n.PS\n");
	newpage = 1;
	return(S_void);
}


/* output string at given position, justified according to pos */
static vector *text(x, y, bufa, n, pos)
float *x, *y, *pos;
F_CHARTYPE bufa;
long *n;
{
#ifdef F_CHARSTRUCT
	F_CHARSTRUCT tmp;
#endif
	char *buf = F_CHARP(bufa);
	float dx, dy, dc, upix, upiy, tl;
	float xs, ys, rx, ry, dpar, dperp, dxc, dyc;
	int i, irx, iry;
	long differ;

	newpage = 0;
	if (Cex != 1)
		fprintf(outfile,".ps %g\n",10.*Cex);
	F77_SUB(zcposz)(&dx, &dy, &dc, &upix, &upiy, &differ);
	tl = *pos**n*dc - dc*.5;
	xs = *x-tl*upix;
	ys = *y-tl*upiy;
	am(86) = xs + *n*dx - dx*.5;
	am(87) = ys + *n*dy - dy*.5;
	if (dy == 0 && dx >= 0) {		/* horizontal forward string */
		fprintf(outfile,"\"%s\"",buf);
		if (*pos<0.5)
			fprintf(outfile," ljust with .e");
		else if (*pos>0.5)
			fprintf(outfile," rjust with .w");
		fprintf(outfile," at %g,%g\n",UxR(*x)/1000.,UyR(*y)/1000.);
	} else {
		dpar = Cwid*Cex*(.5-Xoffs)*Xrast;
		dperp = Chgt*Cex*(.5-Yoffs)*Yrast;
		dyc = (dpar*sin(Srt*DEG2RD)+dperp*cos(Srt*DEG2RD))/Yrast;
		dxc = (dpar*cos(Srt*DEG2RD)-dperp*sin(Srt*DEG2RD))/Xrast;
		rx = xs*Xscale + Xorigin - dxc;
		ry = ys*Yscale + Yorigin - dyc;
		dx = dx*Xscale;	/* get inter-center diffs, convert to rasters */
		dy = dy*Yscale;
		if ((fabs(*n*dx)<1.0) && (dy > 0.0)) {
			/* vertical string, no device character rotation */
			dy = -fabs(Chgt*Cex*upiy)/upiy;	/* fudge - couldn't find sgn(3) */
			tl = (1.-*pos)**n*am(75)-.5*am(75);
			ys = *y+tl*upiy;
			ry = ys*Yscale + Yorigin - Chgt*(.5-Yoffs)*Cex;
		}
		for (i=0; i<*n; i++){
			if (ok(rx,am(32),am(33))&&ok(ry,am(34),am(35)))
				if(buf[i]!=' '){
					irx = rx;
					iry = ry;
					seek(&irx,&iry);	/* seek position */
#ifdef F_CHARSTRUCT
					F_CHARP(&tmp) = buf + i;
					point(&tmp,&Srt);
#else
					point(buf+i,&Srt);
#endif
				}
			rx += dx;
			ry += dy;
		}
	}
	if (Cex != 1)
		fprintf(outfile,".ps\n");
	return(S_void);
}


/* called to make sure device is flushed and ready to accept
	text as well as graphic output */
static vector *flush()
{
	fflush(outfile);
	return(S_void);
}


/* read an x-y pair from the device, flag indicates whether
	read was successful or not (a negative value indicates
	no point given and generally terminates higher-level reads)
*/
static vector *getxy(x,y,flag)
long *x,*y,*flag;
{
	F77_SUB(bquxyz)(x,y,flag);
	return(S_void);
}
