#include <stdio.h>
#include <time.h>
#include <pwd.h>
#include <signal.h>
#include <ctype.h>
#include "S.h"
#include "device.h"

#define MAXLINES	500	/* max line elements per polyline */
#define llx		region[0]
#define lly		region[1]
#define urx		region[2]
#define ury		region[3]
#define am(i)		F77_COM(bgrp)[(i)-1]
#define curam(i)	current_am[(i)-1]

/* user-to-raster and raster-to-user conversions */
#define Xorigin		(am(36))
#define Yorigin		(am(38))
#define Xscale		(am(37))
#define Yscale		(am(39))
#define UxR(x)		((int)((x) * Xscale + Xorigin + 0.5))
#define UyR(y)		((int)((y) * Yscale + Yorigin + 0.5))
#define RxU(x)		(((x) - Xorigin) / Xscale)
#define RyU(y)		(((y) - Yorigin) / Yscale)

extern float F77_COM(bgrp)[];
vector *postscript(), *F77_SUB(brdpnz)(), *F77_SUB(bquxyz)();
static vector *wrap(), *flush(), *signalled(), *points(), *lines(),
  		*polygon(), *text(), *segments(), *clear(), *hook();
static int setparam(), bounding_box();

/* next four declarations are the state for this driver */
static device d_postscript = {
	FALSE, 0, NULL, 0, NULL,
	{postscript, wrap, flush, signalled, points, lines,
	 polygon, text, segments, clear, F77_SUB(brdpnz), NULL,
	 hook, NULL, NULL, NULL, NULL, F77_SUB(bquxyz)}
};
static float current_am[200];
static FILE *File;
static int is_command, page, newpage;

vector *
postscript(where, how, landscape, width, height, region, rasters,
	pointsize, font, fonts, nfont, bw, colors, ncolor, preamble, n)
char **where, **fonts, **preamble;
long *how, *landscape, *rasters, *font, *nfont, *bw, *ncolor, *n;
float *width, *height, *region, *pointsize, *colors;
{
	device *new_device();
	char errmsg[256], *user;
	long tloc;
	struct passwd *getpwuid();
	int i, (*osig)();
	float *hue = colors, *sat = hue + *ncolor, *bri = sat + *ncolor;

	if(*pointsize <= 0)
		PROBLEM "Illegal pointsize %g", *pointsize RECOVER(NULL_ENTRY);
	if(*rasters <= 0)
		PROBLEM "Illegal raster resolution %ld", *rasters RECOVER(NULL_ENTRY);
	if(llx >= urx || lly >= ury)
		PROBLEM "Illegal imageable region: %g %g %g %g", llx, lly, urx, ury RECOVER(NULL_ENTRY);

	/* pipe output to a command, or write on a file */
	is_command = *how != 0;
	osig = signal(SIGINT, SIG_IGN);
	File = is_command ? popen(*where, "w") : fopen(*where, "w");
	Perm_open(File);
	signal(SIGINT, osig);
	if(File == NULL)
		PROBLEM "Cannot %s %s for postscript output",
			is_command ? "exec" : "open", *where RECOVER(NULL_ENTRY);

	/* initialize device structure and graphical parameters */
	set_device(new_device(&d_postscript, 0L)->which);
	bounding_box(*landscape, width, height, region);
	for(i = 1; i <= 39; i++)
		am(i) = 0;
	am(20) = (*pointsize/72) * *rasters * .65;	/* x character size */
	am(21) = (*pointsize/72) * *rasters * 1.2;	/* y interline space */
	am(22) = 0;				/* x limits */
	am(23) = *width * *rasters;
	am(24) = 0;				/* y limits */
	am(25) = *height * *rasters;
	am(28) = 1.0 / *rasters;		/* raster size in inches */
	am(29) = am(28);
	am(30) = POSTSCRIPT;			/* some number */
	am(31) = 1;				/* characters rotate */
	am(1) = 1;				/* characters scale */
	F77_SUB(defltz)();			/* set other parameters */
	am(79) = *font;				/* default font */

	/* who am I? what time is it? */
	user = getenv("NAME");
	if(user == NULL) user = getlogin();
	if(user == NULL) user = getpwuid(getuid())->pw_name;
	tloc = time((long *)0);

	/* preamble comments (Appendix C, Postscript Reference Manual) */
	fprintf(File, "%%!PS-Adobe-1.0\n");
	fprintf(File, "%%%%Title: S QPE graphics\n");
	fprintf(File, "%%%%Creator: %s\n", user);
	fprintf(File, "%%%%CreationDate: %s", ctime(&tloc));
	fprintf(File, "%%%%Pages: (atend)\n");
	fprintf(File, "%%%%BoundingBox: %g %g %g %g\n", llx, lly, urx, ury);
	fprintf(File, "%%%%EndComments\n");

	/* PostScript side of driver -- definitions only */
	for(i = 0; i < *n; i++)
		fprintf(File, "%s\n", *preamble++);

	/* send fixed parameters for this run */
	fprintf(File, "\n%% fixed controlling parameters\n");
	fprintf(File, "/Landscape %s def\n", *landscape ? "true" : "false");
	fprintf(File, "/Region [%g %g %g %g] def\n", llx, lly, urx, ury);
	fprintf(File, "/RastersPerInch %ld def\n", *rasters);
	fprintf(File, "/PointSize %g def\n", *pointsize);
	fprintf(File, "/Fonts [\n");
	for(i = 0; i < *nfont; i++)
		fprintf(File, "\t/%s\n", *fonts++);
	fprintf(File, "] def\n");
	fprintf(File, "/Colors [\n");
	for(i = 0; i < *ncolor; i++)
		if(*bw)
			fprintf(File, "\t%g\n", *colors++);
		else
			fprintf(File, "\t[%g %g %g]\n", *hue++, *sat++, *bri++);
	fprintf(File, "] def\n");

	/* initializer is within prologue -- it applies to the whole run */
	fprintf(File, "\n%% all initialization action here\n");
	fprintf(File, "I\n");
	fprintf(File, "\n%%%%EndProlog\n\n");
	page = 0; newpage = 1;
	return(S_void);
}

/*
 * flush() brings the output up to date
 * clear() prints the current page
 * wrap() wraps up the job
 * signalled() erases the current page
 */
static vector *
flush()
{
	fflush(File);
	return(S_void);
}

static vector *
clear()
{
	if(!newpage)
		fprintf(File, "Z\n");
	newpage = 1;
	return(S_void);
}

static vector *
wrap()
{
	if(!newpage)
		clear();
	fprintf(File, "\n%%%%Trailer\n");
	fprintf(File, "W\n");
	fprintf(File, "%%%%Pages: %d\n", page);
	Perm_close(File);
	is_command ? pclose(File) : fclose(File);
	return(S_void);
}

static vector *
signalled()
{
	fprintf(File, " X\n");	/* space before X is important */
	newpage = 1;
	return(flush());
}

#define ALL		0	/* send all parameters */
#define CHANGED		1	/* send only changed parameters */

/*
 * Called at the beginning of each drawing routine.
 */
static
check()
{
	if(newpage) {
		page++;
		fprintf(File, "\n%%%%Page: %d %d\n", page, page);
		fprintf(File, "A\n");
		setparam(ALL);
		newpage = 0;
	} else
		setparam(CHANGED);
}

static struct g_param {
	int amode;
	int nparam;
	char *routine;
} g_param[] = {
	{8,   1, "St"},	/* lty: line type */
	{9,   1, "Sw"},	/* lwd: line width */
	{10,  1, "Sc"}, /* col: color */
	{14,  1, "Sr"}, /* srt: string rotation */
	{15,  1, "Sp"}, /* pch: plotting character */
	{18,  1, "Sx"}, /* cex: character expansion */
	{40,  4, "So"}, /* plt: plot coords in figure region */
	{44,  4, "Sg"}, /* fig: figure coords in page */
	{48,  1, "Sh"}, /* crt: character rotation */
	{65,  1, "Sd"}, /* xpd: clipping flag */
	{79,  1, "Sf"}, /* fnt: font */
	{0}
};

static
setparam(which)
int which;
{
	struct g_param *g;
	int i, changed;

	for(g = g_param; g->amode; g++) {
		changed = 0;
		if(which == CHANGED)
			for(i = 0; i < g->nparam; i++)
				if(am(g->amode+i) != curam(g->amode+i))
					changed = 1;
		if(which == ALL || changed) {
			for(i = 0; i < g->nparam; i++) {
				curam(g->amode+i) = am(g->amode+i);
				fprintf(File, "%g ", curam(g->amode+i));
			}
			fprintf(File, "%s\n", g->routine);
		}
	}
}

static vector *
lines(x, y, n)
float *x, *y;
long *n;
{
	int nn = *n, line = 0;
	
	check();
	fprintf(File, "B\n%d %d M\n", UxR(*x++), UyR(*y++)); 
	while(--nn) {
		fprintf(File, "%d %d L\n", UxR(*x++), UyR(*y++));
		if(++line > MAXLINES) {
			fprintf(File, "C\n");
			line = 0;
		}
	}
	fprintf(File, "E\n");
	return(S_void);
}

static vector *
segments(x1, y1, x2, y2, n)
float *x1, *y1, *x2, *y2;
long *n;
{
	int nn = *n;
	
	check();
	while(nn--)
		fprintf(File, "%d %d %d %d S\n", UxR(*x1++), UyR(*y1++),
						 UxR(*x2++), UyR(*y2++));
	return(S_void);
}

static vector *
polygon(x, y, n)
float *x, *y;
long *n;
{
	int nn = *n;
	
	check();
	fprintf(File, "B\n%d %d M\n", UxR(*x++), UyR(*y++)); 
	while(--nn)
		fprintf(File, "%d %d L\n", UxR(*x++), UyR(*y++));
	fprintf(File, "F\n");
	return(S_void);
}

static vector *
points(xx, yy, n)
float *xx, *yy;
long *n;
{
	long nn = *n, pch = (long)am(15); /* yuk */
	
	check();
	if(pch < 32)
		F77_SUB(dmarkz)(xx, yy, n, &pch);
	else
		while(nn--)
			fprintf(File, "%d %d P\n", UxR(*xx++), UyR(*yy++));
	return(S_void);
}
	
static vector *
text(x, y, bufa, n, pos)
float *x, *y, *pos;
F_CHARTYPE bufa;
long *n;
{
	int nn = *n;
	unsigned char *buf = (unsigned char *)F_CHARP(bufa);
	
	check();
	putc('(', File);
	while(nn--) {
		if(*buf < 040 || *buf >= 0177) {
			fprintf(File, "\\%03o", *buf++);
			continue;
		}
		if(*buf == '(' || *buf == ')' || *buf == '\\')
			putc('\\', File);
		putc(*buf++, File);
	}
	putc(')', File);
	fprintf(File, " %d %d %g T\n", UxR(*x), UyR(*y), *pos);
	next_character_position(*x, *y, *n, *pos);
	return(S_void);
}

/*
 * On input, o says whether the plot should be done
 * in landscape, w and h point to the desired width
 * and height in inches and region is a 4-vector giving the
 * imageable region for this device, in the default
 * coordinate system of PostScript.  On output, w and h
 * point to the actual width and height to be used (at
 * most 99% of the imageable region to avoid using the
 * border rasters of the printer) and region gives the
 * bounding box in default coords.  The bounding box is
 * centered in the imageable region.
 */
static
bounding_box(o, w, h, region)
long o;
float *w, *h, *region;
{
	double wmax = 0.99*(urx - llx);
	double hmax = 0.99*(ury - lly);

	*w *= 72; *h *= 72;
	if(o) {double t = *h; *h = *w; *w = t;}
	if(*w <= 0 || *w > wmax) *w = wmax;
	if(*h <= 0 || *h > hmax) *h = hmax;
	llx += (urx-llx - *w)/2;
	lly += (ury-lly - *h)/2;
	urx = llx + *w;
	ury = lly + *h;
	if(o) {double t = *h; *h = *w; *w = t;}
	*w /= 72; *h /= 72;
}

/*
 * Set ncp parameters -- stolen from ztextz.r.
 * This could be done much more precisely if
 * the PostScript side could communicate back here.
 */
next_character_position(x, y, n, pos)
double x, y, pos;
long n;
{
	float dx, dy, dc, upix, upiy, tl;
	long differ;

	F77_SUB(zcposz)(&dx, &dy, &dc, &upix, &upiy, &differ);
	tl = pos*n*dc - dc/2;
	am(86) = x - tl*upix + n*dx - dx/2;
	am(87) = y - tl*upiy + n*dy - dy/2;
}

PS_raw(s, n)
char **s;
long *n;
{
	int i;

	check();
	for(i = 0; i < *n; i++)
		fprintf(File, "%s\n", s[i]);
}

static vector *
hook(type, x, n, y, m)
float *x, *y;
long *type, *n, *m;
{
	int i;
	
	fprintf(stderr, "type=%d\n", *type);
	for(i = 0; i < *n; i++)
		fprintf(stderr, "%g ", x[i]);
	fprintf(stderr, "\n");
	for(i = 0; i < *m; i++) {
		fprintf(stderr, "%d: ", i);
		scanf("%f", y+i);
	}
	return(S_void);
}
