/*
 *    DISPLAY LIST
 */

extern float F77_COM(bgrp)[];
static float current_am[200];
#define am(i)		F77_COM(bgrp)[(i)-1]
#define curam(i)	current_am[(i)-1]

/*  Defines to turn off the alarm or */
/*  set the alarm for the next second */
#define ALARM_NO     alarm(0)
#ifdef ATT_UNIX
/* for Sys V machines, turn off alarms altogether until fix found
 * for problem of alarm interrupting system calls that cannot then
 * be restarted
 */
#define ALARM_YES    alarm(0)
#else
#define ALARM_YES    alarm(1)
#endif

#define DISPLAY_LIST	1

static char *emalloc(n)		/* malloc() with an error message */
int n;
{
	char *malloc();
	char *p;

	if(p = malloc((unsigned)n)) return p;
	fprintf(stderr,"BAD MALLOC\n");
	return NULL;
}

/* functions called by S */
vector *DNAME();
static vector *wrap(), *flush(), *signalled(), *marks(),
*lines(), *polygon(), *text(), *segments(), *clear(), *input(),
*Menu(), *hook(),  *length();

/* functions written in device driver */
static void USRtext(), USRmrks(), USRlins(), USRpoly(), USRsegs();
static void USRflush(), USRclear(), USRwrap(), USRsignalled();
static void USRinput(), USRhook(), USRlength(), USRamodes();
static void USRamReset();    /* MMM */
static vector *USRmenu();
static void insertItem(), drawItem(), doAmodUpdate(), check();

static device d_DNAME = {
	FALSE			/* active */
	,0			/* which (index into list of devices) */
	,(float *) NULL	/* pointer to parameters */
	,0			/* nlocal */
	,(char *) NULL	/* pointer to local parameters */
	,{			/***** driver routines *****/
		DNAME		/* initialization */
		,wrap		/* wrap up the job */
		,flush		/* bring output up to date */
		,signalled		/* fix up on interrupt */
		,marks		/* draw points */
		,lines		/* draw lines */
		,polygon		/* draw polygon */
		,text		/* draw text */
		,segments		/* draw segments */
		,clear		/* clear canvas */
		,input		/* graphic input */
		,Menu		/* menu */
		,hook		/* hook */
		,NULL		/* seek */
		,NULL		/* point */
		,NULL		/* line */
		,length		/* length */
		,NULL		/* query */
	}
};

static initDisplayList()
{
	/* force initialization of curam */
	int i;
	for (i=1; i<=200; i++) curam(i)= -1.1;
}

static int keepDisplayList = DISPLAY_LIST;

#define TEXT	1	/* display list item types */
#define MRKS	2
#define LINS	3
#define POLY	4
#define SEGS	5
#define AMOD	6

/* display list data structures */

typedef struct displayItem {
	struct displayItem	*nextItem;
	int			itemType;
} 
DisplayListItem;

typedef struct {
	DisplayListItem	*nextItem;
	int		itemType;
	float		adj;
	float		xy[2];
	char		str[1];
} 
TextItem;

typedef struct {
	DisplayListItem	*nextItem;
	int		itemType;
	int		nxy;
	float		xy[1];
} 
PlotItem;

typedef struct {
	DisplayListItem *nextItem;
	int		itemType;
	int		n;
	float		par[1];
} 
AmodItem;

static DisplayListItem *textItem();
static DisplayListItem *mrksItem();
static DisplayListItem *linsItem();
static DisplayListItem *segsItem();
static DisplayListItem *polyItem();
static DisplayListItem *amodItem();

static DisplayListItem *displayListBase = NULL;
static DisplayListItem *displayListEnd = NULL;

static addToDisplayList(item)
DisplayListItem *item;
{
	if( item ) {
		drawItem(item);
		if( keepDisplayList )
			insertItem(item);
	}
	else
		Eprintf("warning: unable to allocate display list item.\n");
}

static void insertItem(item)
DisplayListItem *item;
{
	if( !displayListBase ) {
		displayListEnd = displayListBase = item;
	}
	else {
		displayListEnd->nextItem = item;
		displayListEnd = item;
	}
	item->nextItem = NULL;
}

static redrawDisplayList()
{
	DisplayListItem *i;

	ALARM_NO;
	check();
	USRclear(TRUE);
	/* MMM	F77_SUB(zscalz)(); */
	if( keepDisplayList ) {
		for( i=displayListBase ; i ; i=i->nextItem )
			drawItem(i);
	}
	ALARM_YES;
}

static freeDisplayList()
{
	DisplayListItem *i;

	for( i=displayListBase ; i ; i=i->nextItem )
		free( (char *) i );
	displayListBase = NULL;
	displayListEnd = NULL;
}

/* functions copying arguments and returning pointers to DisplayListItems */

static DisplayListItem *textItem(x,y,str,strlen,adj)
double x, y;
char *str;
long strlen;
double adj;
{
	TextItem *item = (TextItem *)emalloc(sizeof(TextItem)+(int)strlen);
	item->itemType = TEXT;
	item->xy[0] = x;
	item->xy[1] = y;
	item->adj = adj;
	memcpy(item->str, str, (int)strlen*sizeof(char));
	item->str[strlen] = '\0';
	return (DisplayListItem *)(item);
}

static DisplayListItem *mrksItem(x,y,nxy)
float *x, *y;
long nxy;
{
	PlotItem *item = (PlotItem *)emalloc(sizeof(PlotItem)
	    +(2*(int)nxy-1)*sizeof(float));
	item->itemType = MRKS;
	item->nxy = nxy;
	memcpy((char *) item->xy,        (char *) x, (int) nxy*sizeof(float));
	memcpy((char *)(item->xy + nxy), (char *) y, (int) nxy*sizeof(float));
	return (DisplayListItem *)(item);
}

static DisplayListItem *linsItem(x,y,nxy)
float *x, *y;
long nxy;
{
	PlotItem *item = (PlotItem *)emalloc(sizeof(PlotItem)
	    +(2*(int)nxy-1)*sizeof(float));
	item->itemType = LINS;
	item->nxy = nxy;
	memcpy((char *) item->xy,        (char *) x, (int) nxy*sizeof(float));
	memcpy((char *)(item->xy + nxy), (char *) y, (int) nxy*sizeof(float));
	return (DisplayListItem *)(item);
}

static DisplayListItem *segsItem(x0,y0,x1,y1,nxy)
float *x0, *y0;
float *x1, *y1;
long nxy;
{
	PlotItem *item = (PlotItem *)emalloc(sizeof(PlotItem)
	    +(4*(int)nxy-1)*sizeof(float));
	item->itemType = SEGS;
	item->nxy = nxy;
	memcpy((char *) item->xy,           (char *) x0, (int) nxy*sizeof(float));
	memcpy((char *)(item->xy + nxy),    (char *) y0, (int) nxy*sizeof(float));
	memcpy((char *)(item->xy + 2*nxy),  (char *) x1, (int) nxy*sizeof(float));
	memcpy((char *)(item->xy + 3*nxy),  (char *) y1, (int) nxy*sizeof(float));
	return (DisplayListItem *)(item);
}

static DisplayListItem *polyItem(x,y,nxy)
float *x, *y;
long nxy;
{
	PlotItem *item = (PlotItem *)emalloc(sizeof(PlotItem)
	    +(2*(int)nxy-1)*sizeof(float));
	item->itemType = POLY;
	item->nxy = nxy;
	memcpy((char *) item->xy,        (char *) x, (int) nxy*sizeof(float));
	memcpy((char *)(item->xy + nxy), (char *) y, (int) nxy*sizeof(float));
	return (DisplayListItem *)(item);
}

static DisplayListItem *amodItem(par,n)
float *par;
int n;
{
	AmodItem *item = (AmodItem *)emalloc(sizeof(AmodItem)+(2*n-1)*sizeof(float));
	item->itemType = AMOD;
	item->n = n;
	memcpy((char *) item->par,  (char *) par, (int) 2*n*sizeof(float));
	return (DisplayListItem *)(item);
}

/*
 *	DRAWING ROUTINES CALLED BY S
 */

static vector *text(x,y,str,l,adj)
float *x, *y, *adj;
F_CHARTYPE str;
long *l;
{
	ALARM_NO;
	check();
	addToDisplayList( textItem(*x,*y,F_CHARP(str),*l,*adj) );
	ALARM_YES;
	return S_void;
}

static vector *marks(x,y,n)
float *x, *y;
long *n;
{
	ALARM_NO;
	check();
	addToDisplayList( mrksItem(x,y,*n) );
	ALARM_YES;
	return S_void;
}

static vector *lines(x,y,n)
float *x, *y;
long *n;
{
	ALARM_NO;
	check();
	addToDisplayList( linsItem(x,y,*n) );
	ALARM_YES;
	return S_void;
}

static vector *segments(x0,y0,x1,y1,n)
float *x0, *y0, *x1, *y1;
long *n;
{
	ALARM_NO;
	check();
	addToDisplayList( segsItem(x0,y0,x1,y1,*n) );
	ALARM_YES;
	return S_void;
}

static vector *polygon(x,y,n)
float *x, *y;
long *n;
{
	ALARM_NO;
	check();
	addToDisplayList( polyItem(x,y,*n) );
	ALARM_YES;
	return S_void;
}

static void drawItem(item)
DisplayListItem *item;
{
	TextItem  *titem;
	PlotItem  *pitem;
	int        n;

	switch(item->itemType) {
	case TEXT:
		titem = (TextItem *) item;
		USRtext(titem->xy, titem->xy + 1, titem->str, titem->adj);
		break;
	case MRKS:
		pitem = (PlotItem *) item;
		USRmrks(pitem->xy, pitem->xy + pitem->nxy, pitem->nxy);
		break;
	case LINS:
		pitem = (PlotItem *) item;
		USRlins(pitem->xy, pitem->xy + pitem->nxy, pitem->nxy);
		break;
	case SEGS:
		pitem = (PlotItem *) item;
		n = pitem->nxy;
		USRsegs(pitem->xy, pitem->xy + n, pitem->xy + 2*n, pitem->xy + 3*n, n);
		break;
	case POLY:
		pitem = (PlotItem *) item;
		USRpoly(pitem->xy, pitem->xy + pitem->nxy, pitem->nxy);
		break;
	case AMOD:
		doAmodUpdate( (AmodItem *) item);
		break;
	}
}

static void doAmodUpdate(item)
AmodItem *item;
{

	/* AmodItems have 2 functional members:
	     1 - a int which is the number of changed amodes
	     2 - a float containing both the indicies of the changed amodes
	         and their values, arranged in adjacent pairs.  */

	int i, ii;
	int scale_flag = 0;
	for( i=0 ; i < 2*(item->n) ; i+=2 ) {
		ii = item->par[i];
		switch(ii)
		{
		case 40:
		case 41:
		case 42:
		case 43:
		case 44:
		case 45:
		case 46:
		case 47:
		case 61:
		case 62:
		case 63:
		case 64:
			scale_flag = 1;
		}
		am(ii) = item->par[i+1];
		USRamodes(ii);
	}
	if (scale_flag) F77_SUB(zscalz)();  /* Don't understand */
}

static void check()
{
	float *x;
	int count, i, ii;
	count = 0;
	/* comparing am and curam */
	for( i=1 ; i<=131 ; i++ ) {
		if( i>21 && i<26 ) continue;
		if( i>35 && i<40 ) continue;
		if( am(i)!= curam(i) ) count++;
	}
	if( count != 0 )
	{
		x = (float *)emalloc(2*count*sizeof(float));
		ii = 0;
		for( i=1 ; i<=131 ; i++ )
			if( am(i)!=curam(i)) {
				curam(i) = am(i);
				if( i>21 && i<26 ) continue;
				if( i>35 && i<40 ) continue;
				x[ii] = i;
				x[ii+1] = am(i);
				ii += 2;
			}
		addToDisplayList( amodItem(x,count) );
	}
}

/* OTHER ROUTINES CALLED BY S
 *
 * flush() brings the output up to date
 * clear() prints the current page
 * wrap() wraps up the job
 * signalled() fixes up if interrupt or other signal occurs
 */

static vector *flush()
{
	USRflush();
	return S_void;
}

static vector *clear()
{
	ALARM_NO;
	USRclear(FALSE);
	USRamReset();      /* MMM to reset am and call zzdevz */
	freeDisplayList();
	ALARM_YES;
	return S_void;
}

static vector *wrap()
{
	ALARM_NO;
	USRwrap();
	freeDisplayList();
	return S_void;
}

static vector *signalled()
{
	USRsignalled();
	return S_void;
}

/*
 * ADDITIONAL FUNCTION CALLS FROM S
 */

static vector *input(x, y, n, nmax)
float x[], y[];
long *n, *nmax;
{
	USRinput(x, y, n, nmax);
	return S_void;
}

static vector *Menu(ent,arglist)
vector *ent, *arglist;
{
	return(USRmenu(ent, arglist));
}

static vector *hook()
{
	USRhook();
	return S_void;
}

static vector *length()
{
	USRlength();
	return S_void;
}
