#include <stdio.h>
#include "S.h"
#include <math.h>
#include <sys/param.h>
#ifdef ATT_UNIX
#include <sys/types.h>
#endif
#include <sys/times.h>
#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include "y.tab.h"
#include "eval.h"
#include "options.h"
#include "infix.h"
#include "sys_codes.h"
#include "dist.h"
#include "device.h"

vector *S_colon(), *S_list(), *S_unlist(), *S_new_vector();
vector *S_cat(), *S_paste(), *S_system(), *S_match(), *S_sort_list();
vector *S_clock(), *S_parse(), *S_sync(), *S_dtype(), *S_interface(), *S_rep();
vector *S_version(), *As_vector(), *Is_vector(), *combine(), *do_na_out();
fun_ptr get_entry();
int cmpx_cmp();
int sys_index, runit_pid;
char *ftn_symbol(), *c_symbol();
void call_S(), Eprintf(), init_load(), clock_init();

static vector *dyn_load(), *relocate(), *find_text();
static long c_data();
static int double_cmp(), float_cmp(), int_cmp(), char_cmp(), recognize();
static int qorder1(), qorderb();
static char *get_symbol_name(), *ok_calloc(), *ok_malloc();
static void colonp(), colonx(), c_stats(), do_spawn(), do_exec(), cmd_error();
static void qorder(), source_err(), intf_err(), sub_err(), do_l_hash(), adjust();
static void ok_fread(), ok_fseek(), ok_free();
static char *sub_name;

vector *
S_colon(ent, arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree, *value;
	vector *efrom = fnd_data(args[0]), *eto = fnd_data(args[1]);
	int mode;
	long length;
	double from, to;

	if(coerce_to(data_mode(efrom), DOUBLE) != DOUBLE)
		Recover("First argument isn't a number", ent);
	if(coerce_to(data_mode(eto), DOUBLE) != DOUBLE)
		Recover("Second argument isn't a number", ent);
	from = double_value(efrom); to = double_value(eto);
	colonp(from, to, &mode, &length);
	value = alcvec(mode, length);
	colonx(value->value.Double, value->value.Long);
	return(value);
}

static long ifrm, it, n, ib, isint;
static double f, t, b;

static void 
colonp(from, to, mode, length)
double from, to;
int *mode;
long *length;
{
	double af, at, dn;

	f = from; t = to;
	af = fabs(f); at = fabs(t);
	isint = af <= INTEGER_MAX && af-floor(af) <= DOUBLE_EPS*af &&
		at <= INTEGER_MAX && at-floor(at) <= DOUBLE_EPS*at;
	if(isint) {
		if(f<t) ib = 1; else ib = -1;
		if(f>0)ifrm = f+.5;
		else if(f<0)ifrm = f-.5;
		else ifrm = 0;
		if(t>0.) it = t + 5*SINGLE_EPS;
		else it = t - 5*SINGLE_EPS;
		dn = (it-ifrm)/ib+1;	/* avoid increasing TO */
		*mode = INT;
	} else {
		if(f<t) b = 1.; else b = -1.;
		dn = (t-f)/b + 1 + 50*SINGLE_EPS;
		*mode = DOUBLE;
	}
	if(dn > INTEGER_MAX)
		Recover("Result too long", NULL_ENTRY);
	*length = n = dn;
}

static void 
colonx(s, is)
double *s;
long *is;
{
	long i;

	if(isint)
		for(i=0; i<n; i++)
			*is++ = ifrm + i*ib;
	else {
		for(i=0; i<n; i++)
			*s++ = f + i*b;
	}
}

/*
 * Make a list out of the arguments.
 * sys_index = 1: construct a LIST; list(...)
 * sys_index = 2: construct a FUN_CALL; call(fun, ...)
 */
vector *
S_list(ent, arglist)
vector *ent, *arglist;
{
	int which = sys_index;
	vector **args = arglist->value.tree, *value, **values, *arg;
	long n = arglist->length;

	if(which < 1 || which > 2)
		Recover(enci1("unknown index (%ld) in S_list", (long)which), ent);
	if(which == 2 && (n < 1 || (n == 1 && VOID(*args))))
		Recover("missing first argument", ent);
	value = alcvec(which == 1 ? LIST : FUN_CALL, n);
	values = value->value.tree;
	while(n--) {
		arg = *args++;
		if(!VOID(arg))
			*values++ = PRECIOUS(arg) ? copy_data(arg,NULL_ENTRY) : arg;
	}
	value->length = values - value->value.tree;
	if(which == 2) {
		arg = *value->value.tree;
		if(data_mode(arg) != FUN_DEF)  /* make function mode NAME */
			*value->value.tree = alc_name(string_value(arg));
	}
	return(value);
}

/*
 * Concatenate vectors.
 * sys_index = 1: vectors are arguments; c(..., recursive=F)
 * sys_index = 2: vectors are elements of a list; unlist(x, recursive=T)
 */
vector *
S_unlist(ent, arglist)
vector *ent, *arglist;
{
	int which = sys_index, recursive;
	vector **args = arglist->value.tree, *value, **values;
	long n = arglist->length;

	if(which < 1 || which > 2)
		Recover(enci1("unknown index (%ld) in S_unlist", (long)which), ent);
	recursive = args[--n]->value.Long[0];
	if(which == 2) {
		if(n != 1)
			Recover(enci1("can only unlist exactly one vector; %ld supplied", n), ent);
		arglist = args[0];
		args = arglist->value.tree;
		n = arglist->length;
	}
	if(NOT_RECURSIVE(data_mode(arglist)))
		return(arglist);
	if(arglist->mode == STRUCTURE) {
		arglist = xact_comp(arglist, ".Data");
		args = arglist->value.tree;
		n = arglist->length;
	}
	value = alcvec(LIST, n);
	values = value->value.tree;
	while(n--) {
		vector *arg = *args++;
		if(!VOID(arg) && arg->mode != NULL)
			*values++ = PRECIOUS(arg) ? copy_data(arg, NULL_ENTRY) : arg;
	}
	value->length = values - value->value.tree;
	return(combine(value, recursive));
}

vector *
combine(args, recursive)
vector *args;
int recursive;
{
	vector *value, *names;
	int named = FALSE, mode = 0;
	long length = 0;

	if(args->length == 0)
		return(blt_in_NULL);
	c_stats(args, &mode, &length, &named, recursive);
	value = alcvec(mode, length);
	if(length == 0)
		return(value);
	names = named ? alcvec(CHAR, length) : NULL_ENTRY;
	(void)c_data(value, mode, names, 0L, args, recursive);
	if(named)
		(void)set_names(value, names);
	return(value);
}

static void 
c_stats(args, mode, length, named, recursive)
vector *args;
int *mode, *named, recursive;
long *length;
{
	vector **vv = args->value.tree, *v, *vactual;
	long n = args->length, l;
	int m;

	while(n--) {
		vactual = v = *vv++;
		if(v->mode == STRUCTURE)
			v = find_comp(v, ".Data");
		l = v->length;
		if(l == 0)
			continue;
		if(l == 1 && *named == FALSE &&
		   !IS_NULL_STRING(vactual->name) && !has_names(vactual))
			*named = TRUE;
		m = v->mode;
		if(recursive && !NOT_RECURSIVE(m))
			c_stats(v, mode, length, named, recursive);
		else {
			*mode = coerce_to(*mode, m);
			*length += v->length;
			if(*named == FALSE && has_names(vactual))
				*named = TRUE;
		}
	}
}

static long 
c_data(value, mode, names, start, args, recursive)
vector *value, *names, *args;
int mode;
long start;
int recursive;
{
	vector **vv = args->value.tree, *v, *vactual, *vnames;
	long n = args->length, l;
	int m;

	while(n--) {
		vactual = v = *vv++;
		if(v->mode == STRUCTURE)
			v = find_comp(v, ".Data");
		m = v->mode;
		if(recursive && !NOT_RECURSIVE(m)) {
			start = c_data(value, mode, names, start, v, recursive);
			continue;
		}
		v = coevec(v, mode, FALSE, PRECIOUS(v));
		if(!atomic_type(mode) && PRECIOUS(v))
			v = copy_data(v, NULL_ENTRY);
		l = v->length;
		if(l == 0)
			continue;
#define Copy(e,t) {t *from = v->value.e; t *to = value->value.e + start;\
		   MEMCPY(to, from, l); break;}
		switch(mode) {
		case NULL:
		case MISSING:	break;
		case INT:
		case LGL:	Copy(Long, long)
		case REAL:	Copy(Float, float)
		case DOUBLE:	Copy(Double, double)
		case COMPLEX:	Copy(Complex, complex)
		case CHAR:	Copy(Char, char *)
		default:	Copy(tree, vector *)
		}
		if(names != NULL_ENTRY) {
			char **to = names->value.Char + start;
			vnames = get_names(vactual);
			if(vnames != blt_in_NULL) {
				char **from = vnames->value.Char;
				MEMCPY(to, from, l);
			} else if(v->length == 1 && !IS_NULL_STRING(vactual->name))
				*to++ = vactual->name;
			else {
				long k = l;
				while(k--)
					*to++ = "";
			}
		}
		start += l;
		if(!PRECIOUS(v))
			try_to_free(v, FALSE);
	}
	return(start);
}

vector *
S_unprotect(ent, arglist)
vector *ent, *arglist;
{
	vector *object, **objs; char *name; long n; int found;
	object = ent->value.tree[1];
	UNUSED(arglist);

	if(object->mode!=NAME) /* and  must be literal, so no data_mode */
		Recover("argument must be a name",NULL_ENTRY);
	name = object->value.name; found = FALSE;
	for(objs = Local_data->value.tree, n = 0;
	  n<Local_data->length; n++, objs++)
		if(name_eq((*objs)->name,name)) { found = TRUE; break;}
	if(!found) Recover(encs1("\"%s\" is not an object in the local frame",name),NULL_ENTRY);
	object = New_vector(); *object = **objs;
	if(object->x.frame == Local_data) set_precious(object,NULL_ENTRY);
	  /* foreign objects have to be protected anyway */
	del_comp(Local_data,n+1);
	return(object);
}

vector *
S_new_vector(ent, arglist)
vector *ent, *arglist;
{
	int mode;
	long length;
	vector **args = arglist->value.tree, *arg;
	UNUSED(ent);

	if(arglist->length > 1) {
		mode = mode_lookup(string_value(args[0]));
		length = long_value(args[1],ent);
	}
	else {
		mode = sys_index;
		length = long_value(args[0],ent);
	}
	if(is_na(&length)) length = 0;
	if(min_length(mode)>length) {
		char *fmt = encs1("length (%%ld) less than the minimum (%%ld) for mode \"%s\"",
			string_value(args[0]));
		Recover(enci2(fmt,length,min_length(mode)), NULL_ENTRY);
	}
	arg = alcvec(mode,length);
	return(arg);
}

vector *
As_vector(ent, arglist)
vector *ent, *arglist;
{
	int mode;
	vector **args = arglist->value.tree, *data;
	UNUSED(ent);
 	mode = arglist->length > 1 ? mode_lookup(string_value(args[1])) : sys_index;
	data = args[0];
	return(coevec(data, mode, FALSE, CHECK_IT));
}

vector *
Is_vector(ent, arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree, *data = args[0];
	int mode,dmode;
	UNUSED(ent);

	if(data->mode == STRUCTURE)
		if(sys_index == 1000)return(blt_in_FALSE);
		else if(!(data = find_comp(data, ".Data")))return(blt_in_FALSE);
	dmode = data->mode;
	if(sys_index == 1000 && name_eq(string_value(args[1]),"numeric"))
		return(dmode == DOUBLE || dmode == REAL || dmode == INT) ?
			blt_in_TRUE : blt_in_FALSE;
	mode = arglist->length > 1 ? mode_lookup(string_value(args[1])) : sys_index;
	return((mode==ANY || data->mode==mode) ? blt_in_TRUE : blt_in_FALSE);
}

vector *
S_cat(ent, arglist)
vector *ent, *arglist;
{
	vector **args, *arg, *labvec;
	long n, nstring, col, this_len, pwidth, nlabel, i, sep_len;
	int fill, label;
	char **strings, **labels, *sep, *file, *open_mode;
	FILE *f = NULL;
	UNUSED(ent);

	args = arglist->value.tree;
	n = arglist->length - 5; /* all but file, sep, fill, labels, append */
	file = string_value(args[n]);
	if(!*file) {file = NULL_STRING; f=stdout;}
	sep = string_value(args[n+1]);
	if((args[n+2])->mode == LGL){
		fill = logical_value(args[n+2],ent);
		if(f == stdout) {
			int ll, pl;
			window_size(&ll, &pl);
			pwidth = ll;
		} else
			pwidth = S_p_width > 0 ? S_p_width : 80;
	}
	else {pwidth = long_value(args[n+2],ent); fill = (pwidth>0);}
	labvec = args[n+3];
	open_mode = logical_value(args[n+4],ent) ? "a" : "w"; /* append or write*/
	nlabel = labvec->length;
	label = nlabel > 0;
	sep_len = strlen(sep);
	if(file && (f=fopen(file,open_mode))==NULL) {
		Recover(encs1("couldn't open file \"%s\" in cat",file),NULL_ENTRY);
		return(S_void);
	}
	MEANINGFUL(labels);
	if(label) {
		labvec = coevec(labvec,CHAR,FALSE,CHECK_IT);
		labels = labvec->value.Char;
	}
	MEANINGFUL(i); MEANINGFUL(col);
	if(fill){i=0; col=label?pwidth:0;}
	while(n--) {
		arg = *args++;
		arg = coevec(arg,CHAR,FALSE,CHECK_IT);
		nstring = arg->length; strings = arg->value.Char;
		while(nstring--) {
			if(fill) {
				this_len = strlen(*strings) + sep_len;
				if(col + this_len > pwidth) {
					fputc('\n',f);
					if(label) {
						fprintf(f,"%s ",*(labels+i));
						col = strlen(labels[i])+2+this_len;
					}
					else col=this_len;
				}
				else col += this_len;
				if(label && ++i >= nlabel) i = 0;
			}
			fputs(*strings++, f);
			if(n||nstring) fputs(sep,f);
		}
	}
	if(fill||*sep=='\n')fputc('\n',f);
	fflush(f);
	if(file)fclose(f);
	return(S_void);
}

vector *
S_paste(ent,arglist)
vector *ent, *arglist;
{
	long n, nn, nmax, *lengths, *l, *sl, ll, stotal, *slengths;
	char **strings, *text, *sep, *p, *record;
	vector **args, *arg, **char_args, *value, **values;
	int collapse;
	UNUSED(ent);

	args = arglist->value.tree; n = arglist->length-2; /* ... */
	sep = string_value(args[n]);
	collapse = (arg = args[n+1])->length>0;
	MEANINGFUL(record);
	if(collapse)record = string_value(arg);
	lengths = (long *)S_alloc(2*n,sizeof(long));
	nmax=collapse; nn=n; l = lengths; stotal=0;
	char_args = values = (vector **)S_alloc(n,sizeof(vector *));
	while(nn--) {
		long sss, smax;
		*char_args = arg = coevec(*args,CHAR,FALSE,CHECK_IT);
		if(!VOID(arg)) {
			if( (ll = *l = arg->length) >nmax) nmax = ll;
			strings = arg->value.Char; smax = 0;
			while(ll--){
				sss = strlen(*strings++);
				if(sss>smax)smax=sss;
			}
			stotal += smax;
		}
		args++; l++; char_args++;
	}
	ll = stotal*nmax /* the max. size of the pasted strings themselves */
		+ (strlen(sep)*(n?n-1:0) /* the inter-argument separators */
		+ (collapse?strlen(record):1))*nmax /* the record separators,
			OR the individual '\0's */
		+ 1; /* the final '\0' in the collapse case */
	value = alcvec(CHAR,nmax); text = S_alloc(ll,sizeof(char));
	strings = value->value.Char;
	sl=slengths = lengths+n; nn=n; while(nn--) *sl++ = 0;
	while(nmax--){
		*strings++ = text;
		sl=slengths; l=lengths; args=values; nn=n;
		while(nn--) {
			if(*l>0){
				p = *((*args)->value.Char + *sl);
				while(*p) *text++ = *p++;
				if(++(*sl) == *l) *sl = 0;
			}
			if(nn) {
				p = sep;
				while(*p) *text++ = *p++;
			}
			l++; sl++; args++;
		}
		if(collapse && nmax) {
			p = record;
			while(*p) *text++ = *p++;
		}
		else *text++ = '\0';
	}
	if(collapse)value->length = 1;
	return(value);
}

static int 
double_cmp(i,j)
double *i, *j;
{	double x = ( *i - *j);return(x>0.?1:(x<0.? -1 : 0));	}

/*following not static because used by comparison operators as well */
int 
cmpx_cmp(i,j)
complex *i, *j;
{	double x;
	x = i->re - j->re;
	if(x!=0.)return(x>0.?1:-1);
	x = i->im - j->im;
	return(x>0.?1:(x<0.? -1 : 0));
}

static int 
float_cmp(i,j)
float *i, *j;
{	float x = ( *i - *j);return(x>0.?1:(x<0.? -1 : 0));	}

static int 
int_cmp(i,j)
long *i, *j;
{	return(*i - *j);	}

static int 
char_cmp(cc1,cc2)
char **cc1, **cc2;
{
	return(strcmp(*cc1,*cc2));
}

vector *
S_system( ent, arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree;
	vector *arg = coevec(args[0], CHAR, TRUE, CHECK_IT);
	int pipe = logical_value(args[1],ent), stat;
	char *command;
	FILE *p;
	long nn;

	if(arg->length > 1)
		Warning("Only one string for command", ent);
	command = *arg->value.Char;
	if(pipe){
		char *copy, *text, *c1, *c2;vector *alcchar();
		if((p=popen(command,"r"))==NULL) {
			perror("Cannot execute UNIX command");
			fprintf(stderr,"Command was: \"%s\"\n",command);
			Recover(NULL_STRING,NULL_ENTRY);
		}
		arg = alcvec(CHAR,0L);
		text = S_alloc((long)BUFSIZ,sizeof(char));
		while(fgets(text,BUFSIZ,p) != NULL){
			nn = strlen(text);
			if(*(text+nn-1)!='\n')continue; /*not a real line*/
			else *(text+nn-1) = '\0';
			copy = S_alloc(nn,sizeof(char));
			c1=copy; c2=text;
			while(--nn)*c1++ = *c2++;
			if(arg->nalloc>arg->length)
				*(arg->value.Char+(arg->length++)) = copy;
			else append_el(arg,arg->length,alcchar(copy));
		}
		stat=pclose(p);
	}
	else {
		stat = system(command);
		if(stat==127)stat= -1; /* code used in Berkeley, etc. */
		arg = alcvec(INT,1L);
		arg->value.Long[0] = stat;
		arg->status |= NO_PRINT_BIT;
	}
#ifdef Research
	if(stat == -1){
#else
	if(stat < 0){
#endif
		fprintf(stderr,"Unix command exit status %d\n",stat);
		Recover(encs1("Error exit from unix command \"%s\"",command),NULL_ENTRY);
	}
	else if(stat && pipe)
		Warning(encs1("Error exit from unix command \"%s\"",command),NULL_ENTRY);
	return(arg);
}

static int pipe_fd = -1,sp_to = -1,sp_from = -1, nspawn = 0;
static FILE *sh_from, *sh_to;
static char nudge[] = "echo 976976 $? >&xx  ";

#define MAX_SPAWN 5

static void 
do_spawn()
{
	int from[2], to[2];
	char *getenv();

	if(++nspawn > MAX_SPAWN)
		S_terminate("Too many dead spawned processes");
	if(pipe_fd != -1)close(pipe_fd); /* close pipes if this is a retry */
	if(sp_from != -1)close(sp_from);
	if(sp_to != -1)close(sp_to);
	pipe(to); pipe(from);
#ifdef Berkeley
	runit_pid = vfork();
#else
	runit_pid = fork();
#endif
	if( runit_pid == 0 ) { /*child process */
		char pgm[60]; char ret_fd[10], cmd_fd[10];
		close(to[1]); close(from[0]);	/* shut down one end of pipes */
		sprintf(ret_fd,"%ld",from[1]);sprintf(cmd_fd,"%ld",to[0]);
		sprintf(pgm,"%s/cmd/runit",getenv("SHOME"));
		execl(pgm,pgm,ret_fd,cmd_fd, 0);
		/* shouldn't get here: abort parent, child */
		kill(mainpid,SIGKILL);
		S_terminate(encs1("Cannot execute system program, \"%s\"",pgm));
		}
	else { /* parent process */
		close(to[0]); close(from[1]);	/* close down other end of pipes */
		sprintf(nudge,"echo 976976 $? >&%d\n",from[1]);
		sp_to = to[1];
		sp_from = from[0];
		pipe_fd = from[1];
		sh_to = fdopen(sp_to,"w");
		sh_from = fdopen(sp_from,"r");
		if(sh_to == NULL || sh_from == NULL)
			S_terminate("Couldn't open FILE pipes for exec()");
		}
}

static long cmd_number = 0;

static void 
do_exec(cmd)
char *cmd;
{
	long signal,status; int ok;
	fputs(cmd,sh_to); /* send the command */
	fputs(nudge,sh_to); /* and the marker of  completion */
	ok = fscanf(sh_from,"%ld%ld",&signal,&status);
	if(ok<2 || signal!=976976)
		Recover("Error in exec(): didn't get status back", NULL_ENTRY);
	if(status)Warning(enci1("Command exited with error status(%ld)",status),NULL_ENTRY);
}

static int state;

#define WRITING 1
#define READING 2

vector *
S_do_cmd(ent, arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree;
	vector *arg = coevec(args[0], CHAR, TRUE, CHECK_IT), *value;
	int pipe = logical_value(args[1],ent);
	long n;
	char *string, **cmds;
	UNUSED(ent);

	value = pipe ? alcvec(CHAR,0L) : alcvec(INT,1L);
	cmds = arg->value.Char;
	if(!cmd_number)do_spawn();
	cmd_number++;
	add_error((fun_ptr)cmd_error);
	state = WRITING;
	fputs("\001\001\001\001",sh_to);
	fprintf(sh_to," %ld\n",cmd_number);
	fflush(sh_to); /* starts runit going */
	signal(SIGINT,SIG_IGN);
	n=arg->length;
	while(n--){
		fputs(*cmds++,sh_to);
		if(n || !pipe)putc('\n',sh_to);
		else fprintf(sh_to," >&%ld 2>&1\n",pipe_fd);
	}
	fputs("\001\001\001\001",sh_to);
	fprintf(sh_to," %ld\n",cmd_number);
	fflush(sh_to);
	state = READING;
	for(;;) { /* read the result, looking for an acknowlegement */
		if(pipe) {
			string = sgets(sh_from,0L);
			if(string[0]=='\001' && string[1]=='\001'
			   && string[2]=='\001' && string[3]=='\001'){
				if(n=recognize(string))
				 Warning(enci1("Command returned status %ld",n),NULL_ENTRY);
				break;
			}
			append_data(value,value->length,1L,(char *)&string);
		}
		else {
			if(getc(sh_from)=='\001' && getc(sh_from)=='\001'
			   && getc(sh_from)=='\001' && getc(sh_from)=='\001') {
			   	*value->value.Long = recognize((char *)NULL);
				break;
			}
		}
	}
	signal(SIGINT,catchall);
	del_error((fun_ptr)cmd_error);
	return(value);
}

static void 
cmd_error()
{
	signal(SIGINT,catchall);
	del_error((fun_ptr)cmd_error);
	switch(last_signal) {
	case SIGPIPE:
		if(state==WRITING) cmd_number = 0; /* signal respawn */
		break;
#ifdef ATT_UNIX
	case SIGCLD:
#else
	case SIGCHLD:
#endif
		cmd_number = 0;
		break;
	}
	if(state==WRITING)fprintf(sh_to," %ld\n",cmd_number);
}

static int 
recognize(string)
char *string;
{
	long n, i, status;
	if(string) i=sscanf(string+4,"%ld%ld",&n, &status);
	else {
		i = fscanf(sh_from,"%ld%ld",&n, &status);
		while(getc(sh_from)!='\n'){} /*eject this line */
	}
	if(i<2)Recover("Couldn't read return code from executing command",NULL_ENTRY);
	if(n!=cmd_number)Recover(enci2("Sent command code %ld, read %ld",cmd_number,n),NULL_ENTRY);
	return(status);
}

/*
static vector *
replace_in(dataset, data, max)
vector *dataset, *data; long max;
{
	vector **children, *append_el(), *value; long n;
	if(dataset!=data) {
		if(VOID(dataset) || atomic_type(dataset->mode))return(NULL_ENTRY);
		n=dataset->length; children=dataset->value.tree;
		while(n--) {
			if((value=replace_in(*children,data,max))!=NULL_ENTRY){
				*children = value;
				return(dataset);
			}
			children++;
		}
		return(NULL_ENTRY);
	}
	return(append_el(data,max,blt_in_NA));
}
*/

vector *
S_match(ent, arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree;
	vector *x = coevec(args[0], ANY, FALSE, CHECK_IT);
	vector *list, *arg, **evalues;
	long n, pattern, index, pos, junk, hash_length;
	long *values, *outvalue;
	char **cvalues; double *dvalues;
	float *fvalues; complex *cxvalues;
	x_h **hash_table;
	int mode, which = sys_index;
	UNUSED(ent);

if(check) {
	sanity(arglist, "vector arg to match");
}
	MEANINGFUL(pattern);
	if(which != 1){ /* match */
		list = coevec(args[1], ANY, FALSE, CHECK_IT);
		mode = coerce_to(x->mode,list->mode);
		if(mode==NAME || mode==SYSTEM)mode=CHAR;
		if(x->mode != mode) x = coevec(x,mode,FALSE,PRECIOUS(x));
		if(list->mode != mode) list = coevec(list,mode,FALSE,PRECIOUS(list));
		arg = coevec(args[2],INT,FALSE,PRECIOUS(args[2]));
		if(!arg->length)Recover("Need an integer value for pattern argument",NULL_ENTRY);
		pattern = arg->value.Long[0];
	}
	else { /* duplicated() */
		list = x; mode = list->mode;
	}
	arg = alcvec(which?LGL:INT,x->length); outvalue = arg->value.Long;
	n=list->length;	/* hash the list */
	hash_length= 3*n/2; if(hash_length<20)hash_length=20;
	/* hash table will be the
	/*smallest prime >= 1.5*n, but not smaller than 23 */
	nprime(&hash_length);
	hash_table = (x_h **)S_alloc(hash_length,sizeof(x_h *));
	/* enter the list values into hash table: enter only the first
	/* occurence of the value */
	index = 1;
	switch(mode) {
	case REAL:
		fvalues = list->value.Float;
		while(n--){
			if(!hash((char *)fvalues,REAL,&junk,&pos,hash_table,hash_length))
				hash_enter((char *)fvalues,REAL,index,pos,hash_table,hash_length);
			else if(which) *outvalue = TRUE;
			index++; fvalues++; if(which)outvalue++;
		}
		break;
	case LGL:
	case INT:
		values = list->value.Long;
		while(n--){
			if(!hash((char *)values,INT,&junk,&pos,hash_table,hash_length))
				hash_enter((char *)values,INT,index,pos,hash_table,hash_length);
			else if(which) *outvalue = TRUE;
			index++; values++; if(which)outvalue++;
		}
		break;
	case CHAR:
		cvalues = list->value.Char;
		while(n--){
			if(!hash(*cvalues,CHAR,&junk,&pos,hash_table,hash_length))
				hash_enter(*cvalues,CHAR,index,pos,hash_table,hash_length);
			else if(which) *outvalue = TRUE;
			index++; cvalues++; if(which)outvalue++;
		}
		break;
	case DOUBLE:
		dvalues = list->value.Double;
		while(n--){
			if(!hash((char *)dvalues,DOUBLE,&junk,&pos,hash_table,hash_length))
				hash_enter((char *)dvalues,DOUBLE,index,pos,hash_table,hash_length);
			else if(which) *outvalue = TRUE;
			index++; dvalues++; if(which)outvalue++;
		}
		break;
	case COMPLEX:
		cxvalues = list->value.Complex;
		while(n--){
			if(!hash((char *)cxvalues,COMPLEX,&junk,&pos,hash_table,hash_length))
				hash_enter((char *)cxvalues,COMPLEX,index,pos,hash_table,hash_length);
			else if(which) *outvalue = TRUE;
			index++; cxvalues++; if(which)outvalue++;
		}
		break;
	case NAME:
		cvalues = &list->value.name;
		if(!hash((char *)cvalues,CHAR,&junk,&pos,hash_table,hash_length))
			hash_enter((char *)cvalues,CHAR,index,pos,hash_table,hash_length);
		else if(which) *outvalue = TRUE;
		index++;
		break;
	default:
		if(NOT_RECURSIVE(mode))
			Recover(encs1("Matching not defined for mode \"%s\"",token_name(mode)),NULL_ENTRY);
		evalues = list->value.tree;
		while(n--){
			if(!hash((char *)*evalues,mode,&junk,&pos,hash_table,hash_length))
				hash_enter((char *)*evalues,mode,index,pos,hash_table,hash_length);
			else if(which) *outvalue = TRUE;
			index++; evalues++; if(which)outvalue++;
		}
	}
	if(which == 1)return(arg);
	/* now hash in the data */
	n=x->length; outvalue=arg->value.Long;
	switch(mode) {
	case REAL:
		fvalues = x->value.Float;
		while(n--){
			*outvalue++ =
			  hash((char *)fvalues,REAL,&index,&pos,hash_table,hash_length)?
				index : pattern;
			fvalues++;
		}
		break;
	case LGL:
	case INT:
		values = x->value.Long;
		while(n--){
			*outvalue++ = 
			  hash((char *)values,INT,&index,&pos,hash_table,hash_length)?
				index : pattern;
			values++;
		}
		break;
	case CHAR:
		cvalues = x->value.Char;
		while(n--){
			*outvalue++ =  hash(*cvalues,CHAR,&index,&pos,hash_table,hash_length) ?
				index : pattern;
			cvalues++;
		}
		break;
	case DOUBLE:
		dvalues = x->value.Double;
		while(n--){
			*outvalue++ = 
			  hash((char *)dvalues,DOUBLE,&index,&pos,hash_table,hash_length)?
				index : pattern;
			dvalues++;
		}
		break;
	case COMPLEX:
		cxvalues = x->value.Complex;
		while(n--){
			*outvalue++ = 
			  hash((char *)cxvalues,COMPLEX,&index,&pos,hash_table,hash_length)?
				index : pattern;
			cxvalues++;
		}
		break;
	default:
		evalues = x->value.tree;
		while(n--){
			*outvalue++ =  hash((char *)*evalues,mode,&index,&pos,hash_table,hash_length) ?
				index : pattern;
			evalues++;
		}
	}
	return(arg);
}


vector *
S_sort_list(ent, arglist)
vector *ent, *arglist;
{
	vector *arg, *arg2;
	long *l; unsigned n;
	UNUSED(ent);

	arg = coevec(*(arglist->value.tree),ANY,TRUE,FALSE);
	no_nas_allowed(arg);
	arg2 = alcvec(INT,2L*(n = (unsigned)arg->length));
	l = arg2->value.Long;
	switch(arg->mode) {
	case LGL:
	case INT:
		qorder((char *)arg->value.Long,l,n,sizeof(long),int_cmp);
		break;
	case REAL:
		qorder((char *)arg->value.Float,l,n,sizeof(float),float_cmp);
		break;
	case DOUBLE:
		qorder((char *)arg->value.Double,l,n,sizeof(double),double_cmp);
		break;
	case COMPLEX:
		qorder((char *)arg->value.Complex,l,n,sizeof(complex),cmpx_cmp);
		break;
	case CHAR:
		qorder((char *)arg->value.Char,l,n,sizeof(char *),char_cmp);
		break;
	default:
/*could be		qorder((char *)arg->value.tree,l,n,sizeof(vector *),expr_cmp);
/* if that were allowed, and worked */
		Recover(encs1("ordering not defined for mode \"%s\"",token_name(arg->mode)),NULL_ENTRY);
	}
	arg2->length = (long)n;	
	return(arg2);
}


static int	(*qscmp)();
static int	*cmps; long *key2;

static void 
qorder(a, iorder, n, es, fc)
char *a;
long *iorder;
unsigned n;
int es;
int (*fc)();
{
	long i;
	char *malloc();
	qscmp = fc;
	for(i = 0; i<n; i++)iorder[i] = es * i;
	cmps = (int *)malloc(n*sizeof(int));
	key2 = iorder + n;
	qorder1(a, n,iorder);
	for(i = 0; i<n; i++)iorder[i] = iorder[i]/es +1;
	free( ( char *)cmps);
}

static qorder1(a, n,keys)
char *a; unsigned n; long *keys;
{
	long *k, *kl, *kr, *km;
	char *al;
	int c, *j; unsigned l,nl,nr;
	if(n<15) {
		qorderb(a,n,keys);
		return;
	}
	al = a + keys[n / 2]; /* the fence */
	nl = nr =0;
	for(l=0,j = cmps;l<n;l++,j++) {
		c = *j = (*qscmp)(a+keys[l],al);
		if(c<0)nl++; else if(c>0)nr++;
	}
	/* now move the appropriate pieces */
	kl = key2; kr = kl + (n-nr) ; km = kl +nl;
	for(l=0,j = cmps,k = keys;l<n;l++,j++,k++) {
		if( (c = *j) < 0) *kl++ = *k;
		else if( c>0) *kr++ = *k;
		else *km++ = *k;
	}
	memcpy((char *)keys,(char *)(key2),n*sizeof(long));
	if(nl>1)qorder1(a,nl,keys);
	if(nr>1)qorder1(a,nr,keys+n-nr);
}

static 
qorderb(a, n, keys)
char *a; long *keys;
unsigned n;
{
	long nbd, t, save, j;
	char *a1, *a2;
	if(n<2) return;
	for(t=n; t>0; ){
		nbd=t;
		t=0;
		for(j=0; j<nbd-1; j++){
			a1 = a + keys[j]; a2 = a+ keys[j+1];
			if((*qscmp)(a1,a2)>0){
				save=keys[j];
				keys[j]=keys[j+1];
				keys[j+1]=save;
				t=j+1;
			}
		}
	}
}

vector *
do_na_out(arg)
vector *arg;
{
	vector *data;
	char **cptr; long *lptr; float *fptr; double *dptr; vector **vptr;
	char **cout; long *lout; float *fout; double *dout; vector **vout;
	long n; int missing = FALSE; complex *cxptr, *cxout;
	arg = coeves(arg,ANY,FALSE,FALSE,&data); n=data->length;
	switch(data->mode) {
	case LGL:
	case INT:
		lptr = data->value.Long;
		while(n--){missing |= is_na(lptr);lptr++;}
		break;
	case REAL:
		fptr = data->value.Float;
		while(n--){missing |= is_na(fptr);fptr++;}
		break;
	case DOUBLE:
		dptr = data->value.Double;
		while(n--){missing |= is_na(dptr);dptr++;}
		break;
	case COMPLEX:
		cxptr = data->value.Complex;
		while(n--){missing |= is_na(cxptr);cxptr++;}
		break;
	case CHAR:
		cptr = data->value.Char;
		while(n--){missing |= is_na(cptr);cptr++;}
		break;
	default:
		vptr = data->value.tree;
		while(n--){missing |= is_na(vptr);vptr++;}
		break;
	}
	if(!missing)return(arg);
	if(PRECIOUS(arg))data = copy_data(data, NULL_ENTRY);
	n=data->length;
	switch(data->mode){
	case LGL:
	case INT:
		lout = lptr = data->value.Long;
		while(n--){if(!is_na(lptr))*lout++  = *lptr;lptr++;}
		data->length = lout-data->value.Long;
		break;
	case REAL:
		fout = fptr = data->value.Float;
		while(n--){if(!is_na(fptr))*fout++  = *fptr;fptr++;}
		data->length = fout-data->value.Float;
		break;
	case DOUBLE:
		dout = dptr = data->value.Double;
		while(n--){if(!is_na(dptr))*dout++  = *dptr;dptr++;}
		data->length = dout-data->value.Double;
		break;
	case COMPLEX:
		cxout = cxptr = data->value.Complex;
		while(n--){if(!is_na(cxptr))*cxout++  = *cxptr;cxptr++;}
		data->length = cxout-data->value.Complex;
		break;
	case CHAR:
		cout = cptr = data->value.Char;
		while(n--){if(!is_na(cptr))*cout++  = *cptr;cptr++;}
		data->length = cout-data->value.Char;
		break;
	default:
		vout = vptr = data->value.tree;
		while(n--){if(!is_na(vptr))*vout++  = *vptr;vptr++;}
		data->length = vout-data->value.tree;
		break;
	}
	return(data);
}

#ifndef HZ
#define HZ 60.
#endif

static long init_time;

vector *
S_clock(ent, arglist)
vector *ent, *arglist;
{
	vector *val = alcvec(REAL, 5L);
	struct tms buffer;
	long etime, time();
	float *l;
	UNUSED(ent);
	UNUSED(arglist);

	times(&buffer);
	etime = time((long *)0) - init_time;
	l = val->value.Float;
	*l++ = ((float)(buffer.tms_utime))/HZ;
	*l++ = ((float)(buffer.tms_stime))/HZ;
	*l++ = (float)etime;
	if(buffer.tms_cutime>0 || buffer.tms_cstime>0) {
		*l++ = ((float)(buffer.tms_cutime))/HZ;
		*l = ((float)(buffer.tms_cstime))/HZ;
	}
	else val->length = 3;
	return(val);
}

void 
clock_init()
{
	init_time = time((long *)0);
}

static char Parsefile[] = "/tmp/SparsXXXXXX";
static char *prompt, *prev_prompt;
static int P_init = 0;

vector *
S_parse(ent, arglist)
vector *ent, *arglist;
{
	char *file_name; FILE *f;
	int parse_err = 0, which, eof;
	vector **args, *arg;
	long nexpr, nalloc; 

	args = arglist->value.tree;
	which = logical_value(args[4],ent);
	arg=args[2];/* text */
	if(arg->length>0) { /* parse from text argument */
		long nstrings; vector *value; char **strings;
		value=coevec(arg,CHAR,FALSE,CHECK_IT);
		nstrings=value->length; strings=value->value.Char;
		if(!P_init){mktemp(Parsefile); P_init = TRUE;}
		file_name = Parsefile;
		if((f=fopen(Parsefile,"w+"))==NULL){
			Recover("Can't open file for copying parse text",ent);
			return(S_void);
		}
		while(nstrings--){fputs(*strings++,f);putc('\n',f);}
		fclose(f);
		if(push_source(Parsefile,TRUE))unlink(Parsefile);
		else Recover("Source error",ent);
	}
	else { /* either file or from stdin */
		arg = args[0];
		if(arg->length>0) {
			file_name = string_value(arg);
			if(!*file_name)file_name = NULL_STRING;
		}
		else file_name = NULL_STRING;
		if(!push_source(file_name,FALSE))
			Recover("Can't open new source",ent);
	}
	add_error((fun_ptr)source_err);
	arg = args[1]; /* n */
	/* By default, read one item from stdin, or to end of file else */
	nexpr = nalloc = arg->length ? long_value(arg,ent) :
	   ((file_name && *file_name) ? -1 : 1);
	if(nexpr==0)return(alcvec(PARSE,0L));
	else if(nexpr<0){nexpr = INTEGER_MAX; nalloc = 0;}/* read to eof */
	arg = args[3]; /* prompt */
	prompt = NULL;
	if(arg->length>0) {
		prompt = string_value(arg);	
		prev_prompt = S_alloc((long)MAX_OPT_STRING,sizeof(char));
		strncpy(prev_prompt, S_prompt,MAX_OPT_STRING);
		strncpy(S_prompt,prompt,MAX_OPT_STRING);
	}
	eof = FALSE;
	switch(which) {
	case 0:
		arg = alcvec(PARSE,nalloc); arg->length=0;
		while( nexpr-- > 0 && !(parse_err = do_parse())){
			if(S_ptree->mode == END_OF_FILE){ eof=TRUE; break;}
			arg=append_el(arg,(long)NOARG,S_ptree);
		}
		break;
	case 1: /* white=TRUE */
		Slexinit();
		doing_list = nexpr;
		parse_err = do_parse();
		arg=S_ptree;
		doing_list = 0;
		break;
	}
	if(!pop_source() && eof && arg->length==0 &&
	  file_name==NULL_STRING && which==0) {
		vector *val;
		/* end of file at top level on stdin in parse() => quit */
		val= New_vector(); val->mode = QUIT;
		append_el(arg,0L,val);
	}
	if(prompt){
		strncpy(S_prompt,prev_prompt,MAX_OPT_STRING);
		prompt=prev_prompt=NULL_STRING;
	}
	del_error((fun_ptr)source_err);
	if(parse_err)Recover(NULL_STRING,NULL_ENTRY);
	return(arg);
}

static void 
source_err()
{
	flush_input(yyin);
	unlink(Parsefile); pop_source();del_error((fun_ptr)source_err);
	if(prompt && prev_prompt) {
		strncpy(S_prompt,prev_prompt,MAX_OPT_STRING);
		prompt=NULL_STRING;
	}
}

/*
 * synchronize the in-memory and database datasets, rather than
 * waiting until the end of the complete expression
 */
vector *
S_sync(ent, arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree;
	UNUSED(ent);

	if(logical_value(args[0],ent))
		do_stop(0); /* back to the top level: won't return */
	if(logical_value(args[1],ent))
		flush_data(FALSE); /* write out any assigned data */
	if(logical_value(args[2],ent)) {
		S_data->length = 0; /* drop any in-memory data */
		clear_cache();
	}
	return(S_void);
}

vector *
S_dtype(ent, arglist)
vector *ent, *arglist;
{
	vector *arg, *value;
	int which = sys_index; long mode;
	arg = arglist->value.tree[0];
	mode = data_mode(arg);
	value = alcvec(LGL, 1L);
	switch(which) {
	case 0: /* is.atomic() */
		value->value.Long[0] = atomic_type(mode); break;
	case 1: /* is.language() */
		value->value.Long[0] = LANGUAGE_TYPE(mode); break;
	case 2: /* is.recursive() */
		value->value.Long[0] = !NOT_RECURSIVE(mode); break;
	default:
		Recover(enci1("Invalid system index (%ld) in data-type function",
		(long)which),ent);
	}
	return(value);
}

#ifdef ATT_UNIX
#include <nlist.h>
#else
#include <a.out.h>
#endif

/*interface to FORTRAN, C, etc. routines */
vector *
S_interface(ent, arglist)
vector *ent, *arglist;
{
	vector **args, *p, *temp, *t1,*t2, *t, *ret, **retvals;
	char *xname, *print_name, **values, **pval;
	int which = sys_index, amode, naok;
	long nargs, i;
	UNUSED(ent);

	nargs = arglist->length-2; args = arglist->value.tree;
	naok = logical_value(args[nargs+1],ent);
	print_name = xname = string_value(*args++);
	if(which==1)xname=ftn_symbol(xname);
	else xname = c_symbol(xname);
	pval = values = (char **)S_alloc(nargs,sizeof(char *));
	ret = alcvec(LIST,nargs); retvals = ret->value.tree;
	MEANINGFUL(t1); MEANINGFUL(t2);
	if(!naok) {
		t1 = alcvec(FUN_CALL,2L);
		t2 = alcvec(LIST,1L);
	}
	for(i=0; i<nargs; i++) {
		p = *args++; if(PRECIOUS(p))p=copy_data(p,NULL_ENTRY);
		p = coeves(p,ANY,FALSE,CHECK_IT,&temp);
		*retvals++ = p;
		if(temp==NULL_ENTRY )
			intf_err("Unable to generate argument %ld",i+1,print_name);
		amode = temp->mode;
		if(which==1) { /* Fortran consistency tests */
			if(!atomic_type(amode))
			 intf_err("Argument %ld is not a Fortran mode",i+1,print_name);
			if(temp->length<1)
			  intf_err("Argument %ld has zero length",i+1,print_name);
		}
		if(!naok) { /* do na.list() internally */
			t1->value.tree[1] = t2->value.tree[0] = temp;
			sys_index = 1;
			t = S_na_funs(t1,t2);
			if(t->length>0) intf_err("Missing values in argument %ld",i+1,print_name);
		}
		switch(amode){
		case INT:
		case LGL:
			*pval = (char *)temp->value.Long;
			break;
		case REAL:
			*pval = (char *)temp->value.Float;
			break;
		case DOUBLE:
			*pval = (char *)temp->value.Double;
			break;
		case CHAR:
			*pval = (which==1 ? (char *)temp->value.Char[0] :
			   (char *)temp->value.Char);
			break;
		case COMPLEX:
			*pval = (char *)temp->value.Complex;
			break;
		default:
			*pval = (char *)temp->value.tree;
		}
		pval++;
	}
	sub_name = print_name;
	add_error(sub_err);
	do_x(xname, values,nargs);
	del_error(sub_err);
	return(ret);
}

static void 
sub_err()
{
	if(last_signal != SIGINT)
	 	fprintf(stderr,"Error was while calling subroutine \"%s\"\n",sub_name);
	fflush(stderr);
}

static void 
intf_err(message, which, sub)
char *message, *sub; long which;
{
	char *msg;
	msg = encs2("subroutine %s: %s",sub,message);
	Recover(enci1(msg,which),NULL_ENTRY);
}

void 
call_S(func, nargs, arguments, modes, lengths, names, nres, values)
vector *func;
char **arguments, **modes, **names, **values;
long nargs, *lengths, nres;
{
	vector *call, **args, *arg, *value;
	char *msg, *inarg;
	int mode;
	long n, nn;

	msg = sanity(func, NULL_STRING);
	if(msg) Recover(encs1("Function pointer in call to S: %s",msg),NULL_ENTRY);
	if(func->mode!=FUN_DEF) Recover("First argument in call to S is not a function",func);
	call = alcvec(FUN_CALL,nargs+1);
	args = call->value.tree; *args++ = copy_data(func,Local_data);
	for(n=0;n < nargs; n++) {
		mode = mode_lookup(modes[n]);
		if(mode==UNKNOWN) Recover(enci1("Mode for argument %ld in call to S not known",n+1),NULL_ENTRY);
		inarg = arguments[n]; if(!inarg)Recover("Null pointer to argument in call to S",NULL_ENTRY);
		nn = lengths[n];
		if(nn<0)Recover(enci1("Negative length for argument %ld in call to S",n+1),NULL_ENTRY);
		args[n] = arg = New_vector();
		arg->mode = mode; arg->length = arg->nalloc = nn;
		arg->name = (names && names[n]) ? names[n] : NULL;
		switch(mode) {
		case DOUBLE: arg->value.Double = (double *)inarg; break;
		case REAL: arg->value.Float = (float *)inarg; break;
		case INT: case LGL: arg->value.Long = (long *)inarg; break;
		case CHAR: arg->value.Char = (char **)inarg; break;
		case COMPLEX: arg->value.Complex = (complex *)inarg; break;
		case NAME: arg->value.name = inarg; break;
		default:
			if(NOT_RECURSIVE(mode)) {
				if(n>0)Recover(encs1("Can't have length>0 for mode %s in call to S",
				  modes[n]),NULL_ENTRY);
				}
			else arg->value.tree = (vector **)inarg;
		}
	}
	value = eval(call); mode = value->mode;
	MEANINGFUL(nn);
	if(atomic_type(mode)){ args = &value; nn = 1; }
	else if(NOT_RECURSIVE(mode))
		Recover("Function used in call to S must return simple data or a list",value);
	else {args = value->value.tree; nn = value->length; }
	for(n=0; n<nres ; n++) {
		if(n<nn) {
			arg = coevec(args[n], ANY, FALSE, FALSE);
			switch(arg->mode) {	
			case DOUBLE: values[n] = (char *)arg->value.Double; break;
			case REAL: values[n] = (char *)arg->value.Float; break;
			case INT: case LGL: values[n] = (char *)arg->value.Long; break;
			case CHAR: values[n] = (char *)arg->value.Char; break;
			case COMPLEX: values[n] = (char *)arg->value.Complex; break;
			case NAME: values[n] = (char *)arg->value.name; break;
			default:
				if(NOT_RECURSIVE(mode))
					Recover(encs1("Invalid returned data (mode %s) in call to S",
					  token_name(arg->mode)),NULL_ENTRY);
				else values[n] = (char *)arg->value.tree;
			}
		}
		else values[n] = NULL;
	}
}

/* for debug printing from dyn.loaded  code (why doesn't it bind _iob from
/*	stdio ?? */
void 
Eprintf(fmt,x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)
char *fmt; long x0,x1,x2,x3,x4,x5,x6,x7,x8,x9;
{
	fprintf(stderr,fmt,x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);
	fflush(stderr);
}

static long load_t_len = 0;
static x_h **load_table, **in_line_table;

vector *
S_rep(ent, arglist)
vector *ent, *arglist;
{
	vector **args, *arg;
	long narg = arglist->length, n;
	long *a, *b, na, nb, *reps;
	long  i, j, *from;
	if(narg!=2)Recover("rep() takes 2 arguments",ent);
	args = arglist->value.tree;
	arg = coevec(args[0],INT,TRUE,CHECK_IT);
	if(VOID(arg))Recover("argument \"x\" can't be made integer",ent);
	a = arg->value.Long; na = arg->length;
	if(na == 0) return(arg);
	arg = coevec(args[1],INT,TRUE,CHECK_IT);
	if(VOID(arg))Recover("argument \"times\" can't be made integer",ent);
	b = arg->value.Long; nb = arg->length;
	for(i=nb, from = b, n =0; i>0;i--,from++){
		if(is_na(from))Recover("No missing values allowed in \"times\"",ent); 
		j= *from;
		if(j<0)Recover("Negative values in \"times\" meaningless",ent);
		n += j;
	}
	if(nb==1)n *= na;
	arg = alcvec(INT,n); reps = arg->value.Long;
	if(nb==1){
		i= *b;
		while(i--){
			j=na; from=a;
			while(j--) *reps++ = *from++;
		}
	}
	else if(nb==na) {
		i=na;
		while(i--) {
			j = *b++;
			while(j--) *reps++ = *a;
			a++;
		}
	}
	else Recover("rep() only defined for length(times)==1 or length(x)",ent);
	return(arg);
}

vector *
S_amatch(ent, arglist)
vector *ent, *arglist;
{
	vector **args, *arg, *v1, *v2, *v3, *def, **vals, *dots;
	long n, i, m,l, which; char **names, *name; int xpd_dots;
	UNUSED(ent);
	which = sys_index;
	args = arglist->value.tree; def = coevec(args[0],ANY,FALSE,FALSE);
	if(def->mode != FUN_DEF)Recover("Not a valid function definition",def);
	n = def->length-1;
	v3 = alcvec(LGL,n); v3->name = "missing";
	arg = coevec(args[1],ANY,FALSE,FALSE);
	if(arg->mode == PARSE)arg = coevec(arg->value.tree[0],ANY,FALSE,FALSE);
	if(arg->mode != FUN_CALL)Recover("Not a valid call",arg);
	v1 = fun_args(def,arg,v3); v1->name = ".Data";
	switch(which) {
	case 0: /*amatch() */
		v2 = alcvec(CHAR,n); v2->name = "names";
		args = v1->value.tree; n = v1->length;
		names = v2->value.Char;
		while(n--) {
			arg = *args;
			*names = arg->name ? arg->name : "";
			args++; names++;
		}
		arg = alcvec(STRUCTURE,3L); args = arg->value.tree;
		*args++ = v1; *args++ = v2; *args = v3;
		return(arg);
	case 1: /* match.call() */
		xpd_dots = (dots = xact_comp(v1,"...")) && logical_value(args[2]);
		l = arg->length;
		if(xpd_dots) {
			del_comp(v1, x_which_comp("...",v1));
			if(dots->mode == ARGUMENT)
				dots = dots->value.tree[0];
			if(dots->mode == LPAR && dots->length>1)
				l = l + dots->length -2;
			else {xpd_dots = FALSE; l = l-1;}
		}
		v2 = alcvec(FUN_CALL,l);
		vals = v2->value.tree; args = v1->value.tree; n = v1->length;
		*vals++ = copy_data(arg->value.tree[0],NULL_ENTRY); m = 0;
		for(i=0; i<n; i++) {
			arg = args[i]; name = arg->name;
			if(arg->mode == ARGUMENT) {
				arg = arg->value.tree[0];
				if(VOID(arg))continue;
				arg->name = name;
				if(dots && !strcmp(name,"...")) { /* convert the LPAR object */
					arg->mode = FUN_CALL;
					arg->value.tree[0] = alc_name("list");
				}
			}
			if(m<v2->length)vals[m++] = arg;
			else Recover("Internal error in arg matching",NULL_ENTRY);
		}
		if(xpd_dots)
		  for( i=0, n=dots->length-1, args = dots->value.tree+1; i<n; i++)
			if(m<v2->length)vals[m++] = args[i];
			else Recover("Internal error in arg matching",NULL_ENTRY);
		v2->length = m+1;
		return(v2);
	default: PROBLEM "Invalid internal code (%ld) to S_amatch", which
		RECOVER(NULL_ENTRY);
	}
}

vector *
S_version(ent, arglist)
vector *ent, *arglist;
{
	vector *value = alcvec(CHAR, 1L);
	UNUSED(ent);
	UNUSED(arglist);

	*(value->value.Char) = c_s_cpy(load_time);
	return(value);
}

static int undef_action = 0;	/* action on undefined external */
				/* 0=Fatal, 1=Warn, else ignore */
vector *
S_dynload(ent, arglist)
vector *ent, *arglist;
{
	vector *files = coevec(arglist->value.tree[0], CHAR, FALSE, CHECK_IT);
	vector *val = alcvec(CHAR, 0L);
	long nfiles = files->length;
	char **names = files->value.Char;
	UNUSED(ent);

	undef_action = long_value(arglist->value.tree[1],ent);
	while(nfiles--) {
		vector *v = dyn_load(*names++);
		append_data(val, val->length, v->length, (char *)v->value.Char);
	}
	return(val);
}
	
typedef vector *(*sys_fun)(); /* type for an internal system function */

extern vector *S_get(), *do_op(), *do_math(), *do_summary();
extern vector *S_extract(), *S_replace(), *S_dummy(), *S_na_funs();
extern vector *S_assign(), *S_debug(), *S_gr_set(), *S_list(), *S_menu();
extern vector *S_ranfuns(), *S_sample(), *S_remove(), *S_storage();
extern vector *do_math(), *do_op(), *do_summary();
extern vector *hp2623(), *hpgl();
extern vector *postscript(), *tty5620();
extern void cx_arg(), cx_conj(), cx_im(), cx_mod(), cx_re(), pratom();
extern void gt(), fft(), gr_transform();


struct i_code {
	char *name;
	int type; /* in_line_ok | 2* eval_constant_ok */
};


struct i_code intern_codes[] = {
{"_As_vector", 1 | 2},
{"_Is_vector", 1 | 2},
{"_S_amatch", 1 | 2},
{"_S_cat", 1 | 2},
{"_S_clock", 1 | 2},
{"_S_colon", 1 | 2},
{"_S_do_cmd", 1 | 2},
{"_S_dummy",0},
{"_S_dynload", 0},
{"_S_extract", 1 | 2},
{"_S_get",0},
{"_S_interface", 0},
{"_S_match", 1 | 2},
{"_S_new_vector", 1 | 2},
{"_S_parse", 0},
{"_S_paste", 1 | 2},
{"_S_rep", 1 | 2},
{"_S_replace",0},
{"_S_sample", 0},
{"_S_sort_list", 1 | 2},
{"_S_sync", 0},
{"_S_system", 0},
{"_S_version", 1 | 2},
{"_S_dtype", 1 | 2},
{"_S_assign",0},
{"_S_debug",0},
{"_S_gr_set",0},
{"_S_list", 1 | 2},
{"_S_menu",0},
{"_S_na_funs", 1 | 2},
{"_S_ranfuns", 0},
{"_S_remove",0},
{"_S_storage",0},
{"_cx_arg", 1 | 2},
{"_cx_conj", 1 | 2},
{"_cx_im", 1 | 2},
{"_cx_mod", 1 | 2},
{"_cx_re", 1 | 2},
{"_do_math", 1 | 2},
{"_do_op", 1 | 2},
{"_do_summary", 1 | 2},
{"_fft", 1 | 2},
{"_gr_transform", 1 | 2},
{"_gt", 1 | 2},
{"_hp2623",0},
{"_hpgl",0},
{"_postscript",0},
{"_pratom",0},
{"_tty5620",0},
{NULL,NULL } };

static struct nlist nls[2];
extern char *prog_name;

#define S_HASH_LEN 1000

void 
init_load()
{
	long prev;
	extern x_h ld_init[];
	if(load_t_len)return; /* already initialized */
	load_t_len= S_HASH_LEN;
	prev = set_alloc(PERM_FRAME);
	nprime(&load_t_len);
	load_table = (x_h **)S_alloc(load_t_len,sizeof(x_h *));
	in_line_table = (x_h **)S_alloc(load_t_len,sizeof(x_h *));
	do_l_hash(ld_init);
	set_alloc(prev);
}

static void 
do_l_hash(list)
x_h *list;
{
	x_h *entry, *old;
	long pos, temp, n;
	struct i_code *p;
	double nconfl = 0;

	for(n = 0, entry = list; entry->index; entry++, n++) {
		if(hash(entry->name,CHAR,&temp,&pos,load_table,load_t_len)) {
			Warning(encs1("Duplicate name in hash initialization: \"%s\"",entry->name),NULL_ENTRY);
			entry++;
			continue;
		}
		old = load_table[pos];
		if(old) nconfl += 1;
		entry->next = old;
		load_table[pos] = entry;
	}
	if(n>30 && (nconfl=nconfl/n)>.2)
		fprintf(stderr,"Load table initialized with %g ratio of clashes\n  (%ld entries, table length %ld)\n",nconfl,n,load_t_len);
	for(p = intern_codes; p->name; p++)
		hash_enter(p->name, CHAR, (long)p->type, -1L, in_line_table,load_t_len);
}

int 
intern_in_l(name)
char *name;
{
	long index, pos;
	return(hash(c_symbol(name),CHAR,&index,&pos,in_line_table,load_t_len)
		 ? index : 0);
}

#ifdef lint

nlist(filename, nl)
char *filename;
struct nlist nl[];
{
	UNUSED(filename);
	UNUSED(nl);
}
#endif

fun_ptr 
get_entry(name)
char *name;
{
	long index, pos;
	if(!load_t_len)init_load();
	if(!hash(name,CHAR,&index,&pos,load_table,load_t_len)){
		long prev;
#ifdef ATT_UNIX
		nls[0].n_name = name;
		nls[1].n_name = NULL_STRING;
		if(nlist(prog_name,nls)<0)
			Recover(encs1("Problem looking up %s in symbol table",name),NULL_ENTRY);
#else
		nls[0].n_un.n_name =  name;
		nls[1].n_un.n_name = NULL_STRING;
		nlist(prog_name,nls);
#endif
		index = (long)nls[0].n_value;
		if(!index)
			return(NULL);
		prev = set_alloc(PERM_FRAME);
		name = c_s_cpy(name);
		hash_enter(name,CHAR,index,pos,load_table,load_t_len);
		set_alloc(prev);
	}
	return((fun_ptr)index);
}

/* the next two routines generate					*/
/* the symbols for a C or Fortran entry point				*/
/*									*/
/* Use SYMBOL and FSYMBOL to decide how to construct symbolic names	*/
char *
c_symbol(name)
char *name;
{
	char *sname, *p;
	static char test[] = SYMBOL(foo);
	p = sname = S_alloc(strlen(name)+2L,1);
	if(test[0]=='_')
		*p++ = '_';
	while(*name) *p++ = *name++;
	return(sname);
}

char *
ftn_symbol(name)
char *name;
{
	char *sname, *p;
	static char test[] = FSYMBOL(foo);
	p = sname = S_alloc(strlen(name)+3L,1);
	if(test[0]=='_')
		*p++ = '_';
	if(test[2]=='O') {	/* sometimes we get upper case! */
		while(*name) *p++ = toupper(*name++);
	} else {
		while(*name) *p++ = *name++;
	}
	if(test[strlen(test)-1]=='_')
		*p = '_';
	return(sname);
}

#ifdef ATT_UNIX
static vector *
dyn_load(name)
char *name;
{	Recover("No dynamic loading in this version of UNIX",NULL_ENTRY);
}

#else
/*

		DISCLAIMER AND NOTIFICATION OF RIGHTS
			May 16, 1985

	This code was written by Phil Smith, Bert Sacks, and
	Stephen Daniel of the Microelectronics Center of NC.

	It appears to us that it works, but there are no
	guarentees of any kind expressed or implied.

	The Microelectronics Center of North Carolina
	hereby places this code into the public domain.

	We request that you keep this comment associated with
	this code.

*/


/*
 * Dynamic loading routine.
 */


typedef int (*pfi_t)();	/* pointer to function returning integer. */

static FILE *input;
static char *f_name;
static long string_offset;

static vector *
dyn_load(file_name)
char *file_name;
{
	int size;
	int *data;
	struct exec header;
	vector *value;

	/*
	 * Set up an error exit.
	 */
	f_name = file_name;
	/*
	 *	Open the file:  return if unopened.
	 */
	if ((input = fopen(file_name, "r")) == NULL)
		Recover(encs1("cannot open file \"%s\"",file_name),NULL_ENTRY);

	ok_fread ((char *)&header, sizeof(header), 1, input);
	if(header.a_syms <= 0)
		Recover(encs1("No symbol table in file \"%s\"",file_name),NULL_ENTRY);
	ok_fseek (input, (long) N_TXTOFF(header), 0);

	string_offset = N_STROFF(header);
	size = header.a_text + header.a_data;

	/*
	 *	Read in the text and data segments
	 *	Use ok_calloc() to make sure bss segment zero'ed
	 */
	data = (int *)ok_calloc((int)(size + header.a_bss), 1);

	ok_fread ((char *)data, 1, size, input);

	value = relocate (header, (char *)data);

	fclose (input);
	return(value);
}

/*
 *	Relocate text and data
 */
static
vector *relocate (header, text)
struct exec header;
char *text;
{
	int i; 
	char *data;
	unsigned long	no_reloc_items,
			no_reloc_text_items,
			no_reloc_data_items,
			no_symbols;
	struct relocation_info *rp, *relocate;
	struct nlist *symtab;
	vector *value;

	data = text + header.a_text;

	/*
	 *	Read in the relocation information
	 */
	no_reloc_text_items = (header.a_trsize / sizeof (struct relocation_info));
	no_reloc_data_items = (header.a_drsize / sizeof (struct relocation_info));
	no_reloc_items = no_reloc_text_items + no_reloc_data_items;

	MEANINGFUL(relocate);
	if(no_reloc_items>0){
		relocate = (struct relocation_info *) ok_malloc
				(header.a_trsize + header.a_drsize);
		ok_fread ((char *)relocate, sizeof (struct relocation_info),
				(int)no_reloc_items, input);
	}
	/*
	 *	Read in the symbol table
	 */
	symtab = (struct nlist *) ok_malloc (header.a_syms);
	no_symbols = header.a_syms / (sizeof (struct nlist));
	ok_fread ((char *)symtab, sizeof (struct nlist), (int)no_symbols, input);

	/*
	 *	Relocate text
	 */
	for (i = 0, rp = relocate; i < no_reloc_text_items; i++, rp++) 
		adjust(text+rp->r_address, rp, symtab, text);

	/*
	 *	Relocate data
	 */
	for (i = 0; i < no_reloc_data_items; i++, rp++) 
		adjust(data+rp->r_address, rp, symtab, text);

	value = find_text(symtab,no_symbols,(long)text);

	if(no_reloc_items>0) ok_free((char *)relocate);
	ok_free((char *)symtab);
	return(value);
}

/*
 *	Find the external text symbols in the file
 */
static
vector *
find_text(symtab,n,start_of_file)
struct nlist *symtab;
unsigned long n;
long start_of_file;
{
	vector *value = alcvec(CHAR,0L);
	int i;
	long prev;
	char *symname, *vv[1];

	for(i=0; i<n; i++){
		if((symtab->n_type & N_EXT) &&
			(symtab->n_type & N_TYPE) == N_TEXT){
			symname = get_symbol_name(symtab->n_un.n_strx);
			prev = set_alloc(PERM_FRAME);	/* hash entry is permanent */
			hash_enter(vv[0]=c_s_cpy(symname),CHAR,symtab->n_value+start_of_file,-1L,load_table,load_t_len);
			set_alloc(prev);	/* data value is not */
			append_data(value,value->length,1L,(char *)vv);
		}
		symtab++;
	}
	return(value);
}

/*
 *	Add the offset to relocated items
 */
static void
adjust (word, reloc, symtab, text)
char *word;
struct relocation_info *reloc;
struct nlist *symtab;
char *text;
{
	long reloc_item;
	char *symname;
	struct nlist *sp;

	MEANINGFUL(reloc_item);
	switch(reloc->r_length){
	case 0:	reloc_item = *(char *) word; break;
	case 1: reloc_item = *(short *) word; break;
	case 2: reloc_item = *(long *) word; break;
	default: Recover("INTERNAL ERROR: bad r_length",NULL_ENTRY);
	}

	/*
	 *	Relocate a text or data item 
	 */
	if (reloc->r_extern) {
		sp = symtab + reloc->r_symbolnum;
		if ((sp->n_type & N_TYPE) == N_UNDF) {
			symname = get_symbol_name(sp->n_un.n_strx);
/* fprintf(stderr,"Symbol %s pcrel=%d\n",symname,reloc->r_pcrel); */
			sp->n_value = (unsigned) get_entry(symname);
			if(sp->n_value==0)
				switch(undef_action){
				case 0:
				Recover(encs1("No definition for symbol \"%s\"",symname),NULL_ENTRY);
				case 1:
				Warning(encs1("No definition for symbol \"%s\"",symname),NULL_ENTRY);
				}
			else {
				sp->n_type &= ~N_UNDF;	/* now the symbol is resolved */
				if(reloc->r_pcrel) sp->n_value -= (int) text;					reloc_item += (int) sp->n_value;
			}
		} else 
			reloc_item += (int) sp->n_value;

	} else if (!reloc->r_pcrel)
		switch (reloc->r_symbolnum & N_TYPE) {
			case N_TEXT:
			case N_DATA:
			case N_BSS:
				reloc_item += (long)text;
				break;
			case N_ABS:
				break;
			default:
				Recover("INTERNAL ERROR: bad n_type",NULL_ENTRY);
		}

	switch(reloc->r_length){
	case 0: *(char *) word = reloc_item; break;
	case 1: *(short *) word = reloc_item; break;
	case 2: *(long *) word = reloc_item; break;
	default: Recover("INTERNAL ERROR: bad r_length",NULL_ENTRY);
	}
}

static char *
get_symbol_name(which)
long which;
{
	static char buf[100];
	char *bp = buf;

	if (which) {
		ok_fseek(input, string_offset + which, 0);
		while (*bp++ = getc(input)) ;
		}
	return(buf);
}

static void

ok_fread(ptr, size, nitems, stream)
char *ptr;
int size, nitems;
FILE *stream;
{
	if (fread(ptr, size, nitems, stream) != nitems ||
	    feof(stream) || ferror(stream))
		Recover("error while reading disk file",NULL_ENTRY);
}

static void

ok_fseek(stream, offset, ptrname)
FILE *stream;
long offset;
int ptrname;
{
	if (fseek(stream, offset, ptrname) < 0)
		Recover("error while seeking on disk file",NULL_ENTRY);
}

static char *

ok_calloc(nelem, elsize)
int nelem, elsize;
{
	register char *ret;
	char *calloc();

	if ((ret = calloc(nelem, (unsigned)elsize)) == (char *)0)
		Recover("insufficient memory",NULL_ENTRY);
	return(ret);
}

static char *

ok_malloc(n)
unsigned long n;
{
	register char *ret;

	if ((ret = malloc((unsigned int)n)) == (char *)0)
		Recover("insufficient memory", NULL_ENTRY);
	return(ret);
}

static void

ok_free(s)
char *s;
{
	free(s);
}

#endif
