/* process the output of S run that was preprocessed by the
   report generation input routine */

#include <stdio.h>
#define SEXPR '\06'
#define BEXPR '\07'
#define ENDEXPR	'\010'

int c,strip,holdnl;

main()
{
	strip = 0; holdnl = 0;
	while((c = getchar())!=EOF){	/* first char on each line */
		if(c!='>' && c!='+') {	/* S output */
			passthrough();
			continue;
			}
		if((c=getchar())!=' ') { eatline(); continue; }
		if((c=getchar())!='#') { eatline(); continue; }
		if((c=getchar())==ENDEXPR)  holdnl = 0;	/* eat preceeding nl */
		passthrough();
		}
	putchar('\n');
}

static eatline()
{
	for(; c!=EOF && c!='\n'; c=getchar()) ;
}

static passthrough()
{
	if(holdnl) putchar('\n');
	holdnl = 0;
	if(strip) while(c==' ') c=getchar();
	for(;;)
		switch(c){
		case '\n': holdnl = 1;	/* remember newline */
			return;
		case EOF: return;
		case SEXPR:
		case BEXPR:
			strip = c==SEXPR;
			eatline();	/* eats next newline */
			return;
		case '"': if(!strip) putchar(c);
			c = getchar();
			break;
		case ENDEXPR:
			strip = 0;
			c = getchar();
			break;
		default:
			putchar(c);
			c = getchar();
		}
}
