/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/* -----------------------------------------------------------------------------
 * perl5.swg
 *
 * Perl5 runtime library
 * $Header: /cvs/projects/SWIG/Lib/perl5/perlrun.swg,v 1.3 2002/11/30 22:10:08 beazley Exp $
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny
   games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#ifndef pTHX_
#define pTHX_
#endif

#include <string.h>
#ifdef __cplusplus
}
#endif

/* Macro to call an XS function */

#ifdef PERL_OBJECT 
#define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#ifndef MULTIPLICITY 
#define SWIG_CALLXS(_name) _name(cv) 
#else 
#define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#endif 
#endif 

/* Macros for low-level exception handling */
#define SWIG_fail      goto fail
#define SWIG_croak(x)  { if ((_swigerr = (const char *) x)) goto fail; }
#define SWIG_MAX_ERRMSG 256

/* Note: SwigMagicFuncHack is a typedef used to get the C++
   compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#ifndef PL_sv_yes
#define PL_sv_yes sv_yes
#endif
#ifndef PL_sv_undef
#define PL_sv_undef sv_undef
#endif
#ifndef PL_na
#define PL_na na
#endif
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SWIG_NOINCLUDE

#ifndef PERL_OBJECT
extern int SWIG_ConvertPtr(SV *, void **, swig_type_info *, int flags);
extern void SWIG_MakePtr(SV *, void *, swig_type_info *, int flags);
#else
extern int _SWIG_ConvertPtr(CPerlObj *, SV *, void **, swig_type_info *,int flags);
extern void _SWIG_MakePtr(CPerlObj *, SV *, void *, swig_type_info *, int flags);
#define SWIG_ConvertPtr(a,b,c,d) _SWIG_ConvertPtr(pPerl,a,b,c,d)
#define SWIG_MakePtr(a,b,c,d) _SWIG_MakePtr(pPerl,a,b,c,d)
#endif

#else

/* Function for getting a pointer value */

#ifndef PERL_OBJECT
SWIGRUNTIME(int) 
SWIG_ConvertPtr(SV *sv, void **ptr, swig_type_info *_t, int flags)
#else
#define SWIG_ConvertPtr(a,b,c,d) _SWIG_ConvertPtr(pPerl,a,b,c,d)
SWIGRUNTIME(int)
_SWIG_ConvertPtr(CPerlObj *pPerl, SV *sv, void **ptr, swig_type_info *_t, int flags)
#endif
{
  char *_c;
  swig_type_info *tc;
  IV   tmp;

  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
	mg = mg_find(tsv,'P');
	if (mg) {
	  SV *rsv = mg->mg_obj;
	  if (sv_isobject(rsv)) {
	    tmp = SvIV((SV*)SvRV(rsv));
	  }
	}
      } else {
	return -1;
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    if (!_t) {
      *(ptr) = (void *) tmp;
      return 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return 0;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv)) 
      return 0;
    else
      return -1;
  } else {                            /* Don't know what it is */
      *(ptr) = (void *) 0;
      return -1;
  }
  if (_t) {
    /* Now see if the types match */      
    _c = HvNAME(SvSTASH(SvRV(sv)));
    tc = SWIG_TypeCheck(_c,_t);
    if (!tc) {
      *ptr = (void *) tmp;
      return -1;
    }
    *ptr = SWIG_TypeCast(tc,(void *)tmp);
    return 0;
  }
  *ptr = (void *) tmp;
  return 0;
}
#ifndef PERL_OBJECT
SWIGRUNTIME(void) 
SWIG_MakePtr(SV *sv, void *ptr, swig_type_info *t,int flags)
#else
#define SWIG_MakePtr(a,b,c,d) _SWIG_MakePtr(pPerl,a,b,c,d)
SWIGRUNTIME(void)
_SWIG_MakePtr(CPerlObj *pPerl, SV *sv, void *ptr, swig_type_info *t, int flags)
#endif
{
  sv_setref_pv(sv, (char *) t->name, ptr);
}

#endif

typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;

#ifdef __cplusplus
}
#endif

/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY 
       static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int \
(*get)(SV *,MAGIC *)) { 
  #else 
       static void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*,\
 SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) { 
  #endif 
#else
#define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}






#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_SOLUTION swig_types[0] 
#define  SWIGTYPE_p_intArray swig_types[1] 
#define  SWIGTYPE_p_double swig_types[2] 
#define  SWIGTYPE_p_cpair swig_types[3] 
#define  SWIGTYPE_p_swString swig_types[4] 
#define  SWIGTYPE_p_float swig_types[5] 
#define  SWIGTYPE_p_void swig_types[6] 
#define  SWIGTYPE_p_floatArray swig_types[7] 
#define  SWIGTYPE_p_doubleArray swig_types[8] 
#define  SWIGTYPE_p_p_void swig_types[9] 
#define  SWIGTYPE_p_short swig_types[10] 
#define  SWIGTYPE_p_p_char swig_types[11] 
#define  SWIGTYPE_p_char swig_types[12] 
#define  SWIGTYPE_p_unsigned_short swig_types[13] 
#define  SWIGTYPE_p_paramT swig_types[14] 
#define  SWIGTYPE_p_Tree swig_types[15] 
#define  SWIGTYPE_p_FILE swig_types[16] 
#define  SWIGTYPE_p_bondT swig_types[17] 
#define  SWIGTYPE_p_int swig_types[18] 
static swig_type_info *swig_types[20];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_RNA

#define SWIG_name   "RNAc::boot_RNA"
#define SWIG_prefix "RNAc::"

#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT(void) SWIG_init (CV* cv);
#else
SWIGEXPORT(void) SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT(void) SWIG_init (CV *cv, CPerlObj *);
#endif


#include  "../H/utils.h"
#include  "../H/fold_vars.h"
#undef fold
#include  "../H/fold.h"
#include  "../H/part_func.h"
#include  "../H/PS_dot.h"
#include  "../H/inverse.h"
#include  "../H/RNAstruct.h"
#include  "../H/treedist.h"
#include  "../H/stringdist.h"
#include  "../H/profiledist.h"
#include  "../H/dist_vars.h"
#include  "../H/pair_mat.h"
#include  "../H/subopt.h"
#include  "../H/energy_const.h"
#include  "../H/params.h"


static int *new_intP(int nelements) { 
  return (int *) calloc(nelements,sizeof(int)); 
}

static void delete_intP(int *ary) { 
  free(ary); 
}

static int intP_getitem(int *ary, int index) {
    return ary[index];
}
static void intP_setitem(int *ary, int index, int value) {
    ary[index] = value;
}


typedef int intArray;

intArray *new_intArray(int nelements){
  return (int *) calloc(nelements,sizeof(int));
}
void delete_intArray(intArray *self){
  free(self);
}
int intArray_getitem(intArray *self,int index){
  return self[index];
}
void intArray_setitem(intArray *self,int index,int value){
  self[index] = value;
}
int *intArray_cast(intArray *self){
  return self;
}
intArray *intArray_frompointer(int *t){
  return (intArray *) t;
}

static float *new_floatP(int nelements) { 
  return (float *) calloc(nelements,sizeof(float)); 
}

static void delete_floatP(float *ary) { 
  free(ary); 
}

static float floatP_getitem(float *ary, int index) {
    return ary[index];
}
static void floatP_setitem(float *ary, int index, float value) {
    ary[index] = value;
}


typedef float floatArray;

floatArray *new_floatArray(int nelements){
  return (float *) calloc(nelements,sizeof(float));
}
void delete_floatArray(floatArray *self){
  free(self);
}
float floatArray_getitem(floatArray *self,int index){
  return self[index];
}
void floatArray_setitem(floatArray *self,int index,float value){
  self[index] = value;
}
float *floatArray_cast(floatArray *self){
  return self;
}
floatArray *floatArray_frompointer(float *t){
  return (floatArray *) t;
}

static double *new_doubleP(int nelements) { 
  return (double *) calloc(nelements,sizeof(double)); 
}

static void delete_doubleP(double *ary) { 
  free(ary); 
}

static double doubleP_getitem(double *ary, int index) {
    return ary[index];
}
static void doubleP_setitem(double *ary, int index, double value) {
    ary[index] = value;
}


typedef double doubleArray;

doubleArray *new_doubleArray(int nelements){
  return (double *) calloc(nelements,sizeof(double));
}
void delete_doubleArray(doubleArray *self){
  free(self);
}
double doubleArray_getitem(doubleArray *self,int index){
  return self[index];
}
void doubleArray_setitem(doubleArray *self,int index,double value){
  self[index] = value;
}
double *doubleArray_cast(doubleArray *self){
  return self;
}
doubleArray *doubleArray_frompointer(double *t){
  return (doubleArray *) t;
}

static short *new_shortP(int nelements) { 
  return (short *) calloc(nelements,sizeof(short)); 
}

static void delete_shortP(short *ary) { 
  free(ary); 
}

static short shortP_getitem(short *ary, int index) {
    return ary[index];
}
static void shortP_setitem(short *ary, int index, short value) {
    ary[index] = value;
}


typedef struct SWIGCDATA {
    char *data;
    int   len;
} SWIGCDATA;



static SWIGCDATA cdata_void(void *ptr, int nelements) {



   SWIGCDATA d;
   d.data = (char *) ptr;



   d.len  = nelements;

   return d;
}


  char *my_fold(char *string, char *constraints, float *energy) {
    char *struc;
    float en;
    struc = calloc(strlen(string)+1,sizeof(char));
    if (constraints && fold_constrained)
      strncpy(struc, constraints, strlen(string));
    *energy = fold(string, struc);
    if (constraints)
      strncpy(constraints, struc, strlen(constraints));
    return(struc);
  }

extern float energy_of_struct(char const *,char const *);
extern void free_arrays(void);
extern void initialize_fold(int);
extern void update_fold_params(void);

  char *my_pf_fold(char *string, char *constraints, float *energy) {
    char *struc;
    float en;
    struc = calloc(strlen(string)+1,sizeof(char));
    if (constraints && fold_constrained)
      strncpy(struc, constraints, strlen(string));
    *energy = pf_fold(string, struc);
    if (constraints)
      strncpy(constraints, struc, strlen(constraints));
    return(struc);
  }

extern void init_pf_fold(int);
extern void free_pf_arrays(void);
extern void update_pf_params(int);
extern char bppm_symbol(float *);
extern char *pbacktrack(char *);

  char *my_inverse_fold(char *start, const char *target, float *cost) {
    char *seq;
    int n;
    n = strlen(target);
    seq = random_string(n, symbolset);
    if (start)
      strncpy(seq, start, strlen(start));
    *cost = inverse_fold(seq, target);
    if (start)
      /* for backward compatibility modify start */
      strncpy(start, seq, strlen(start));
    return(seq);
  }


  char *my_inverse_pf_fold(char *start, const char *target, float *cost) {
    char *seq;
    int n;
    n = strlen(target);
    seq = random_string(n, symbolset);
    if (start) strncpy(seq, start, n);
    *cost = inverse_pf_fold(seq, target);
    if (start)
      /* for backward compatibility modify start */
      strncpy(start, seq, strlen(start));
    return(seq);
  }

extern char *symbolset;
extern float final_cost;
extern int give_up;
extern int noGU;
extern int no_closingGU;
extern int tetra_loop;
extern int energy_set;
extern int dangles;
extern char *nonstandards;
extern double temperature;
extern int james_rule;
extern int logML;
extern int cut_point;
bondT *bondT_get(bondT *self,int i){
	   return self+i;
	}
extern bondT *base_pair;
extern double *pr;
extern int *iindx;
extern double pf_scale;
extern int fold_constrained;
extern int do_backtrack;
extern int noLonelyPairs;
extern char backtrack_type;
SOLUTION *SOLUTION_get(SOLUTION *self,int i){
	   return self+i;
	}
int SOLUTION_size(SOLUTION *self){
	   SOLUTION *s;
	   for (s=self; s->structure; s++);
	   return (int)(s-self);
	}
void delete_SOLUTION(SOLUTION *self){
	   SOLUTION *s;
	   for (s=self; s->structure; s++) free(s->structure);
	   free(self);
	}
extern SOLUTION *subopt(char *,char *,int,FILE *);
extern int subopt_sorted;

double get_pr(int i, int j) {
  int ii;
  if (i>j) {ii=i; i=j; j=ii;}
  return pr[iindx[i]-j];
}

extern Tree *make_tree(char *);
extern float tree_edit_distance(Tree *,Tree *);
extern void print_tree(Tree *);
extern void free_tree(Tree *);
extern swString *Make_swString(char *);
extern float string_edit_distance(swString *,swString *);
extern float *Make_bp_profile(int);
extern float profile_edit_distance(float const *,float const *);
extern void print_bppm(float const *);
extern void free_profile(float *);
extern void *space(unsigned int);
extern void *xrealloc(void *,unsigned int);
extern void nrerror(char const []);
extern void init_rand(void);
extern unsigned short xsubi[3];
extern double urn(void);
extern int int_urn(int,int);
extern void filecopy(FILE *,FILE *);
extern char *time_stamp(void);
extern char *random_string(int,char const []);
extern int hamming(char const *,char const *);
extern char *get_line(FILE const *);
extern char *pack_structure(char const *);
extern char *unpack_structure(char const *);
extern short *make_pair_table(char const *);
extern int bp_distance(char const *,char const *);
extern void read_parameter_file(char *);
extern void write_parameter_file(char *);

void *deref_any(void **ptr, int index) {
   /* dereference arbitray pointer */
   return (void *) ptr[index];
}

extern paramT *scale_parameters(void);
extern paramT *copy_parameters(void);
extern paramT *set_parameters(paramT *);

  short *make_loop_index(const char *structure) {
  /* number each position by which loop it belongs to (positions start at 0) */
    int i,j,hx,l,nl;
    int length;
    short *stack;
    short *loop;
    length = strlen(structure);
    stack = (short *) space(sizeof(short)*(length+1));
    loop = (short *) space(sizeof(short)*(length+2));
    hx=l=nl=0;
    for (i=0; i<length; i++) {
      if (structure[i] == '(') {
	nl++; l=nl;
	stack[hx++]=i;
      }
      loop[i]=l;
      if (structure[i] ==')') {
	--hx;
	if (hx>0)
	  l = loop[stack[hx-1]];  /* index of enclosing loop   */
	else l=0;                 /* external loop has index 0 */
	if (hx<0) {
	  fprintf(stderr, "%s\n", structure);
	  nrerror("unbalanced brackets in make_pair_table");
	}
      }
    }
    free(stack);
    return loop;
  }


float energy_of_move(const char *string, char *structure, int mi, int mj) {
  extern int energy_of_struct_pt(const char *string, short * ptable,
				 short *s, short *s1);
#define ILLEGAL 999.;
  int i,j,hx,l,nl;
  int length;
  short *stack, *table, *loop;
  short *S, *S1;
  int energy;

  if (mj<0) {
    if ((structure[-mi]!='(') || (structure[-mj]!=')'))
      return 1001;  /* illegal delete pair */
  } else
    if ((structure[mi]!='.') || (structure[mj]!='.'))
      return 1002;  /* illegal add pair */

  /* make the pair table and loop index l*/
  length = strlen(structure);
  stack = (short *) space(sizeof(short)*(length+1));
  loop  = (short *) space(sizeof(short)*(length+2));
  table = (short *) space(sizeof(short)*(length+2));
  table[0] = length;
  hx=l=nl=0;
  for (i=1; i<=length; i++) {
    if (structure[i-1] == '(') {
      nl++; l=nl;
      stack[hx++]=i;
    }
    loop[i]=l;
    if (structure[i-1] ==')') {
      j=stack[--hx];
      if (hx>0)
	l = loop[stack[hx-1]];  /* index of enclosing loop   */
      else l=0;                 /* external loop has index 0 */
      if (hx<0) {
	fprintf(stderr, "%s\n", structure);
	nrerror("unbalanced brackets in energy_of_move");
      }
      table[i]=j;
      table[j]=i;
    }
  }
  if (hx!=0) {
    fprintf(stderr, "%s\n", structure);
    nrerror("unbalanced brackets in energy_of_move");
  }

  if (loop[abs(mi)+1] != loop[abs(mj)+1]) { /* not in same loop => illegal */
    free(stack);
    free(loop);
    free(table);
    return 1003.;
  }

  /* if we get here the move is legal */
  if (mj<0) { /* delete pair */
    structure[-mi] = '.';
    structure[-mj] = '.';
    table[-mi+1] = table[-mj+1] = 0;
  } else { /* insert pair */
    structure[mi] = '(';
    structure[mj] = ')';
    table[mi+1] = mj+1;
    table[mj+1] = mi+1;
  }

  S = (short *) space(sizeof(short)*(length+1));
  S[0] = length;
  for (i=1; i<=length; i++) {
    char *pos;
    pos = strchr(Law_and_Order, string[i-1]);
    if (pos==NULL) S[i]=0;
    else S[i] = pos-Law_and_Order;
  }

  energy =  energy_of_struct_pt(string, table, S, S);

  free(S);
  free(stack);
  free(loop);
  free(table);
  return (float) energy/100.;
}

extern int PS_rna_plot(char *,char *,char *);
extern int PS_rna_plot_a(char *,char *,char *,char *,char *);
extern int gmlRNA(char *,char *,char *,char);
extern int ssv_rna_plot(char *,char *,char *);
extern int svg_rna_plot(char *,char *,char *);
extern int xrna_plot(char *,char *,char *);
extern int PS_dot_plot(char *,char *);
extern int rna_plot_type;
extern int PS_color_dot_plot(char *,cpair *,char *);
#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_RNA_var::
class _wrap_RNA_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}
SWIGCLASS_STATIC int _wrap_set_symbolset(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (symbolset) free((char *) symbolset);
        symbolset = (char *) malloc(strlen(_a)+1);
        strcpy((char *)symbolset,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_symbolset(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (symbolset) {
        sv_setpv((SV*)sv, (char *) symbolset);
    }else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_final_cost(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    final_cost = (float) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_final_cost(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) final_cost);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_give_up(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    give_up = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_give_up(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) give_up);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_noGU(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    noGU = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_noGU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) noGU);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_no_closingGU(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    no_closingGU = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_no_closingGU(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) no_closingGU);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_tetra_loop(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    tetra_loop = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_tetra_loop(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) tetra_loop);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_energy_set(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    energy_set = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_energy_set(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) energy_set);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_dangles(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    dangles = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_dangles(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) dangles);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_nonstandards(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        char *_a = (char *) SvPV(sv,PL_na);
        if (nonstandards) free((char *) nonstandards);
        nonstandards = (char *) malloc(strlen(_a)+1);
        strcpy((char *)nonstandards,_a);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_nonstandards(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    if (nonstandards) {
        sv_setpv((SV*)sv, (char *) nonstandards);
    }else {
        sv_setsv((SV*)sv, &PL_sv_undef);
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_temperature(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    temperature = (double) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_temperature(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) temperature);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_james_rule(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    james_rule = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_james_rule(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) james_rule);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_logML(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    logML = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_logML(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) logML);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_cut_point(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    cut_point = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_cut_point(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) cut_point);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_base_pair(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &base_pair, SWIGTYPE_p_bondT,0) < 0) {
            croak("Type error in argument $argnum of base_pair. Expected _p_bondT");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_base_pair(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) base_pair);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_pr(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &pr, SWIGTYPE_p_double,0) < 0) {
            croak("Type error in argument $argnum of pr. Expected _p_double");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_pr(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) pr);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_iindx(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        if (SWIG_ConvertPtr(sv, (void **) &iindx, SWIGTYPE_p_int,0) < 0) {
            croak("Type error in argument $argnum of iindx. Expected _p_int");
        }
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_iindx(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) iindx);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_pf_scale(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    pf_scale = (double) SvNV(sv);
    
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_pf_scale(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setnv(sv, (double) pf_scale);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_fold_constrained(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    fold_constrained = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_fold_constrained(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) fold_constrained);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_do_backtrack(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    do_backtrack = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_do_backtrack(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) do_backtrack);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_noLonelyPairs(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    noLonelyPairs = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_noLonelyPairs(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) noLonelyPairs);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_backtrack_type(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    backtrack_type = (char) *SvPV(sv,PL_na);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_backtrack_type(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setpvn((SV *) sv, &backtrack_type, 1);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_subopt_sorted(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    subopt_sorted = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_subopt_sorted(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) subopt_sorted);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_loop_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    croak("Value is read-only.");
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_loop_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) loop_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_helix_size(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    croak("Value is read-only.");
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_helix_size(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) helix_size);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_loop_degree(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    croak("Value is read-only.");
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_loop_degree(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) loop_degree);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_loops(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    loops = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_loops(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) loops);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_unpaired(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    unpaired = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_unpaired(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) unpaired);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_pairs(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    pairs = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_pairs(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) pairs);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_edit_backtrack(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    edit_backtrack = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_edit_backtrack(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) edit_backtrack);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_aligned_line(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    croak("Value is read-only.");
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_aligned_line(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) aligned_line);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_cost_matrix(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    cost_matrix = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_cost_matrix(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) cost_matrix);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_xsubi(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    croak("Value is read-only.");
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_xsubi(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv),(IV) xsubi);
    return 1;
}


SWIGCLASS_STATIC int _wrap_set_rna_plot_type(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    rna_plot_type = (int) SvIV(sv);
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_rna_plot_type(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(sv, (IV) rna_plot_type);
    return 1;
}




#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_new_intP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_intP(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (int *)new_intP(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_intP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int *arg1 = (int *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_intP(ary);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_intP. Expected _p_int");
            }
        }
        delete_intP(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_intP_getitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int *arg1 = (int *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: intP_getitem(ary,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 1 of intP_getitem. Expected _p_int");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)intP_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_intP_setitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int *arg1 = (int *) 0 ;
        int arg2 ;
        int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: intP_setitem(ary,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 1 of intP_setitem. Expected _p_int");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        intP_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_intArray) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        intArray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_intArray(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (intArray *)new_intArray(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_intArray,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_intArray) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        intArray *arg1 = (intArray *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_intArray(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_intArray. Expected _p_intArray");
            }
        }
        delete_intArray(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_intArray_getitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        intArray *arg1 = (intArray *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: intArray_getitem(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of intArray_getitem. Expected _p_intArray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)intArray_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_intArray_setitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        intArray *arg1 = (intArray *) 0 ;
        int arg2 ;
        int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: intArray_setitem(self,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of intArray_setitem. Expected _p_intArray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        intArray_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_intArray_cast) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        intArray *arg1 = (intArray *) 0 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: intArray_cast(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of intArray_cast. Expected _p_intArray");
            }
        }
        result = (int *)intArray_cast(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_intArray_frompointer) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int *arg1 = (int *) 0 ;
        intArray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: intArray_frompointer(t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 1 of intArray_frompointer. Expected _p_int");
            }
        }
        result = (intArray *)intArray_frompointer(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_intArray,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_floatP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        float *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_floatP(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (float *)new_floatP(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_float,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_floatP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_floatP(ary);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_floatP. Expected _p_float");
            }
        }
        delete_floatP(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_floatP_getitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        int arg2 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: floatP_getitem(ary,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of floatP_getitem. Expected _p_float");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (float)floatP_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_floatP_setitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        int arg2 ;
        float arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: floatP_setitem(ary,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of floatP_setitem. Expected _p_float");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (float) SvNV(ST(2));
        
        floatP_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_floatArray) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        floatArray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_floatArray(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (floatArray *)new_floatArray(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_floatArray,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_floatArray) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        floatArray *arg1 = (floatArray *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_floatArray(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_floatArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_floatArray. Expected _p_floatArray");
            }
        }
        delete_floatArray(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_floatArray_getitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        floatArray *arg1 = (floatArray *) 0 ;
        int arg2 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: floatArray_getitem(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_floatArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of floatArray_getitem. Expected _p_floatArray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (float)floatArray_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_floatArray_setitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        floatArray *arg1 = (floatArray *) 0 ;
        int arg2 ;
        float arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: floatArray_setitem(self,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_floatArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of floatArray_setitem. Expected _p_floatArray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (float) SvNV(ST(2));
        
        floatArray_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_floatArray_cast) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        floatArray *arg1 = (floatArray *) 0 ;
        float *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: floatArray_cast(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_floatArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of floatArray_cast. Expected _p_floatArray");
            }
        }
        result = (float *)floatArray_cast(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_float,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_floatArray_frompointer) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        floatArray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: floatArray_frompointer(t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of floatArray_frompointer. Expected _p_float");
            }
        }
        result = (floatArray *)floatArray_frompointer(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_floatArray,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_doubleP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        double *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_doubleP(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (double *)new_doubleP(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_double,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_doubleP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        double *arg1 = (double *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_doubleP(ary);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_double,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_doubleP. Expected _p_double");
            }
        }
        delete_doubleP(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_doubleP_getitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        double *arg1 = (double *) 0 ;
        int arg2 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: doubleP_getitem(ary,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_double,0) < 0) {
                SWIG_croak("Type error in argument 1 of doubleP_getitem. Expected _p_double");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (double)doubleP_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_doubleP_setitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        double *arg1 = (double *) 0 ;
        int arg2 ;
        double arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: doubleP_setitem(ary,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_double,0) < 0) {
                SWIG_croak("Type error in argument 1 of doubleP_setitem. Expected _p_double");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (double) SvNV(ST(2));
        
        doubleP_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_doubleArray) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        doubleArray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_doubleArray(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (doubleArray *)new_doubleArray(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_doubleArray,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_doubleArray) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        doubleArray *arg1 = (doubleArray *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_doubleArray(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_doubleArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_doubleArray. Expected _p_doubleArray");
            }
        }
        delete_doubleArray(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_doubleArray_getitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        doubleArray *arg1 = (doubleArray *) 0 ;
        int arg2 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: doubleArray_getitem(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_doubleArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of doubleArray_getitem. Expected _p_doubleArray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (double)doubleArray_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_doubleArray_setitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        doubleArray *arg1 = (doubleArray *) 0 ;
        int arg2 ;
        double arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: doubleArray_setitem(self,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_doubleArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of doubleArray_setitem. Expected _p_doubleArray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (double) SvNV(ST(2));
        
        doubleArray_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_doubleArray_cast) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        doubleArray *arg1 = (doubleArray *) 0 ;
        double *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: doubleArray_cast(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_doubleArray,0) < 0) {
                SWIG_croak("Type error in argument 1 of doubleArray_cast. Expected _p_doubleArray");
            }
        }
        result = (double *)doubleArray_cast(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_double,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_doubleArray_frompointer) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        double *arg1 = (double *) 0 ;
        doubleArray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: doubleArray_frompointer(t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_double,0) < 0) {
                SWIG_croak("Type error in argument 1 of doubleArray_frompointer. Expected _p_double");
            }
        }
        result = (doubleArray *)doubleArray_frompointer(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_doubleArray,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_shortP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        short *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_shortP(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (short *)new_shortP(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_short,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_shortP) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        short *arg1 = (short *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_shortP(ary);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_short,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_shortP. Expected _p_short");
            }
        }
        delete_shortP(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_shortP_getitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        short *arg1 = (short *) 0 ;
        int arg2 ;
        short result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shortP_getitem(ary,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_short,0) < 0) {
                SWIG_croak("Type error in argument 1 of shortP_getitem. Expected _p_short");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (short)shortP_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_shortP_setitem) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        short *arg1 = (short *) 0 ;
        int arg2 ;
        short arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: shortP_setitem(ary,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_short,0) < 0) {
                SWIG_croak("Type error in argument 1 of shortP_setitem. Expected _p_short");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (short) SvIV(ST(2));
        shortP_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cdata) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        void *arg1 = (void *) 0 ;
        int arg2 = (int) 1 ;
        SWIGCDATA result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: cdata(ptr,nelements);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, 0,0) < 0) {
                SWIG_croak("Type error in argument 1 of cdata. Expected _p_void");
            }
        }
        if (items > 1) {
            arg2 = (int) SvIV(ST(1));
        }
        result = cdata_void(arg1,arg2);
        
        {
            ST(argvi) = sv_newmortal();
            sv_setpvn((SV*)ST(argvi++),(&result)->data,(&result)->len);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_memmove) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        void *arg1 = (void *) 0 ;
        void *arg2 = (void *) 0 ;
        int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: memmove(data,indata,inlen);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, 0,0) < 0) {
                SWIG_croak("Type error in argument 1 of memmove. Expected _p_void");
            }
        }
        {
            unsigned int temp;
            arg2 = (void *) SvPV(ST(1),temp);
            arg3 = (int) temp;
        }
        memmove(arg1,(void const *)arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_fold) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 = (char *) NULL ;
        float *arg3 = (float *) 0 ;
        char *result;
        float temp3 ;
        int argvi = 0;
        dXSARGS;
        
        arg3 = &temp3;
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: fold(string,constraints);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        result = (char *)my_fold(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setnv(ST(argvi),(double) *(arg3));
            argvi++;
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_energy_of_struct) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: energy_of_struct(string,structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (float)energy_of_struct((char const *)arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_free_arrays) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: free_arrays();");
        }
        free_arrays();
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_initialize_fold) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: initialize_fold(length);");
        }
        arg1 = (int) SvIV(ST(0));
        initialize_fold(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_update_fold_params) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: update_fold_params();");
        }
        update_fold_params();
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_pf_fold) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 = (char *) NULL ;
        float *arg3 = (float *) 0 ;
        char *result;
        float temp3 ;
        int argvi = 0;
        dXSARGS;
        
        arg3 = &temp3;
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: pf_fold(string,constraints);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        result = (char *)my_pf_fold(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setnv(ST(argvi),(double) *(arg3));
            argvi++;
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_init_pf_fold) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: init_pf_fold(length);");
        }
        arg1 = (int) SvIV(ST(0));
        init_pf_fold(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_free_pf_arrays) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: free_pf_arrays();");
        }
        free_pf_arrays();
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_update_pf_params) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: update_pf_params(length);");
        }
        arg1 = (int) SvIV(ST(0));
        update_pf_params(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_bppm_symbol) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        char result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: bppm_symbol(x);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of bppm_symbol. Expected _p_float");
            }
        }
        result = (char)bppm_symbol(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setpvn((SV*)ST(argvi++), &result, 1);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_pbacktrack) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: pbacktrack(sequence);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)pbacktrack(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_inverse_fold) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        float *arg3 = (float *) 0 ;
        char *result;
        float temp3 ;
        int argvi = 0;
        dXSARGS;
        
        arg3 = &temp3;
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: inverse_fold(start,target);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)my_inverse_fold(arg1,(char const *)arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setnv(ST(argvi),(double) *(arg3));
            argvi++;
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_inverse_pf_fold) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        float *arg3 = (float *) 0 ;
        char *result;
        float temp3 ;
        int argvi = 0;
        dXSARGS;
        
        arg3 = &temp3;
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: inverse_pf_fold(start,target);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)my_inverse_pf_fold(arg1,(char const *)arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setnv(ST(argvi),(double) *(arg3));
            argvi++;
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_bondT_i_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        bondT *arg1 = (bondT *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: bondT_i_set(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_bondT,0) < 0) {
                SWIG_croak("Type error in argument 1 of bondT_i_set. Expected _p_bondT");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->i = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_bondT_i_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        bondT *arg1 = (bondT *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: bondT_i_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_bondT,0) < 0) {
                SWIG_croak("Type error in argument 1 of bondT_i_get. Expected _p_bondT");
            }
        }
        result = (int) ((arg1)->i);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_bondT_j_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        bondT *arg1 = (bondT *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: bondT_j_set(self,j);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_bondT,0) < 0) {
                SWIG_croak("Type error in argument 1 of bondT_j_set. Expected _p_bondT");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->j = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_bondT_j_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        bondT *arg1 = (bondT *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: bondT_j_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_bondT,0) < 0) {
                SWIG_croak("Type error in argument 1 of bondT_j_get. Expected _p_bondT");
            }
        }
        result = (int) ((arg1)->j);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_bondT_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        bondT *arg1 = (bondT *) 0 ;
        int arg2 ;
        bondT *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: bondT_get(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_bondT,0) < 0) {
                SWIG_croak("Type error in argument 1 of bondT_get. Expected _p_bondT");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (bondT *)bondT_get(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_bondT,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_bondT) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        bondT *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_bondT();");
        }
        result = (bondT *)(bondT *) calloc(1, sizeof(bondT));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_bondT,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_bondT) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        bondT *arg1 = (bondT *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_bondT(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_bondT,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_bondT. Expected _p_bondT");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_option_string) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: option_string();");
        }
        result = (char *)option_string();
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_SOLUTION_energy_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *arg1 = (SOLUTION *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SOLUTION_energy_set(self,energy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_SOLUTION,0) < 0) {
                SWIG_croak("Type error in argument 1 of SOLUTION_energy_set. Expected _p_SOLUTION");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        if (arg1) (arg1)->energy = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_SOLUTION_energy_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *arg1 = (SOLUTION *) 0 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SOLUTION_energy_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_SOLUTION,0) < 0) {
                SWIG_croak("Type error in argument 1 of SOLUTION_energy_get. Expected _p_SOLUTION");
            }
        }
        result = (float) ((arg1)->energy);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_SOLUTION_structure_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *arg1 = (SOLUTION *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SOLUTION_structure_set(self,structure);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_SOLUTION,0) < 0) {
                SWIG_croak("Type error in argument 1 of SOLUTION_structure_set. Expected _p_SOLUTION");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->structure) free((char*)arg1->structure);
            if (arg2) {
                arg1->structure = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->structure,arg2);
            }else {
                arg1->structure = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_SOLUTION_structure_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *arg1 = (SOLUTION *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SOLUTION_structure_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_SOLUTION,0) < 0) {
                SWIG_croak("Type error in argument 1 of SOLUTION_structure_get. Expected _p_SOLUTION");
            }
        }
        result = (char *) ((arg1)->structure);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_SOLUTION_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *arg1 = (SOLUTION *) 0 ;
        int arg2 ;
        SOLUTION *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: SOLUTION_get(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_SOLUTION,0) < 0) {
                SWIG_croak("Type error in argument 1 of SOLUTION_get. Expected _p_SOLUTION");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (SOLUTION *)SOLUTION_get(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_SOLUTION,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_SOLUTION_size) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *arg1 = (SOLUTION *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: SOLUTION_size(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_SOLUTION,0) < 0) {
                SWIG_croak("Type error in argument 1 of SOLUTION_size. Expected _p_SOLUTION");
            }
        }
        result = (int)SOLUTION_size(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_SOLUTION) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *arg1 = (SOLUTION *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_SOLUTION(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_SOLUTION,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_SOLUTION. Expected _p_SOLUTION");
            }
        }
        delete_SOLUTION(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_SOLUTION) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        SOLUTION *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_SOLUTION();");
        }
        result = (SOLUTION *)(SOLUTION *) calloc(1, sizeof(SOLUTION));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_SOLUTION,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_subopt) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        int arg3 ;
        FILE *arg4 = (FILE *) NULL ;
        SOLUTION *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 4)) {
            SWIG_croak("Usage: subopt(seq,constraint,delta,fp);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        arg3 = (int) SvIV(ST(2));
        if (items > 3) {
            {
                if (SvOK(ST(3))) /* check for undef */
                arg4 = IoIFP(sv_2io(ST(3)));
                else  arg4 = NULL;
            }
        }
        result = (SOLUTION *)subopt(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_SOLUTION,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_get_pr) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        int arg2 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_pr(i,j);");
        }
        arg1 = (int) SvIV(ST(0));
        arg2 = (int) SvIV(ST(1));
        result = (double)get_pr(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_b2HIT) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: b2HIT(structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)b2HIT(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_b2C) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: b2C(structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)b2C(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_b2Shapiro) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: b2Shapiro(structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)b2Shapiro(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_add_root) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: add_root(char *);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)add_root(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_expand_Shapiro) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: expand_Shapiro(coarse);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)expand_Shapiro(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_expand_Full) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: expand_Full(structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)expand_Full(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_unexpand_Full) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: unexpand_Full(ffull);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)unexpand_Full(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_unweight) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: unweight(wcoarse);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)unweight(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_unexpand_aligned_F) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char **arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: unexpand_aligned_F(align);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 1 of unexpand_aligned_F. Expected _p_p_char");
            }
        }
        unexpand_aligned_F(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_parse_structure) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: parse_structure(structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        parse_structure(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_make_tree) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        Tree *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: make_tree(struc);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (Tree *)make_tree(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_Tree,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_tree_edit_distance) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        Tree *arg1 = (Tree *) 0 ;
        Tree *arg2 = (Tree *) 0 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: tree_edit_distance(T1,T2);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_Tree,0) < 0) {
                SWIG_croak("Type error in argument 1 of tree_edit_distance. Expected _p_Tree");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_Tree,0) < 0) {
                SWIG_croak("Type error in argument 2 of tree_edit_distance. Expected _p_Tree");
            }
        }
        result = (float)tree_edit_distance(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_print_tree) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        Tree *arg1 = (Tree *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: print_tree(t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_Tree,0) < 0) {
                SWIG_croak("Type error in argument 1 of print_tree. Expected _p_Tree");
            }
        }
        print_tree(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_free_tree) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        Tree *arg1 = (Tree *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: free_tree(t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_Tree,0) < 0) {
                SWIG_croak("Type error in argument 1 of free_tree. Expected _p_Tree");
            }
        }
        free_tree(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_Make_swString) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        swString *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Make_swString(string);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (swString *)Make_swString(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_swString,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_string_edit_distance) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        swString *arg1 = (swString *) 0 ;
        swString *arg2 = (swString *) 0 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: string_edit_distance(T1,T2);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_swString,0) < 0) {
                SWIG_croak("Type error in argument 1 of string_edit_distance. Expected _p_swString");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_swString,0) < 0) {
                SWIG_croak("Type error in argument 2 of string_edit_distance. Expected _p_swString");
            }
        }
        result = (float)string_edit_distance(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_Make_bp_profile) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        float *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: Make_bp_profile(length);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (float *)Make_bp_profile(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_float,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_profile_edit_distance) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        float *arg2 = (float *) 0 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: profile_edit_distance(T1,T2);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of profile_edit_distance. Expected _p_float");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 2 of profile_edit_distance. Expected _p_float");
            }
        }
        result = (float)profile_edit_distance((float const *)arg1,(float const *)arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_print_bppm) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: print_bppm(T);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of print_bppm. Expected _p_float");
            }
        }
        print_bppm((float const *)arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_free_profile) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        float *arg1 = (float *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: free_profile(T);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_float,0) < 0) {
                SWIG_croak("Type error in argument 1 of free_profile. Expected _p_float");
            }
        }
        free_profile(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_space) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        unsigned int arg1 ;
        void *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: space(size);");
        }
        arg1 = (unsigned int) SvUV(ST(0));
        result = (void *)space(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_void,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_xrealloc) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        void *arg1 = (void *) 0 ;
        unsigned int arg2 ;
        void *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: xrealloc(p,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, 0,0) < 0) {
                SWIG_croak("Type error in argument 1 of xrealloc. Expected _p_void");
            }
        }
        arg2 = (unsigned int) SvUV(ST(1));
        result = (void *)xrealloc(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_void,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_nrerror) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: nrerror(message);");
        }
        arg1 = SvPV(ST(0),PL_na);
        
        nrerror((char const (*))arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_init_rand) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: init_rand();");
        }
        init_rand();
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_urn) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: urn();");
        }
        result = (double)urn();
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_int_urn) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: int_urn(from,to);");
        }
        arg1 = (int) SvIV(ST(0));
        arg2 = (int) SvIV(ST(1));
        result = (int)int_urn(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_filecopy) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        FILE *arg1 = (FILE *) 0 ;
        FILE *arg2 = (FILE *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: filecopy(from,to);");
        }
        {
            if (SvOK(ST(0))) /* check for undef */
            arg1 = IoIFP(sv_2io(ST(0)));
            else  arg1 = NULL;
        }
        {
            if (SvOK(ST(1))) /* check for undef */
            arg2 = IoIFP(sv_2io(ST(1)));
            else  arg2 = NULL;
        }
        filecopy(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_time_stamp) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: time_stamp();");
        }
        result = (char *)time_stamp();
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_random_string) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        int arg1 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: random_string(l,symbols);");
        }
        arg1 = (int) SvIV(ST(0));
        arg2 = SvPV(ST(1),PL_na);
        
        result = (char *)random_string(arg1,(char const (*))arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_hamming) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: hamming(s1,s2);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)hamming((char const *)arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_get_line) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        FILE *arg1 = (FILE *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_line(fp);");
        }
        {
            if (SvOK(ST(0))) /* check for undef */
            arg1 = IoIFP(sv_2io(ST(0)));
            else  arg1 = NULL;
        }
        result = (char *)get_line((FILE const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_pack_structure) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: pack_structure(struc);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)pack_structure((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_unpack_structure) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: unpack_structure(packed);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)unpack_structure((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        }else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_make_pair_table) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        short *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: make_pair_table(structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (short *)make_pair_table((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_short,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_bp_distance) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: bp_distance(str1,str2);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)bp_distance((char const *)arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_read_parameter_file) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: read_parameter_file(fname);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        read_parameter_file(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_write_parameter_file) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: write_parameter_file(fname);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        write_parameter_file(arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_deref_any) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        void **arg1 = (void **) 0 ;
        int arg2 ;
        void *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: deref_any(ptr,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_p_void,0) < 0) {
                SWIG_croak("Type error in argument 1 of deref_any. Expected _p_p_void");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (void *)deref_any(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_void,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_scale_parameters) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        paramT *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: scale_parameters();");
        }
        result = (paramT *)scale_parameters();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_paramT,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_copy_parameters) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        paramT *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: copy_parameters();");
        }
        result = (paramT *)copy_parameters();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_paramT,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_set_parameters) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        paramT *arg1 = (paramT *) 0 ;
        paramT *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: set_parameters(dest);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_paramT,0) < 0) {
                SWIG_croak("Type error in argument 1 of set_parameters. Expected _p_paramT");
            }
        }
        result = (paramT *)set_parameters(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_paramT,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_make_loop_index) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        short *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: make_loop_index(structure);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (short *)make_loop_index((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_short,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_energy_of_move) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        int arg3 ;
        int arg4 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: energy_of_move(string,structure,mi,mj);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        result = (float)energy_of_move((char const *)arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_PS_rna_plot) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: PS_rna_plot(string,structure,file);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)PS_rna_plot(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_PS_rna_plot_a) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        char *arg3 ;
        char *arg4 ;
        char *arg5 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: PS_rna_plot_a(string,structure,file,pre,post);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        if (!SvOK((SV*) ST(3))) arg4 = 0;
        else arg4 = (char *) SvPV(ST(3), PL_na);
        if (!SvOK((SV*) ST(4))) arg5 = 0;
        else arg5 = (char *) SvPV(ST(4), PL_na);
        result = (int)PS_rna_plot_a(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_gmlRNA) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        char *arg3 ;
        char arg4 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: gmlRNA(string,structure,ssfile,option);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        arg4 = (char) *SvPV(ST(3),PL_na);
        result = (int)gmlRNA(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_ssv_rna_plot) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: ssv_rna_plot(string,structure,ssfile);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)ssv_rna_plot(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_svg_rna_plot) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: svg_rna_plot(string,structure,ssfile);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)svg_rna_plot(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_xrna_plot) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: xrna_plot(string,structure,ssfile);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)xrna_plot(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_PS_dot_plot) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: PS_dot_plot(string,file);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)PS_dot_plot(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_i_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: cpair_i_set(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_i_set. Expected _p_cpair");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->i = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_i_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: cpair_i_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_i_get. Expected _p_cpair");
            }
        }
        result = (int) ((arg1)->i);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_j_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: cpair_j_set(self,j);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_j_set. Expected _p_cpair");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->j = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_j_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: cpair_j_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_j_get. Expected _p_cpair");
            }
        }
        result = (int) ((arg1)->j);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_mfe_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: cpair_mfe_set(self,mfe);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_mfe_set. Expected _p_cpair");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->mfe = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_mfe_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: cpair_mfe_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_mfe_get. Expected _p_cpair");
            }
        }
        result = (int) ((arg1)->mfe);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_p_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: cpair_p_set(self,p);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_p_set. Expected _p_cpair");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        if (arg1) (arg1)->p = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_p_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: cpair_p_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_p_get. Expected _p_cpair");
            }
        }
        result = (float) ((arg1)->p);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_hue_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: cpair_hue_set(self,hue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_hue_set. Expected _p_cpair");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        if (arg1) (arg1)->hue = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_hue_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: cpair_hue_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_hue_get. Expected _p_cpair");
            }
        }
        result = (float) ((arg1)->hue);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_sat_set) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        float arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: cpair_sat_set(self,sat);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_sat_set. Expected _p_cpair");
            }
        }
        arg2 = (float) SvNV(ST(1));
        
        if (arg1) (arg1)->sat = arg2;
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_cpair_sat_get) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        float result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: cpair_sat_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of cpair_sat_get. Expected _p_cpair");
            }
        }
        result = (float) ((arg1)->sat);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_new_cpair) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_cpair();");
        }
        result = (cpair *)(cpair *) calloc(1, sizeof(cpair));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_cpair,0);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_delete_cpair) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        cpair *arg1 = (cpair *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_cpair(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_cpair. Expected _p_cpair");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}


XS(_wrap_PS_color_dot_plot) {
    char _swigmsg[SWIG_MAX_ERRMSG] = "";
    const char *_swigerr = _swigmsg;
    {
        char *arg1 ;
        cpair *arg2 = (cpair *) 0 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: PS_color_dot_plot(string,pi,filename);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_cpair,0) < 0) {
                SWIG_croak("Type error in argument 2 of PS_color_dot_plot. Expected _p_cpair");
            }
        }
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)PS_color_dot_plot(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        (void) _swigerr;
    }
    croak(_swigerr);
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_floatArrayTo_p_float(void *x) {
    return (void *)((float *)  ((floatArray *) x));
}
static void *_p_intArrayTo_p_int(void *x) {
    return (void *)((int *)  ((intArray *) x));
}
static void *_p_doubleArrayTo_p_double(void *x) {
    return (void *)((double *)  ((doubleArray *) x));
}
static swig_type_info _swigt__p_SOLUTION[] = {{"RNA::SOLUTION", 0, "SOLUTION *", 0},{"RNA::SOLUTION"},{0}};
static swig_type_info _swigt__p_intArray[] = {{"RNA::intArray", 0, "intArray *", 0},{"RNA::intArray"},{0}};
static swig_type_info _swigt__p_double[] = {{"_p_double", 0, "double *", 0},{"RNA::doubleArray", _p_doubleArrayTo_p_double},{"_p_double"},{0}};
static swig_type_info _swigt__p_cpair[] = {{"RNA::cpair", 0, "cpair *", 0},{"RNA::cpair"},{0}};
static swig_type_info _swigt__p_swString[] = {{"_p_swString", 0, "swString *", 0},{"_p_swString"},{0}};
static swig_type_info _swigt__p_float[] = {{"_p_float", 0, "float *", 0},{"_p_float"},{"RNA::floatArray", _p_floatArrayTo_p_float},{0}};
static swig_type_info _swigt__p_void[] = {{"_p_void", 0, "void *", 0},{"_p_void"},{0}};
static swig_type_info _swigt__p_floatArray[] = {{"RNA::floatArray", 0, "floatArray *", 0},{"RNA::floatArray"},{0}};
static swig_type_info _swigt__p_doubleArray[] = {{"RNA::doubleArray", 0, "doubleArray *", 0},{"RNA::doubleArray"},{0}};
static swig_type_info _swigt__p_p_void[] = {{"_p_p_void", 0, "void **", 0},{"_p_p_void"},{0}};
static swig_type_info _swigt__p_short[] = {{"_p_short", 0, "short *", 0},{"_p_short"},{0}};
static swig_type_info _swigt__p_p_char[] = {{"_p_p_char", 0, "char **", 0},{"_p_p_char"},{0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *", 0},{"_p_char"},{0}};
static swig_type_info _swigt__p_unsigned_short[] = {{"_p_unsigned_short", 0, "unsigned short *", 0},{"_p_unsigned_short"},{0}};
static swig_type_info _swigt__p_paramT[] = {{"_p_paramT", 0, "paramT *", 0},{"_p_paramT"},{0}};
static swig_type_info _swigt__p_Tree[] = {{"_p_Tree", 0, "Tree *", 0},{"_p_Tree"},{0}};
static swig_type_info _swigt__p_FILE[] = {{"_p_FILE", 0, "FILE *", 0},{"_p_FILE"},{0}};
static swig_type_info _swigt__p_bondT[] = {{"RNA::bondT", 0, "bondT *", 0},{"RNA::bondT"},{0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0},{"RNA::intArray", _p_intArrayTo_p_int},{"_p_int"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_SOLUTION, 
_swigt__p_intArray, 
_swigt__p_double, 
_swigt__p_cpair, 
_swigt__p_swString, 
_swigt__p_float, 
_swigt__p_void, 
_swigt__p_floatArray, 
_swigt__p_doubleArray, 
_swigt__p_p_void, 
_swigt__p_short, 
_swigt__p_p_char, 
_swigt__p_char, 
_swigt__p_unsigned_short, 
_swigt__p_paramT, 
_swigt__p_Tree, 
_swigt__p_FILE, 
_swigt__p_bondT, 
_swigt__p_int, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_constant_info swig_constants[] = {
{ SWIG_FLOAT,   (char *) SWIG_prefix "VERSION", 0, (double) 0.3, 0, 0},
{0}
};
#ifdef __cplusplus
}
#endif
static swig_variable_info swig_variables[] = {
    { "RNAc::symbolset", MAGIC_CLASS _wrap_set_symbolset, MAGIC_CLASS _wrap_val_symbolset,0 },
    { "RNAc::final_cost", MAGIC_CLASS _wrap_set_final_cost, MAGIC_CLASS _wrap_val_final_cost,0 },
    { "RNAc::give_up", MAGIC_CLASS _wrap_set_give_up, MAGIC_CLASS _wrap_val_give_up,0 },
    { "RNAc::noGU", MAGIC_CLASS _wrap_set_noGU, MAGIC_CLASS _wrap_val_noGU,0 },
    { "RNAc::no_closingGU", MAGIC_CLASS _wrap_set_no_closingGU, MAGIC_CLASS _wrap_val_no_closingGU,0 },
    { "RNAc::tetra_loop", MAGIC_CLASS _wrap_set_tetra_loop, MAGIC_CLASS _wrap_val_tetra_loop,0 },
    { "RNAc::energy_set", MAGIC_CLASS _wrap_set_energy_set, MAGIC_CLASS _wrap_val_energy_set,0 },
    { "RNAc::dangles", MAGIC_CLASS _wrap_set_dangles, MAGIC_CLASS _wrap_val_dangles,0 },
    { "RNAc::nonstandards", MAGIC_CLASS _wrap_set_nonstandards, MAGIC_CLASS _wrap_val_nonstandards,0 },
    { "RNAc::temperature", MAGIC_CLASS _wrap_set_temperature, MAGIC_CLASS _wrap_val_temperature,0 },
    { "RNAc::james_rule", MAGIC_CLASS _wrap_set_james_rule, MAGIC_CLASS _wrap_val_james_rule,0 },
    { "RNAc::logML", MAGIC_CLASS _wrap_set_logML, MAGIC_CLASS _wrap_val_logML,0 },
    { "RNAc::cut_point", MAGIC_CLASS _wrap_set_cut_point, MAGIC_CLASS _wrap_val_cut_point,0 },
    { "RNAc::base_pair", MAGIC_CLASS _wrap_set_base_pair, MAGIC_CLASS _wrap_val_base_pair,&SWIGTYPE_p_bondT },
    { "RNAc::pr", MAGIC_CLASS _wrap_set_pr, MAGIC_CLASS _wrap_val_pr,&SWIGTYPE_p_double },
    { "RNAc::iindx", MAGIC_CLASS _wrap_set_iindx, MAGIC_CLASS _wrap_val_iindx,&SWIGTYPE_p_int },
    { "RNAc::pf_scale", MAGIC_CLASS _wrap_set_pf_scale, MAGIC_CLASS _wrap_val_pf_scale,0 },
    { "RNAc::fold_constrained", MAGIC_CLASS _wrap_set_fold_constrained, MAGIC_CLASS _wrap_val_fold_constrained,0 },
    { "RNAc::do_backtrack", MAGIC_CLASS _wrap_set_do_backtrack, MAGIC_CLASS _wrap_val_do_backtrack,0 },
    { "RNAc::noLonelyPairs", MAGIC_CLASS _wrap_set_noLonelyPairs, MAGIC_CLASS _wrap_val_noLonelyPairs,0 },
    { "RNAc::backtrack_type", MAGIC_CLASS _wrap_set_backtrack_type, MAGIC_CLASS _wrap_val_backtrack_type,0 },
    { "RNAc::subopt_sorted", MAGIC_CLASS _wrap_set_subopt_sorted, MAGIC_CLASS _wrap_val_subopt_sorted,0 },
    { "RNAc::loop_size", MAGIC_CLASS _wrap_set_loop_size, MAGIC_CLASS _wrap_val_loop_size,&SWIGTYPE_p_int },
    { "RNAc::helix_size", MAGIC_CLASS _wrap_set_helix_size, MAGIC_CLASS _wrap_val_helix_size,&SWIGTYPE_p_int },
    { "RNAc::loop_degree", MAGIC_CLASS _wrap_set_loop_degree, MAGIC_CLASS _wrap_val_loop_degree,&SWIGTYPE_p_int },
    { "RNAc::loops", MAGIC_CLASS _wrap_set_loops, MAGIC_CLASS _wrap_val_loops,0 },
    { "RNAc::unpaired", MAGIC_CLASS _wrap_set_unpaired, MAGIC_CLASS _wrap_val_unpaired,0 },
    { "RNAc::pairs", MAGIC_CLASS _wrap_set_pairs, MAGIC_CLASS _wrap_val_pairs,0 },
    { "RNAc::edit_backtrack", MAGIC_CLASS _wrap_set_edit_backtrack, MAGIC_CLASS _wrap_val_edit_backtrack,0 },
    { "RNAc::aligned_line", MAGIC_CLASS _wrap_set_aligned_line, MAGIC_CLASS _wrap_val_aligned_line,&SWIGTYPE_p_p_char },
    { "RNAc::cost_matrix", MAGIC_CLASS _wrap_set_cost_matrix, MAGIC_CLASS _wrap_val_cost_matrix,0 },
    { "RNAc::xsubi", MAGIC_CLASS _wrap_set_xsubi, MAGIC_CLASS _wrap_val_xsubi,&SWIGTYPE_p_unsigned_short },
    { "RNAc::rna_plot_type", MAGIC_CLASS _wrap_set_rna_plot_type, MAGIC_CLASS _wrap_val_rna_plot_type,0 },
{0}
};
static swig_command_info swig_commands[] = {
{"RNAc::new_intP", _wrap_new_intP},
{"RNAc::delete_intP", _wrap_delete_intP},
{"RNAc::intP_getitem", _wrap_intP_getitem},
{"RNAc::intP_setitem", _wrap_intP_setitem},
{"RNAc::new_intArray", _wrap_new_intArray},
{"RNAc::delete_intArray", _wrap_delete_intArray},
{"RNAc::intArray_getitem", _wrap_intArray_getitem},
{"RNAc::intArray_setitem", _wrap_intArray_setitem},
{"RNAc::intArray_cast", _wrap_intArray_cast},
{"RNAc::intArray_frompointer", _wrap_intArray_frompointer},
{"RNAc::new_floatP", _wrap_new_floatP},
{"RNAc::delete_floatP", _wrap_delete_floatP},
{"RNAc::floatP_getitem", _wrap_floatP_getitem},
{"RNAc::floatP_setitem", _wrap_floatP_setitem},
{"RNAc::new_floatArray", _wrap_new_floatArray},
{"RNAc::delete_floatArray", _wrap_delete_floatArray},
{"RNAc::floatArray_getitem", _wrap_floatArray_getitem},
{"RNAc::floatArray_setitem", _wrap_floatArray_setitem},
{"RNAc::floatArray_cast", _wrap_floatArray_cast},
{"RNAc::floatArray_frompointer", _wrap_floatArray_frompointer},
{"RNAc::new_doubleP", _wrap_new_doubleP},
{"RNAc::delete_doubleP", _wrap_delete_doubleP},
{"RNAc::doubleP_getitem", _wrap_doubleP_getitem},
{"RNAc::doubleP_setitem", _wrap_doubleP_setitem},
{"RNAc::new_doubleArray", _wrap_new_doubleArray},
{"RNAc::delete_doubleArray", _wrap_delete_doubleArray},
{"RNAc::doubleArray_getitem", _wrap_doubleArray_getitem},
{"RNAc::doubleArray_setitem", _wrap_doubleArray_setitem},
{"RNAc::doubleArray_cast", _wrap_doubleArray_cast},
{"RNAc::doubleArray_frompointer", _wrap_doubleArray_frompointer},
{"RNAc::new_shortP", _wrap_new_shortP},
{"RNAc::delete_shortP", _wrap_delete_shortP},
{"RNAc::shortP_getitem", _wrap_shortP_getitem},
{"RNAc::shortP_setitem", _wrap_shortP_setitem},
{"RNAc::cdata", _wrap_cdata},
{"RNAc::memmove", _wrap_memmove},
{"RNAc::fold", _wrap_fold},
{"RNAc::energy_of_struct", _wrap_energy_of_struct},
{"RNAc::free_arrays", _wrap_free_arrays},
{"RNAc::initialize_fold", _wrap_initialize_fold},
{"RNAc::update_fold_params", _wrap_update_fold_params},
{"RNAc::pf_fold", _wrap_pf_fold},
{"RNAc::init_pf_fold", _wrap_init_pf_fold},
{"RNAc::free_pf_arrays", _wrap_free_pf_arrays},
{"RNAc::update_pf_params", _wrap_update_pf_params},
{"RNAc::bppm_symbol", _wrap_bppm_symbol},
{"RNAc::pbacktrack", _wrap_pbacktrack},
{"RNAc::inverse_fold", _wrap_inverse_fold},
{"RNAc::inverse_pf_fold", _wrap_inverse_pf_fold},
{"RNAc::bondT_i_set", _wrap_bondT_i_set},
{"RNAc::bondT_i_get", _wrap_bondT_i_get},
{"RNAc::bondT_j_set", _wrap_bondT_j_set},
{"RNAc::bondT_j_get", _wrap_bondT_j_get},
{"RNAc::bondT_get", _wrap_bondT_get},
{"RNAc::new_bondT", _wrap_new_bondT},
{"RNAc::delete_bondT", _wrap_delete_bondT},
{"RNAc::option_string", _wrap_option_string},
{"RNAc::SOLUTION_energy_set", _wrap_SOLUTION_energy_set},
{"RNAc::SOLUTION_energy_get", _wrap_SOLUTION_energy_get},
{"RNAc::SOLUTION_structure_set", _wrap_SOLUTION_structure_set},
{"RNAc::SOLUTION_structure_get", _wrap_SOLUTION_structure_get},
{"RNAc::SOLUTION_get", _wrap_SOLUTION_get},
{"RNAc::SOLUTION_size", _wrap_SOLUTION_size},
{"RNAc::delete_SOLUTION", _wrap_delete_SOLUTION},
{"RNAc::new_SOLUTION", _wrap_new_SOLUTION},
{"RNAc::subopt", _wrap_subopt},
{"RNAc::get_pr", _wrap_get_pr},
{"RNAc::b2HIT", _wrap_b2HIT},
{"RNAc::b2C", _wrap_b2C},
{"RNAc::b2Shapiro", _wrap_b2Shapiro},
{"RNAc::add_root", _wrap_add_root},
{"RNAc::expand_Shapiro", _wrap_expand_Shapiro},
{"RNAc::expand_Full", _wrap_expand_Full},
{"RNAc::unexpand_Full", _wrap_unexpand_Full},
{"RNAc::unweight", _wrap_unweight},
{"RNAc::unexpand_aligned_F", _wrap_unexpand_aligned_F},
{"RNAc::parse_structure", _wrap_parse_structure},
{"RNAc::make_tree", _wrap_make_tree},
{"RNAc::tree_edit_distance", _wrap_tree_edit_distance},
{"RNAc::print_tree", _wrap_print_tree},
{"RNAc::free_tree", _wrap_free_tree},
{"RNAc::Make_swString", _wrap_Make_swString},
{"RNAc::string_edit_distance", _wrap_string_edit_distance},
{"RNAc::Make_bp_profile", _wrap_Make_bp_profile},
{"RNAc::profile_edit_distance", _wrap_profile_edit_distance},
{"RNAc::print_bppm", _wrap_print_bppm},
{"RNAc::free_profile", _wrap_free_profile},
{"RNAc::space", _wrap_space},
{"RNAc::xrealloc", _wrap_xrealloc},
{"RNAc::nrerror", _wrap_nrerror},
{"RNAc::init_rand", _wrap_init_rand},
{"RNAc::urn", _wrap_urn},
{"RNAc::int_urn", _wrap_int_urn},
{"RNAc::filecopy", _wrap_filecopy},
{"RNAc::time_stamp", _wrap_time_stamp},
{"RNAc::random_string", _wrap_random_string},
{"RNAc::hamming", _wrap_hamming},
{"RNAc::get_line", _wrap_get_line},
{"RNAc::pack_structure", _wrap_pack_structure},
{"RNAc::unpack_structure", _wrap_unpack_structure},
{"RNAc::make_pair_table", _wrap_make_pair_table},
{"RNAc::bp_distance", _wrap_bp_distance},
{"RNAc::read_parameter_file", _wrap_read_parameter_file},
{"RNAc::write_parameter_file", _wrap_write_parameter_file},
{"RNAc::deref_any", _wrap_deref_any},
{"RNAc::scale_parameters", _wrap_scale_parameters},
{"RNAc::copy_parameters", _wrap_copy_parameters},
{"RNAc::set_parameters", _wrap_set_parameters},
{"RNAc::make_loop_index", _wrap_make_loop_index},
{"RNAc::energy_of_move", _wrap_energy_of_move},
{"RNAc::PS_rna_plot", _wrap_PS_rna_plot},
{"RNAc::PS_rna_plot_a", _wrap_PS_rna_plot_a},
{"RNAc::gmlRNA", _wrap_gmlRNA},
{"RNAc::ssv_rna_plot", _wrap_ssv_rna_plot},
{"RNAc::svg_rna_plot", _wrap_svg_rna_plot},
{"RNAc::xrna_plot", _wrap_xrna_plot},
{"RNAc::PS_dot_plot", _wrap_PS_dot_plot},
{"RNAc::cpair_i_set", _wrap_cpair_i_set},
{"RNAc::cpair_i_get", _wrap_cpair_i_get},
{"RNAc::cpair_j_set", _wrap_cpair_j_set},
{"RNAc::cpair_j_get", _wrap_cpair_j_get},
{"RNAc::cpair_mfe_set", _wrap_cpair_mfe_set},
{"RNAc::cpair_mfe_get", _wrap_cpair_mfe_get},
{"RNAc::cpair_p_set", _wrap_cpair_p_set},
{"RNAc::cpair_p_get", _wrap_cpair_p_get},
{"RNAc::cpair_hue_set", _wrap_cpair_hue_set},
{"RNAc::cpair_hue_get", _wrap_cpair_hue_get},
{"RNAc::cpair_sat_set", _wrap_cpair_sat_set},
{"RNAc::cpair_sat_get", _wrap_cpair_sat_get},
{"RNAc::new_cpair", _wrap_new_cpair},
{"RNAc::delete_cpair", _wrap_delete_cpair},
{"RNAc::PS_color_dot_plot", _wrap_PS_color_dot_plot},
{0,0}
};

#ifdef __cplusplus
extern "C"
#endif

XS(SWIG_init) {
    dXSARGS;
    int i;
    static int _init = 0;
    if (!_init) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        _init = 1;
    }
    
    /* Install commands */
    for (i = 0; swig_commands[i].name; i++) {
        newXS((char*) swig_commands[i].name,swig_commands[i].wrapper, (char*)__FILE__);
    }
    
    /* Install variables */
    for (i = 0; swig_variables[i].name; i++) {
        SV *sv;
        sv = perl_get_sv((char*) swig_variables[i].name, TRUE | 0x2);
        if (swig_variables[i].type) {
            SWIG_MakePtr(sv,(void *)1, *swig_variables[i].type,0);
        }else {
            sv_setiv(sv,(IV) 0);
        }
        swig_create_magic(sv, (char *) swig_variables[i].name, swig_variables[i].set, swig_variables[i].get); 
    }
    
    /* Install constant */
    for (i = 0; swig_constants[i].type; i++) {
        SV *sv;
        sv = perl_get_sv((char*)swig_constants[i].name, TRUE | 0x2);
        switch(swig_constants[i].type) {
            case SWIG_INT:
            sv_setiv(sv, (IV) swig_constants[i].lvalue);
            break;
            case SWIG_FLOAT:
            sv_setnv(sv, (double) swig_constants[i].dvalue);
            break;
            case SWIG_STRING:
            sv_setpv(sv, (char *) swig_constants[i].pvalue);
            break;
            case SWIG_POINTER:
            SWIG_MakePtr(sv, swig_constants[i].pvalue, *(swig_constants[i].ptype),0);
            break;
            case SWIG_BINARY:
            /*      obj = SWIG_NewPackedObj(swig_constants[i].pvalue, swig_constants[i].lvalue, *(swig_constants[i].ptype)); */
            break;
            default:
            break;
        }
        SvREADONLY_on(sv);
    }
    
    SWIG_TypeClientData(SWIGTYPE_p_intArray, (void*) "RNA::intArray");
    SWIG_TypeClientData(SWIGTYPE_p_floatArray, (void*) "RNA::floatArray");
    SWIG_TypeClientData(SWIGTYPE_p_doubleArray, (void*) "RNA::doubleArray");
    SWIG_TypeClientData(SWIGTYPE_p_bondT, (void*) "RNA::bondT");
    SWIG_TypeClientData(SWIGTYPE_p_SOLUTION, (void*) "RNA::SOLUTION");
    
    /* work around segfault when script tries to free symbolset */
    
    symbolset = (char *) space(21);
    strcpy(symbolset, "AUGC");
    
    
    SWIG_TypeClientData(SWIGTYPE_p_cpair, (void*) "RNA::cpair");
    ST(0) = &PL_sv_yes;
    XSRETURN(1);
}

