
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

static char rcsid[]=
  "$Header: /nfs/u5/braden/NNStat/src/RCS/etherifrt.c,v 3.2 92/12/02 16:22:25 braden Rel $";

/*  This routine replaces "etherif.c" for use with the IBM RT
    PC.  It assumes a modified Berkeley packet filter instead of
    the proprietary Sun NIT interface.  As such there are no
    copyright restrictions on this code. */

/*
 *   CHANGES:
 *      Rel 3.0:  
 *   ISI: Move rtpc_compat.c here.
 *   ISI: Move RT-dependent code here from parse()
 */
 
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/errno.h>

#include "stat.h"
#include "pfiltrt.h" /*** #include <sys/enet.h> ***/
#include "packet.h"

#define DATANEEDED (64+sizeof(union ip_data)-sizeof(struct ip))

struct rcv_packet {
    struct LengthWords length;
    struct tap_header pk_taphdr;
    struct packet rcv_packet[sizeof(struct packet)]; /* force byte alignment */
    u_char rcv_data[DATANEEDED];
};

int snaplen = sizeof(struct packet) + DATANEEDED;

#define READBUFSIZE (127*sizeof(struct rcv_packet))
char readbuf[READBUFSIZE];

extern int errno;
int if_fd = -1;
extern char *EtherIface;

/*
 *  Open packet filter and initialize it.
 *
 *  The parameter passed selects a particular ethernet type field;
 *  however, we don't support this and ignore it instead.  Tant pis.
 */

initdevice(EtherType)
int EtherType;
{
#ifdef DEBUG
    register int i;
    struct endevp devp;
#endif DEBUG
    struct eniocb ctl;
    struct enfilter filter;
    unsigned maxwaiting;

    if (if_fd < 0) {

        /*  Open the device. */
    
        if (EtherIface) {
            if_fd = open(EtherIface, O_RDONLY, 0);
        } else {
            GETENETDEVICE(0, O_RDONLY, &if_fd);
        }
        if (if_fd == -1) {
            perror("enet open error");
            exit(-1);
        }
    
#ifdef  DEBUG
        /*  Get device parameters. */
    
        if (ioctl(if_fd, EIOCDEVP, &devp) == -1) {
            perror("enet EIOCDEVP ioctl error");
            exit(-1);
        }
        printf("type = %d, adrlen = %d, hdrlen = %d, MTU = %d\n",
            (int) devp.end_dev_type, (int) devp.end_addr_len, 
            (int) devp.end_hdr_len, (int) devp.end_MTU);
        printf("addr = ");
        for (i=0; i< devp.end_addr_len; i++) {
            if (i != 0) printf(":");
            printf("%x", devp.end_addr[i]);
        }
        printf("\n");
        printf("broadcast addr = ");
        for (i=0; i< devp.end_addr_len; i++) {
            if (i != 0) printf(":");
            printf("%x", devp.end_broadaddr[i]);
        }
        printf("\n");
#endif  DEBUG
    
        /*  Get operating parameters. */
    
        if (ioctl(if_fd, EIOCGETP, &ctl) == -1) {
            perror("Ioctl EIOCGETP error, errno = %d\n", errno);
            exit(-1);
        }

#ifdef  DEBUG
        printf("Maxwaiting = %d, Maxprio = %d, timeout = %ld, maxfilters = %d\n", 
            (int) ctl.en_maxwaiting, (int) ctl.en_maxpriority, 
            ctl.en_rtout, ctl.en_maxfilters);
#endif  DEBUG
    
        /*  Set operating parameters. */
    
        ctl.en_rtout = 1 * ctl.en_hz;
        ctl.en_tr_etherhead = 1;
        ctl.en_tap_network = 1;
        ctl.en_multi_packet = 1;
        ctl.en_maxlen = snaplen;
        if (ioctl(if_fd, EIOCSETP, &ctl) == -1) {
            perror("enet ioctl EIOCSETP error");
            exit(-1);
        }

        /*  Flush the receive queue, since we've changed
            the operating parameters and we otherwise might
            receive data without headers. */

        if (ioctl(if_fd, EIOCFLUSH) == -1) {
            perror("enet ioctl EIOCFLUSH error");
            exit(-1);
        }

        /*  Set the receive queue depth to its maximum. */

        maxwaiting = ctl.en_maxwaiting;
        if (ioctl(if_fd, EIOCSETW, &maxwaiting) == -1) {
            perror("enet ioctl EIOCSETW error");
            exit(-1);
        }
    
        /*  Set the filter. */
    
        filter.enf_Priority = 3;
        filter.enf_FilterLen = 0;
        if (ioctl(if_fd, EIOCSETF, &filter) == -1) {
            perror("enet ioctl EIOCSETF error");
            exit(-1);
        }
    }
}

deinitdevice()
{
    close(if_fd);
    if_fd = -1;
}

readether()
{
    register int readlen;
    register struct rcv_packet *readptr;
    register int offset;
    readlen = read(if_fd, (caddr_t) readbuf, sizeof(readbuf));
    if (readlen < 0) {
        lseek(if_fd, 0, 0);
        readlen = read(if_fd, (caddr_t) readbuf, sizeof(readbuf));
        if (readlen < 0)
            perror("readether error");
    }
    readptr = (struct rcv_packet *) readbuf;
    while ((char *) readptr < readbuf + readlen) {
        offset = readptr->length.PacketOffset;
        if (offset < sizeof(struct LengthWords) ||
            offset > sizeof(struct rcv_packet) + 4) {
            printf("Bad read data, length %d, offset %d\n",
                readptr->length.PacketLength, offset);
            break;
        }
        
        parse(((char *)&(readptr->rcv_packet)),
               readptr->length.PacketLength - sizeof(struct tap_header),
               readptr->pk_taphdr.th_wirelen,
               *((struct timeval *) (readptr->pk_taphdr.th_timestamp))
             );
             
        readptr = (struct rcv_packet *) (((char *) readptr) + offset);
    }
} /* readether() */

      
/*
 * returns TRUE IFF something interesting to report.
 *    Doesn't reference "outp" if it returns FALSE.
 */
boolean if_stats(outp)
char *outp;
{
      /* XXX Finish this code XXX */
      return(FALSE);
}
