
/****************************************************************************/
/*                                                                          */
/*      NNstat -- Internet Statistics Collection Package                    */
/*                                                                          */
/*            Written by: Bob Braden & Annette DeSchon                      */
/*            USC Information Sciences Institute                            */
/*            Marina del Rey, California                                    */
/*                                                                          */
/*      Copyright (c) 1991 University of Southern California.               */
/*      All rights reserved.                                                */
/*                                                                          */
/*      Redistribution and use in source and binary forms are permitted     */
/*      provided that the above copyright notice and this paragraph are     */
/*      duplicated in all such forms and that any documentation,            */
/*      advertising materials, and other materials related to such          */
/*      distribution and use acknowledge that the software was              */
/*      developed by the University of Southern California, Information     */
/*      Sciences Institute.  The name of the University may not be used     */
/*      to endorse or promote products derived from this software           */
/*      without specific prior written permission.                          */
/*      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR        */
/*      IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED      */
/*      WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR          */
/*      PURPOSE.                                                            */
/*                                                                          */
/****************************************************************************/

/* $Header: /nfs/u5/braden/NNStat/src/RCS/collect.h,v 3.2 92/12/02 16:22:08 braden Rel $ */

#include "stat.h"
 
#define MAX_ADDRS 20
#define MAX_STATS 50
#define TIMEOUT  60

#ifndef FALSE
#define FALSE   0       /* logical false */
#define TRUE    1       /* logical true */
#endif

/*
 * CHANGES: 27Jan89 ISI:  Fix typedefs, increase MAX_ADDRS
 */
 
typedef struct obj_desc {
        boolean query,
                saventry;
        char    sname[MAX_OBJNAME+1],           /* object name */
                fname[28+MAX_OBJNAME+1];        /* log file */
/*              15(host) + 1(-) + 12(date) = 28 */
        FILE    *logptr;
        long     logindex;
        long    rtime,
                ctime;
        } obj_desc;

typedef struct collector {
        char            hostname[256];
        struct in_addr  inetaddr;
        long            readtime,
                        creation,
                        nextclear;
                        
        /* array of structures for things to collect */
        struct obj_desc s[MAX_STATS];
        } collector;        

    /* Supply definitions missing in RT systems */
#ifndef LITTLEEND
#ifndef ntohl
#define ntohl(x) (x)
#endif
#ifndef htonl
#define htonl(x) (x)
#endif
#endif
