
%{
 
/************************************************************************** 
 *     NNstat -- Internet Statistics Collection Package                   *
 *                                                                        *
 *        Written by: Bob Braden & Annette DeSchon                        *
 *        USC Information Sciences Institute                              *
 *        Marina del Rey, California                                      *
 *        1987-1990                                                       *
 *                                                                        *
 *     NNStat is Public Domain, and may be used for any purpose as long   * 
 *     as this notice is not removed.                                     *
 **************************************************************************/ 
 
         /* LEX grammar for statspy commands */

/*
 * CHANGES:
 *    Rel 3.0
 *   Cisco:  Count input lines for error msgs
 *
 */         
union values yyval;	
extern int  search(), ucsearch();
int sp;
u_long line_number = 1;

%}

B  [ \t]
D  [0-9]
IP  [0-9.]
HEX [0-9a-fA-F]
ETH [0-9a-fA-F:]
  
%%
#.* ;
{B}+ ;
"\n" { ++line_number; }

":" |
"," ;

[a-zA-Z&*][a-zA-Z0-9._*+&$-]* {
	  if ((sp = search(yytext, RsvdWds)) != -1) 
	  		return(RsvdToken[sp]);
	  if ((sp = search(yytext, class_name)) != -1 ||
	      (sp = search(yytext, class_nick)) != -1 
	  ) {
	  		yyval.int_val = sp; return(CLASS); 
	  };
	  return(IDTOKEN);
	};	
\"[^",\n]*\" return(STRING);  	      
"("  return('(');  
")"  return(')'); 
"{"  return('{');
"}"  return('}');
";"  return(';');
"?"  return('?');

{D}+ |
"0"(x|X){HEX}+  return(NUMBER) ;
{D}+"."{IP}+    return(IPADDR) ;
{HEX}+":"{ETH}+  return(ETHERA) ;
. {printf("Wrong input: %s\n", yytext); BEGIN 0;}
%%

