// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include <iostream.h>
#include "NE.hh"
#include "debug.hh"

#define DBG_REDUCE 3
#define DBG_REDUCE_DETAIL 4
#define DBG_OR 5
#define DBG_NOT 6

CLASS_DEBUG_MEMORY_CC(NormalExpression);

ostream& operator<<(ostream& stream, NormalExpression& ne) {
   NormalTerm *term;
   Pix i;

   switch (ne.any()) {
   case ANY: 
      stream << "ANY";
      break;
   case NOT_ANY:
      stream << "NOT ANY";
      break;
   default:
      for (i = ne.terms.first(); i; ) {
	 term = ne.terms(i);
	 stream << "(" << *term << ")";
	 ne.terms.next(i);
	 if (i)
	    stream << "\n OR ";
      }
   }
   return stream;
}

void NormalExpression::reduce() {
   NormalTerm *term, *otherterm;
   int change = 1;
   Pix pixi, pixj, nextpixj;

   // worst case O(N^3) Sigh.
   // can be improved by keeping sorted lists on set sizes
   while (change) {
      change = 0;
      for (pixi = terms.first(); pixi; terms.next(pixi)) {
	 term = terms(pixi);
	 for (pixj = pixi, terms.next(pixj); pixj; pixj = nextpixj) {
	    otherterm = terms(pixj);
	    nextpixj = pixj;
	    terms.next(nextpixj);

	    Debug(dbg[DBG_REDUCE_DETAIL] << *this << "\n");
	    
	    for (int i = 0; i < NT_SET_COUNT; i++) {
	       for (int j = 0; j < NT_SET_COUNT; j++)
		  if (j != i && !((*term)[j] == (*otherterm)[j]))
		     break;
	       if (j == NT_SET_COUNT) {
		  (*term)[i] |= (*otherterm)[i];
		  
		  delete otherterm;
		  terms.del(pixj);

		  change = 1;
		  break;
	       } 
	    }

	    for (int j = 0; j < NT_SET_COUNT; j++)
	       if (!(*term)[j].universal())
		  break;
	    if (j == NT_SET_COUNT) { 
	       // we became ANY
	       become_universal();
	       return;
	    }
	 }
	 Debug(dbg[DBG_REDUCE] << *this << "\n");
      }
   }
}

void NormalExpression::do_or(NormalExpression &other) {

   if (any() == ANY)
      return;
   if (other.any() == NOT_ANY)
      return;

   if (other.any() == ANY) { // become ANY
      become_universal();
      return;
   }

   if (any() == NOT_ANY) { // become other
      terms.join(other.terms);
      return;
   }

   ASSERT(any() == NEITHER && other.any() == NEITHER);

   // add his terms to my terms
   terms.join(other.terms);

   Debug(dbg[DBG_OR] << *this << "\n");
 
   // get rid of duplicate terms
   reduce();
}

void NormalExpression::do_and(NormalExpression &other) {
   NormalTerm *term, *newt, *otherterm;
   NormalExpression result;

   if (any() == NOT_ANY)
      return;
   if (other.any() == ANY)
      return;

   if (other.any() == NOT_ANY) { // become NOT ANY
      terms.clear(); 
      return;
   }

   if (any() == ANY) { // become other
      terms.clear();
      terms.join(other.terms);
      return;
   }

   ASSERT(any() == NEITHER && other.any() == NEITHER);

   // do a cartesian product
   for (Pix pixi = terms.first(); pixi;  terms.next(pixi)) {
      term = terms(pixi);
      for (Pix pixj = other.terms.first(); pixj;  other.terms.next(pixj)) {
	 otherterm = other.terms(pixj);
	 newt = new NormalTerm;

	 for (int i=0; i < NT_SET_COUNT; i++) {
	    (*newt)[i] = (*term)[i];
	    (*newt)[i] &= (*otherterm)[i];
	    if ((*newt)[i].empty()) {
	       delete newt;
	       goto skip_otherterm;
	    }
	 }

	 result.terms.append(newt);

	skip_otherterm: ;
      }
   }
   
   terms.clear();
   terms.join(result.terms);
   if (!terms.empty())
      reduce();   // get rid of duplicate terms
}

void NormalExpression::do_not() {
   NormalTerm *term, *newt;
   NormalExpression result;
   NormalExpression tmpexp;

   if (any() == NOT_ANY) { // become ANY
      become_universal();
      return;
   }
   if (any() == ANY) { // become NOT_ANY
      terms.clear();
      return;
   }

   result.become_universal();
 
   for (Pix pixi = terms.first(); pixi;  terms.next(pixi)) {
      term = terms(pixi);
      for (int i = 0; i < NT_SET_COUNT; i++) {
	 if (!(*term)[i].universal()) {
	    newt = new NormalTerm;
	    (*newt)[i] = (*term)[i];
	    ~(*newt)[i];

	    newt->make_universal(i);

	    tmpexp.terms.append(newt);
	 }
      }

      Debug(dbg[DBG_NOT] << tmpexp << "\n"); 
      result.do_and(tmpexp);
      tmpexp.terms.clear(); // this also free's elements' memory
   }

   terms.clear();
   terms.join(result.terms);
}

