// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef NT_H
#define NT_H

#include <iostream.h>
#include <sys/stdtypes.h>
#include "SetOfInt.hh"
#include "SetOfSymbol.hh"
#include "SetOfASPath.hh"
#include "SetOfPref.hh"
#include "SetOfMED.hh"
#include "debug.hh"
#include "peval.hh"
#include "ASMacroMap.h"
#include "CommDBSelMap.h"

extern ASMacroMap *ASMacroST;   // AS Macro name symbol table
extern CommDBSelMap *CommDBSelST; // Community Name/DB Selector symbl tbl

#define AS 0
#define PRFX 1
#define AS_SYM 2
#define AS_MACROS 3
#define PRFX_MACROS 4
#define AS_PATH 5
#define PREF 6
#define MED 7
#define NT_SET_COUNT 8

class NormalTerm {
private:
   NormalTerm(NormalTerm& a) { // so no temporaries
      copy_constructor("NormalTerm"); 
   }
public:
   SetOfInt        as_set;	 // Normal term means as_set INTERSECTION
   SetOfInt        prfx_set;	 // prfx_set INTERSECTION 
   SetOfSymbol     as_sym;       // as_sym INTERSECTION 
   SetOfSymbol     as_macros;    // as_macros INTERSECTION 
   SetOfSymbol     prfx_macros;  // prfx_macros INTERSECTION 
   SetOfASPath     as_path;      // as_path INTERSECTION
   SetOfPref       pref;         // preference, a singleton set
   SetOfMED        med;          // med, a singleton set

   NormalTerm() : as_sym(ASMacroST), 
                  as_macros(ASMacroST), 
                  prfx_macros(CommDBSelST) { 
      as_set.format = AS_format;
      as_set.format_open = "(";
      as_set.format_delimiter = " ";
      as_set.format_close = ")";
      prfx_set.format = PRFX_format;
      as_sym.format = AS_MACROS_format;       
      as_macros.format = AS_MACROS_format;    
      prfx_macros.format = PRFX_MACROS_format;  
      as_path.format = AS_Path_format;
      as_path.format_open = "<^[";
      as_path.format_delimiter = " ";
      as_path.format_close = "]>";
  }
   ~NormalTerm() {
   }

   Set& operator [] (int i) {
      switch (i) {
      case AS:
	 return as_set;
      case PRFX:
	 return prfx_set;
      case AS_SYM:
	 return as_sym;
      case AS_MACROS:
	 return as_macros;
      case PRFX_MACROS:
	 return prfx_macros;
      case AS_PATH:
	 return as_path;
      case PREF:
	 return pref;
      case MED:
	 return med;
      default:
	 ASSERT(0);
      }
   }

   friend ostream& operator<<(ostream& stream, NormalTerm& nt);

   void make_universal(int exception = -1);

   int universal() {
      return as_set.universal() && 
	 prfx_set.universal() && 
	 as_sym.universal() && 
	 as_macros.universal() && 
	 prfx_macros.universal() && 
	 as_path.universal() && 
	 pref.universal() && 
	 med.universal();
   }

   CLASS_DEBUG_MEMORY_HH(NormalTerm);
};

typedef NormalTerm* NormalTermPtr;

#endif   // NT_H

