// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "debug.hh"
#include "SetOfInt.hh"
#include <stdio.h>

char *SetOfInt_format(int i) {
   static char formatbuffer[16]; // This variable is allocated on data segment

   sprintf(formatbuffer, "%d", i);
   return formatbuffer;
}

void SetOfInt::do_print (ostream& stream) {
   stream << *this;
}

ostream& operator<<(ostream& stream, SetOfInt& set) {
   Pix i;

   if (set._universal)
      stream << "UNIVERSAL";
   else {
      if (set.not)
	 stream << "NOT";

      stream << set.format_open;
      for (i=set.members.first(); i; ) {
	 stream << (*set.format)(set.members(i));
	 set.members.next(i);
	 if (i)
	    stream << set.format_delimiter;
      }
      stream << set.format_close;
   }
   
   return stream;
}

int SetOfInt::add(int  item) {     // add item; return non-zero if successfull
   if (_universal)
      return 1;
   
   if (not) {
      members.del(item);
      if (members.empty()) {
	 not = 0;
	 _universal = 1;
      }
      return 1;
   }

   return (int) members.add(item);
}

void SetOfInt::operator |= (SetOfInt& b) { // union
   _SetOfInt c;

   if (_universal || b.empty())
      ; // done
   else
      if (b._universal) {
	 members.clear();
	 _universal = 1;
	 not = 0;
      } else {
	 switch (not*2+b.not) {
	 case 0: // not = 0, b.not = 0 => this UNION b = members UNION b.members
	    members |= b.members;
	    break;
	 case 1: // not = 0, b.not = 1 => this UNION b = members MINUS b.members
	    c = members;
	    members = b.members;
	    members -= c;
	    not = 1;
 	    break;
	 case 2: // not = 1, b.not = 0 => this UNION b = b.members MINUS members
	    members -= b.members;
 	    break;
	 case 3: // not = 1, b.not = 1 => this UNION b = members INTERSECTION b.members
	    members &= b.members;
	    break;
	 default:
	    ASSERT(0);
	 }
	 if (empty() && not) { // case 1,2,3 can cause this
	    _universal = 1;
	    not = 0;
	 }
      }
}

void SetOfInt::operator &= (SetOfInt& b) { // intersection
   _SetOfInt c;

   if (empty() || b._universal)
      ; // done
   else
      if (b.empty()) {
	 members.clear();
	 _universal = 0;
	 not = 0;
      } else 
	 if (_universal) {
	    _universal = b._universal;
	    not = b.not;
	    members = b.members;
	 } else {
	    switch (not*2+b.not) {
	    case 0: // not = 0, b.not = 0 => this INTSCTN b = members INTSCTN b.members
	       members &= b.members;
	       break;
	    case 1: // not = 0, b.not = 1 => this INTSCTN b = members MINUS b.members
	       members -= b.members;
	       break;
	    case 2: // not = 1, b.not = 0 => this INTSCTN b = b.members MINUS members
	       c = members;
	       members = b.members;
	       members -= c;	    
	       not = 0;
	       break;
	    case 3: // not = 1, b.not = 1 => this INTSCTN b = members UNION b.members
	       members |= b.members;
	       break;
	    default:
	       ASSERT(0);
	    }
	 }
}

void SetOfInt::operator ~  () { // complement
   if (_universal) {
      ASSERT(members.empty());
      _universal = 0;
   } else 
      if (empty()) {
	 ASSERT(! not);
	 _universal = 1;
      } else
	 not = ! not;
}

int  SetOfInt::operator == (SetOfInt& other) { // equivalance
   return (_universal == other._universal 
	   && not == other.not
	   && members == other.members);
}

void  SetOfInt::operator = (SetOfInt& other) { // assignment
   members.clear();
   not = other.not;
   _universal = other._universal;
   members = other.members;
}
