// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef SetOfInt_H
#define SetOfInt_H

#include <iostream.h>
#include "int.AVLSet.h"
#include "Set.hh"

typedef class intAVLSet _SetOfInt;

extern char *SetOfInt_format(int i);

// the following set class can perform set complement operation 
// without knowing the universal set
class SetOfInt : public Set {
public:
   SetOfInt() : members() {
      _universal = 0;
      not = 0;
      format = SetOfInt_format;
      format_open = "{";
      format_delimiter = ", ";
      format_close = "}";
   };
   SetOfInt(SetOfInt& other) { 
      not = other.not;
      _universal = other._universal;
      members = other.members;
   }
   ~SetOfInt() {
      members.clear();
   };

   virtual int empty() {
      return (! _universal && members.empty());
   }

   virtual int universal() {
      return (_universal);
   }
   virtual int negated() {
      return (not);
   }

   virtual void make_universal() {
      _universal = 1;
      not = 0;
      members.clear();
   }

   virtual int add(int  item);     // add item; return non-zero if successfull
   void clear() {
      members.clear();
      _universal = 0;
      not = 0;
   }

   virtual void operator ~  (); // complement
   void operator |= (SetOfInt& b); // union
   void operator &= (SetOfInt& b); // intersection
   int  operator == (SetOfInt& b); // equivalance
   void operator =  (SetOfInt& b); // assignment
   // below is an ugly trick
   virtual void operator |= (Set& b) {
      *this |= (SetOfInt&) b;
   }
   virtual void operator &= (Set& b) {
      *this &= (SetOfInt&) b;
   }
   virtual int  operator == (Set& b) {
      return (*this == (SetOfInt&) b);
   }
   virtual void operator =  (Set& b) {
      *this = (SetOfInt&) b;
   }

   void operator =  (_SetOfInt& b) { // assignment from _SetOfInt
      _universal = 0;
      not = 0;
      members = b;
   }
   operator _SetOfInt& () { // assignment from _SetOfInt
      return members;
   }
   friend ostream& operator<<(ostream& stream, SetOfInt& nt);
   // The folowing are format parameters
   char *(*format)(int i);
   char *format_open;
   char *format_delimiter;
   char *format_close;

   virtual void do_print (ostream& stream);

   int first() {
      pixi = members.first();
      return members(pixi);
   }
   int next() {
      members.next(pixi);
      return pixi ? members(pixi) : 0;
   }
   int length() {
      return members.length();
   }

private:
   _SetOfInt        members;	// elements if not = false
   int              _universal;  // true if set equals universal set
   int              not;        // if true, set = not members
   Pix              pixi;
};


#endif // SetOfInt_H
