// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary Preffor lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#ifndef SetOfPref_H
#define SetOfPref_H

#include <stdio.h>
#include "Set.hh"


#define PREF_EMPTY       -4
#define PREF_UNIVERSAL   -3

extern char *SetOfPref_format(int i);

class SetOfPref : public Set {
private:
   SetOfPref(const SetOfPref& other) { // so no temporaries
   }

public:
   SetOfPref() {
      format = SetOfPref_format;
      format_open = "(pref=";
      format_delimiter = "";
      format_close = ")";
      pref = PREF_EMPTY;
   }
   ~SetOfPref() {}
   
   virtual int empty() {
      return (pref == PREF_EMPTY);
   }

   virtual int universal() {
      return (pref == PREF_UNIVERSAL);
   }

   virtual void make_universal() {
      pref = PREF_UNIVERSAL;
   }

   virtual int add(int  item) { // add item; return non-zero if successfull
      return pref = item;	 
   } 

   virtual void operator ~  () { // complement, does not make sense
      if (pref == PREF_EMPTY)
	 pref = PREF_UNIVERSAL;
      if (pref == PREF_UNIVERSAL)
	 pref = PREF_EMPTY;
   } 
   void operator |= (SetOfPref& b) { // union
      if (pref == PREF_EMPTY || (pref != PREF_UNIVERSAL && b.pref < pref))
	 pref = b.pref;
   } 

   void operator &= (SetOfPref& b) { // intersection
      if (pref == PREF_UNIVERSAL || (pref != PREF_EMPTY && b.pref > pref))
	 pref = b.pref;
   } 

   int  operator == (SetOfPref& b) { // equivalance
      return (pref == b.pref);
   } 
   void operator =  (SetOfPref& b) { // assignment
      pref = b.pref;
   }

   operator int () {
      return pref;
   }

   // below is an ugly trick
   virtual void operator |= (Set& b) {
      *this |= (SetOfPref&) b;
   }
   virtual void operator &= (Set& b) {
      *this &= (SetOfPref&) b;
   }
   virtual int  operator == (Set& b) {
      return (*this == (SetOfPref&) b);
   }
   virtual void operator =  (Set& b) {
      *this = (SetOfPref&) b;
   }

   friend ostream& operator<<(ostream& stream, SetOfPref& set);

   // The folowing are format parameters
   char *(*format)(int i);
   char *format_open;
   char *format_delimiter;
   char *format_close;

   virtual void do_print (ostream& stream);

private:
   int pref;
};

#endif   // SetOfPref_H
