// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#ifndef SetOfSymbol_H
#define SetOfSymbol_H

#include <stdio.h>
#include "SymbolConjunct.hh"
#include "SymbolConjunctPtr.SplayBag.h"
#include "Set.hh"
#include "STName.SymTab.AVLMap.h"

typedef class SymbolConjunctPtrSplayBag BagOfSymbolConjunct;

extern char *SetOfSymbol_format(int i);

class SetOfSymbol : public Set {
private:
   SetOfSymbol(const SetOfSymbol& other) { // so no temporaries
   }

public:
   SetOfSymbol() {
      ASSERT(0);
      _universal = 0;
      STable = 0;
      format = SetOfSymbol_format;
      format_open = "(";
      format_delimiter = " ";
      format_close = ")";
   }
   SetOfSymbol(STNameSymTabAVLMap *_STable) {
      _universal = 0;
      STable = _STable;
      format = SetOfSymbol_format;
      format_open = "(";
      format_delimiter = " ";
      format_close = ")";
   }

   ~SetOfSymbol();
   
   virtual int empty() {
      return (! _universal && conjuncts.empty());
   }

   virtual int universal() {
      return (_universal);
   }

   virtual void make_universal() {
      clear();
      _universal = 1;
   }

   virtual int add(int  itEm); // add item; return non-zero if successfull

   virtual void operator ~  (); // complement
   void operator |= (SetOfSymbol& b); // union
   void operator &= (SetOfSymbol& b); // intersection
   int  operator == (SetOfSymbol& b); // equivalance
   void operator =  (SetOfSymbol& b); // assignment
   // below is an ugly trick
   virtual void operator |= (Set& b) {
      *this |= (SetOfSymbol&) b;
   }
   virtual void operator &= (Set& b) {
      *this &= (SetOfSymbol&) b;
   }
   virtual int  operator == (Set& b) {
      return (*this == (SetOfSymbol&) b);
   }
   virtual void operator =  (Set& b) {
      *this = (SetOfSymbol&) b;
   }

   friend ostream& operator<<(ostream& stream, SetOfSymbol& set);

   // The folowing are format parameters
   char *(*format)(int i);
   char *format_open;
   char *format_delimiter;
   char *format_close;

   virtual void do_print (ostream& stream);

private:
   BagOfSymbolConjunct conjuncts;
   int _universal;

   STNameSymTabAVLMap *STable;

   void clear();
   void reduce();
   void do_symbolic_or(_SetOfInt& a, _SetOfInt& b);

};

#endif   // SetOfSymbol_H
