// $Id: f_gated.cc,v 1.13 95/04/17 15:53:45 cengiz Exp $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "polparse.h"
#include "NE.hh"
#include "list.h"
#include <iostream.h>
#include <iomanip.h>
#include <ctype.h>

#define DBG_GATED 7

// this should be in peval.hh, but causes circular dependency
NormalExpression* parse_and_evaluate (char *str, int expand);

static void gated_print_net_list(SetOfInt nets, 
				 int pref, int med, int import_flag) {
   static char close[64];

   if (nets.empty())
      return;

   if (import_flag)
      if (pref < 0)
	 strcpy(close, "\trestrict;\n");
      else
	 if (med != -2 && opt_config == CONFIG_ROUTESERVER)
	    sprintf(close, "\tpreference %d MED %d;\n", pref, med);
	 else
	    sprintf(close, "\tpreference %d;\n", pref);
   else
       if (pref == -1)
	 strcpy(close, "\trestrict;\n");
       else 
	  if (pref == -2)
	     sprintf(close, "\t;\n");
	  else
	     sprintf(close, "\tmetric %d;\n", pref);

   
   nets.format = PRFX_format;
   nets.format_delimiter  = close;
   nets.format_close      = close;
   nets.format_open       = "";

   cout << nets;
}

static int as_no_compare(const void *a, const void *b) {
   return * (int *) a - * (int *) b;
}

static void print_as_path (ostream& stream, SetOfASPath& set) {
   Pix i;

   stream << "(";

   if (set.universal())
      stream << ".*";
   else {
      if (set.negated()) {
	 cerr << "Warning: some gated do not support negation: "
	    << set << endl;

 	 stream << " (";
	 { 
	    unsigned int as_nos[set.length()];
	    unsigned int start = 1;
	    unsigned int j;

	    for (j = 0, i=(Pix) set.first(); i; i = (Pix) set.next(), j++)
	       as_nos[j] = atoi(ASPathST->key(i));

	    qsort(as_nos, set.length(), sizeof(int), as_no_compare);

	    for (j = 0; j < set.length(); j++) {
	       if (j || as_nos[j] != 1) {
		  cout << start << " - " << as_nos[j] - 1;
		  if (j < set.length() && as_nos[j] != 65535)
		     cout << " | ";
	       }
	       start = as_nos[j] + 1;
	    }
	    if (as_nos[j-1] != 65535)
	       cout << start << " - 65535";

	 }
	 stream << ") .*";
     } else {
	 stream << "(";
	 for (i=(void *) set.first(); i; ) {
	    stream << ASPathST->key(i); // (*set.format)((int) i);
	    i = (void *) set.next();
	    if (i)
	       stream << " | ";
	 }
	 stream << ") .*";
      }
   }

   stream << ")";
}

class f_gated_node {
private:
   f_gated_node(f_gated_node &b) {}
public:
   f_gated_node() {}
   SetOfASPath  as_path;
   int       contains;
};

void gated_process_line(char *str, int expand, int import_flag) {
   char *first_str;
   char *rest_str;
   char *tmp_str;
   NormalExpression *ne, *ne_this;
   NormalTerm *nt;
   NormalExpression covered;
   NormalExpression dup;
   SetOfInt nets_covered;	 
   int all_pref = -1;
   int all_med = -2;
   int pref;
   int med;
   char *last_str;
   int last;
   int include;

   ne = new NormalExpression;

   // multi preference expression
   for (first_str = rest_str = str, last = 0; 
	first_str && !nets_covered.universal() && !last; 
	first_str = rest_str) {
      
      if (rest_str = strchr(rest_str, '+')) {
	 *rest_str = 0;
	 rest_str++;
      }
   
      tmp_str = first_str;
      if (first_str = strchr(first_str, ' ')) {
	 *first_str = 0;
	 first_str++;

	 pref = -2;
	 if (isdigit(*tmp_str))
	    pref = atoi(tmp_str);

	 med = -2;
	 if (tmp_str = strchr(tmp_str, ':')) {
	    tmp_str++;
	    if (isdigit(*tmp_str))
	       med = atoi(tmp_str);
	 }

      } else {
	 cerr << "Error locating preference in " << tmp_str << endl;
	 pref = 0;
	 med = -2;
	 first_str = tmp_str;
      }

      // need to make sure there is only one expression per preference
      ne_this = parse_and_evaluate(first_str, expand);

      if (!ne_this) // i.e. error happended
	 continue;

      if (ne_this->universal()) 
	 last = 1;
      
      for (nt = ne_this->first(); nt; nt = ne_this->next()) {
	 nt->pref.add(pref);
	 if (opt_config == CONFIG_ROUTESERVER)
	    nt->med.add(med);
      }

      Debug(dbg[DBG_GATED] << "# " << *ne_this << "\n");

      ne->do_or(*ne_this); // actually, just append to the list 
      delete ne_this;
   }

   Debug(dbg[DBG_GATED] << "# " << *ne << "\n");

   if (ne) {
      // ne has nterms each has an as path expression, a prefix set, and a pref
      // reorganize ne so that
      //    all as paths expressions are exclusive (i.e. no intersection)
      //    this will create exponential number of nterms 
      //    many of which will be empty 
      //    (prefix sets, pref) will be so rted inside as path

      if (ne->universal()) {
	 if (import_flag)
	    cout << "import proto bgp aspath .* origin any view " 
	       << (char *) view_name << " preference 0;\n\n";
	 else 
	    cout << "   proto bgp aspath .* origin any " 
	       << (char *) view_name << " {\n      all;\n   };\n\n";
	 delete ne;
	 return;
      }


      if (ne->length() > 32) {
	 cerr << "Error: expression is too complicated for gated, contains more than 32 (as-path expression, netlist, pref) triplets, which may cause billions of gated import/export statements..." << endl;
	 delete ne;
	 return;
      }

      // with n (as-path expression, netlist, pref) triplets
      // we have to generate 2^n-1 gated import statements
      // because gated stops after first as path match

      
      list<f_gated_node*> result;
      f_gated_node* node;
      unsigned int fill;
      unsigned int i;
      list<f_gated_node*>::iterator pi;
      list<f_gated_node*>::reverse_iterator rpi;

      for (i = 1, nt = ne->first(); nt; nt = ne->next(), i <<= 1) {
	 for (pi = result.begin(); pi != result.end(); pi++)
	    if ((*pi)->as_path == nt->as_path)
	       break;
	 if (pi != result.end())
	    (*pi)->contains |= i;
	 else {
	    node = new f_gated_node;
	    node->as_path = nt->as_path;
	    node->contains = i;
	    result.insert(result.end(), node);
	 }
	 Debug(dbg[DBG_GATED] << hex << i << "\n");
      }

      Pix pj;
      for (pi = result.begin(); pi != result.end(); pi++) {
	 for (fill = 0, i = 1, nt = ne->first(); 
	      nt; 
	      nt = ne->next(), fill |= i, i <<= 1) {
	    Debug(dbg[DBG_GATED] << (*pi)->contains << " " << i << " ");
	    if (!((*pi)->contains & i) && !((*pi)->contains & fill)) {
	       node = new f_gated_node;
	       node->as_path = (*pi)->as_path;
	       node->as_path &= nt->as_path;
	       if (!node->as_path.empty()) {
		  node->contains = (*pi)->contains | i;
		  result.insert(result.end(), node);
		  Debug(dbg[DBG_GATED] << hex << node->contains);
	       } else
		  delete node;
	    }
	    Debug(dbg[DBG_GATED] << "\n");
	 }
      }

      
      SetOfASPath as_path_covered;

      for (rpi = result.rbegin(), last = 0; rpi != result.rend() && !last; rpi++) {
	 if (!(*rpi)->as_path.universal()) {
	    ~as_path_covered;
	    (*rpi)->as_path &= as_path_covered;
	    ~as_path_covered;
	 }
	 if (!(*rpi)->as_path.empty()) {
	    as_path_covered |= (*rpi)->as_path;
	    last = as_path_covered.universal();
	    (*rpi)->as_path.format_open = "(";
	    (*rpi)->as_path.format_close = ") .*";
	    (*rpi)->as_path.format_delimiter = " | ";
	    if (import_flag)
	       cout << "import proto bgp ";
	    else
	       cout << "   proto bgp ";
	    
	    if (result.size() == 1 && (*rpi)->as_path.universal())
	       if (import_flag)
		  cout << "as " << (char *) peer_as_no << " ";
	       else {
		  cout << "aspath .* origin any ";
	       }
	    else {
	       cout << "aspath ";
	       if (opt_config == CONFIG_ROUTESERVER)
		  cout << (char *) peer_as_no << " ";
	       print_as_path(cout, (*rpi)->as_path);
	       cout << " origin any ";
	    }

	    if (import_flag)
	       cout << (char *) view_name <<  " {\n";
	    else
	       cout << "{\n";
	    // now print the as path expression with the network lists
	    
	    nets_covered.clear();
	    all_pref = -1;
	    all_med  = -2;
	    SetOfInt prfx;
	    for (include = (*rpi)->contains, nt = ne->first(); 
		 nt; 
		 nt = ne->next(), include >>= 1)
	       if (include & 1) {
		  if (opt_print_cmmnts)
		     cout << "# " << *nt << "\n";
		  prfx = nt->prfx_set;
		  ~nets_covered;
		  prfx &= nets_covered;
		  ~nets_covered;
		  if (!prfx.empty()) {
		     nets_covered |= prfx;
		     if (all_pref == -1 
			 && (nets_covered.negated() || nets_covered.universal())) {
			all_pref = nt->pref;
			all_med  = nt->med;
		     } else 
			gated_print_net_list(prfx, nt->pref, nt->med, import_flag);
		  }
	       }
	    if (all_pref == -1) 
	       if (import_flag)
		  cout << "   all restrict;\n";
	       else
		  cout << "      all restrict;\n";
	    else {
	       if (nets_covered.negated()) {
		  ~nets_covered;
		  gated_print_net_list(nets_covered, -1, -2, import_flag);   
	       }
	       if (import_flag)
		  if (opt_config == CONFIG_ROUTESERVER)
		     if (all_med != -2)
			cout << "   all preference " << all_pref << " MED " << all_med << ";\n";
		     else
			cout << "   all preference " << all_pref << ";\n";
		  else
		     cout << "   all preference " << all_pref << ";\n";
	       else
		  if (all_pref == -2) 
		     cout << "      all;\n";
		  else
		     cout << "      all metric " << all_pref << ";\n";
	    }
	    if (import_flag)
	       cout << "};\n\n";
	    else
	       cout << "   };\n\n";
	 }
      }
      for (pi = result.begin(); pi != result.end(); pi++)
	 delete *pi; 
      // note that this does not delete the link in the linked list, 
      // it just deletes the what it points.
   }

   delete ne;
}

