// $Id: f_peval.cc,v 1.5 95/03/16 19:22:31 cengiz Exp $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "polparse.h"
#include "NE.hh"
// this should be in peval.hh, but causes circular dependency
NormalExpression* parse_and_evaluate (char *str, int expand);

char *AS_format(int i) {
   return ASST->key((Pix) i);
}

char *PRFX_format(int i) {
   static char PRFX_format_buffer[64];
   char *address = (*PrefaskST)((Pix) i);
   char *masklen;

   if (*address_prefix_format) { // if there is a format string use it
      masklen = strchr(address, '/');

      if (masklen) {
	 *masklen = 0;
	 masklen++;
	 sprintf(PRFX_format_buffer, address_prefix_format,  address, masklen);
	 masklen--;
	 *masklen = '/';
	 return PRFX_format_buffer;
      } else
	 return address;

   } else
      return address;
}

char *AS_MACROS_format(int i) {
   return ASMacroST->key((Pix) i);
}

char *PRFX_MACROS_format(int i) {
   return CommDBSelST->key((Pix) i);
}

char *AS_Path_format(int i) {
   static char format_buffer[64];
   sprintf(format_buffer, "AS%s", ASPathST->key((Pix) i));
   return format_buffer;
}

void peval_process_line(char *str, int expand, int import_flag) {
   NormalExpression *ne;

   if (ne = parse_and_evaluate(str, expand)) {
      cout << *ne << endl;
      delete ne;
   }
}
