// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _intAVL_h
#ifdef __GNUG__
#pragma interface
#endif
#define _intAVL_h 1

#include "int.Set.h"

struct intAVLNode
{
  intAVLNode*         lt;
  intAVLNode*         rt;
  int                 item;
  char                stat;
                      intAVLNode(int  h, intAVLNode* l=0, intAVLNode* r=0);
                      ~intAVLNode();
};

inline intAVLNode::intAVLNode(int  h, intAVLNode* l, intAVLNode* r)
:item(h), lt(l), rt(r), stat(0) {}

inline intAVLNode::~intAVLNode() {}

typedef intAVLNode* intAVLNodePtr;


class intAVLSet : public intSet
{
protected:
  intAVLNode*   root;

                intAVLSet(intAVLNode* p, int l);

  intAVLNode*   leftmost();
  intAVLNode*   rightmost();
  intAVLNode*   pred(intAVLNode* t);
  intAVLNode*   succ(intAVLNode* t);
  void          _kill(intAVLNode* t);
  void          _add(intAVLNode*& t);
  void          _del(intAVLNode* p, intAVLNode*& t);

public:
                intAVLSet();
                intAVLSet(intAVLSet& a);
                ~intAVLSet();

  Pix           add(int  item);
  void          del(int  item);
  int           contains(int  item);

  void          clear();

  Pix           first();
  void          next(Pix& i);
  int&          operator () (Pix i);
  int           owns(Pix i);
  Pix           seek(int  item);

  Pix           last();
  void          prev(Pix& i);

  void          operator |= (intAVLSet& b);
  void          operator -= (intAVLSet& b);
  void          operator &= (intAVLSet& b);

  int           operator == (intAVLSet& b);
  int           operator != (intAVLSet& b);
  int           operator <= (intAVLSet& b); 

   intAVLSet& operator=(intAVLSet&);

  int           OK();
};

inline intAVLSet::~intAVLSet()
{
  _kill(root);
}

inline intAVLSet::intAVLSet()
{
  root = 0;
  count = 0;
}

inline intAVLSet::intAVLSet(intAVLNode* p, int l)
{
  root = p;
  count = l;
}

inline int intAVLSet::operator != (intAVLSet& b)
{
  return ! ((*this) == b);
}

inline Pix intAVLSet::first()
{
  return Pix(leftmost());
}

inline Pix intAVLSet::last()
{
  return Pix(rightmost());
}

inline void intAVLSet::next(Pix& i)
{
  if (i != 0) i = Pix(succ((intAVLNode*)i));
}

inline void intAVLSet::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((intAVLNode*)i));
}

inline int& intAVLSet::operator () (Pix i)
{
  if (i == 0) error("null Pix");
  return ((intAVLNode*)i)->item;
}

inline void intAVLSet::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int intAVLSet::contains(int  key)
{
  return seek(key) != 0;
}

#endif
