// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include <iostream.h>
#include "ASMacroMap.h"
#include "ASMap.h"

extern ASMap *ASST;


// This routine returns an array of AS numbers of the form, ASXX.  Each ASXX
// is separated from the next by a space.  The last ASXX in the array is
// also followed by a space.
// This routine always returns an array of at least one element.

Error* ASMacroMap::expand_as_macro(DBCnxn &dbcnxn, 
                                   const char *macro_name, 
                                   char *&as_nums)
{
    char rc,
         buf[100],
         *strings;             // Array of null-term'd as num strings.
    int  bytes_read,
         bytes_expected,       // Total num of bytes we expect to read.
         bytes_left,           // Num bytes left for writing in strings.
         num_as;               // Num ASs when macro expanded

	sprintf(buf,"i%s,1\n", macro_name);
	(void) dbcnxn.write_query(buf); // Write query. Throw away return code.

	// Read the first line to determine how much mem to malloc.
	rc = dbcnxn.read_response( bytes_read, buf, sizeof(buf) );

	if ( rc != 'A' ) {                // Verify that we did in fact read the
		as_nums = NULL;                 // line type we expected to read.
		return( new Error(rc, buf) );
	}

	bytes_expected = atoi( buf );

	rc = dbcnxn.readn_response( bytes_read, strings, bytes_expected );

	if ( rc != 'B' ) {
		cerr << "Error:" << __FILE__<<"("<<__LINE__<<") Expected to read ";
		cerr << bytes_expected <<" but only read "<< bytes_read << " bytes.\n";
		cerr << "Error: Last 1-byte code read was '" << rc << "'.\n'";
		abort();
	}

	// We've read the exact number of bytes that we were told to expect, we
	// now expect to see the End of Data line.  If we don't read an EOD line,
	// we clean up and return an error.
	{
		int tmp_bytes_read;
		if ((rc = dbcnxn.read_response( tmp_bytes_read, buf, sizeof(buf) )) != 'C')
		{
			Error *error = new Error(rc, buf);
			delete[] strings;
			return( error );
		}
	}
	

	as_nums = strings;

	return( (Error *) NULL);
}

ASMacroMap::ASMacroMap( SymTab& dflt ) : STNameSymTabAVLMap( dflt )
{
// This space intentionally left blank.
}

void ASMacroMap::dump( void )
{
	Pix p, q;
	char *key;
	SymTab contents;
	ASMacroMap &as_symtbl=*this;

	for( p = as_symtbl.first(); p; as_symtbl.next(p) ) {
		key = as_symtbl.key(p);	
		contents = as_symtbl.contents(p);
		
		cout << key << " " << contents.evaluated << endl;

		for( q = contents.value.first(); q; contents.value.next(q) )
			cout << "  AS" << contents.value(q) << endl;
	}
}


void ASMacroMap::expand( DBCnxn *dbptr )
{
	ASMacroMap &symtbl = *this;    
	ASMap &asmap = *ASST;
	SymTab contents;
	Pix p,r,s;
	int i;
	char *key, *asnum, *array, not_buf[30];
	Error *error;

	for( p = symtbl.first(); p; symtbl.next(p) ) {
		contents = symtbl.contents(p);
		// Check the evaluated field for this AS Macro to see if we've expanded
		// it sometime in the past.  If so, don't waste time expanding it 
		// again.  If contents.evaluated==0, we have never expanded this 
		// particular entry.

		if ( !contents.evaluated ) {
			key = symtbl.key(p);	
			error = expand_as_macro( *dbptr, key, array );

			if ( error )  {
				cerr << "Warning: Unable to expand macro: " << key << endl;
				delete error;
			}

			else {
				symtbl[key].evaluated = 1;

				// Add newly discovered AS Numbers to the set.
				// Make entries for newly discovered AS numbers in the ASMap.
				asnum = strtok( array, " " );
				while ( asnum ) {

					if ( !(r = asmap.seek( asnum )) ) {
						(void) asmap[ strdup( asnum ) ];
						r = asmap.seek( asnum );
					}

					sprintf( not_buf, "Not %s", asnum );
					if ( !(s = asmap.seek( not_buf )) ) {
						(void) asmap[ strdup(not_buf) ];
						s = asmap.seek( not_buf );
					}

					asmap.contents(r).not = s;
 					asmap.contents(s).not = r;
					asmap.contents(s).evaluated = 2;

					symtbl[key].value.add( (int) r );

					asnum = strtok( (char *) NULL, " " );
				}

				delete[] array;
			}

		}
	}
}
