// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#include <iostream.h>
#include "ASMap.h"

extern Error *get_routes_by_origin(DBCnxn&, const char*, char**&);

ASMap::ASMap( PrefaskAVLSet *pfsk_tbl, SymTab& dflt ) : STNameSymTabAVLMap( dflt )
{
	prefask_symtbl = pfsk_tbl;
}

void ASMap::dump( void )
{
	Pix p, q, prefask_pix;
	char *key;
	SymTab contents;
	PrefaskAVLSet &lprefask_symtbl = *prefask_symtbl;
	ASMap &as_symtbl=*this;

	for( p = as_symtbl.first(); p; as_symtbl.next(p) ) {
		key = as_symtbl.key(p);	
		contents = as_symtbl.contents(p);
		
		cout << key << " " << contents.evaluated << endl;

		for( q = contents.value.first(); q; contents.value.next(q) ) {
			prefask_pix = (Pix) contents.value(q);
			cout << "    " << lprefask_symtbl( prefask_pix ) << endl;
		}
	}
}


void ASMap::expand( DBCnxn *dbptr )
{
	ASMap &symtbl = *this;    
	PrefaskAVLSet &prfsk_symtbl = *prefask_symtbl;
	SymTab contents;
	Pix p, prefask_pix;
	int i;
	char **array, *key;
	Error *error;

	for( p = symtbl.first(); p; symtbl.next(p) ) {
		contents = symtbl.contents(p);
		// Check the evaluated field for this AS to see if we've expanded
		// it sometime in the past.  If so, don't waste time expanding it 
		// again. A contents.evaluated value of 0 says that we've never
		// expanded this entry.

		if ( !contents.evaluated ) { 

			key = symtbl.key(p);	
	
			error = get_routes_by_origin( *dbptr, strstr(key, "AS")+2, array );

			if ( error )  {
				cerr << "Warning: Unable to expand " << key << endl;
				delete error;
			}

			else {
				symtbl[key].evaluated = 1;
				for( i = 0; array[i]; i++ ) {
	
					if ( !( prefask_pix = prfsk_symtbl.seek( array[i] ) ) )
						prefask_pix = prfsk_symtbl.add( strdup( array[i] ) );
	
						symtbl[key].value.add( (int) prefask_pix );
				}
	
				delete[] array[0];
				delete[] array;
			}
		}
	}
}
