// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _ASNumSymTabAVLMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _ASNumSymTabAVLMap_h 1

#include "ASNum.SymTab.Map.h"

struct ASNumSymTabAVLNode
{
  ASNumSymTabAVLNode*      lt;
  ASNumSymTabAVLNode*      rt;
  ASNum                 item;
  SymTab                 cont;
  char                stat;
                      ASNumSymTabAVLNode(ASNum  h, SymTab& c, 
                                    ASNumSymTabAVLNode* l=0, ASNumSymTabAVLNode* r=0);
                      ~ASNumSymTabAVLNode();
};

inline ASNumSymTabAVLNode::ASNumSymTabAVLNode(ASNum  h, SymTab& c, 
                                    ASNumSymTabAVLNode* l, ASNumSymTabAVLNode* r)
     :item(h), cont(c), lt(l), rt(r), stat(0) {}

inline ASNumSymTabAVLNode::~ASNumSymTabAVLNode() { delete[] item; }

typedef ASNumSymTabAVLNode* ASNumSymTabAVLNodePtr;


class ASNumSymTabAVLMap : public ASNumSymTabMap
{
protected:
  ASNumSymTabAVLNode*   root;

  ASNumSymTabAVLNode*   leftmost();
  ASNumSymTabAVLNode*   rightmost();
  ASNumSymTabAVLNode*   pred(ASNumSymTabAVLNode* t);
  ASNumSymTabAVLNode*   succ(ASNumSymTabAVLNode* t);
  void            _kill(ASNumSymTabAVLNode* t);
  void            _add(ASNumSymTabAVLNode*& t);
  void            _del(ASNumSymTabAVLNode* p, ASNumSymTabAVLNode*& t);

public:
                ASNumSymTabAVLMap(SymTab& dflt);
                ASNumSymTabAVLMap(ASNumSymTabAVLMap& a);
                ~ASNumSymTabAVLMap();

  SymTab&          operator [] (ASNum  key);

  void          del(ASNum  key);

  Pix           first();
  void          next(Pix& i);
  ASNum&          key(Pix i);
  SymTab&          contents(Pix i);

  Pix           seek(ASNum  key);
  int           contains(ASNum  key);

  void          clear(); 

  Pix           last();
  void          prev(Pix& i);

  int           OK();
};

inline ASNumSymTabAVLMap::~ASNumSymTabAVLMap()
{
  _kill(root);
}

inline ASNumSymTabAVLMap::ASNumSymTabAVLMap(SymTab& dflt) :ASNumSymTabMap(dflt)
{
  root = 0;
}

inline Pix ASNumSymTabAVLMap::first()
{
  return Pix(leftmost());
}

inline Pix ASNumSymTabAVLMap::last()
{
  return Pix(rightmost());
}

inline void ASNumSymTabAVLMap::next(Pix& i)
{
  if (i != 0) i = Pix(succ((ASNumSymTabAVLNode*)i));
}

inline void ASNumSymTabAVLMap::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((ASNumSymTabAVLNode*)i));
}

inline ASNum& ASNumSymTabAVLMap::key(Pix i)
{
  if (i == 0) error("null Pix");
  return ((ASNumSymTabAVLNode*)i)->item;
}

inline SymTab& ASNumSymTabAVLMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return ((ASNumSymTabAVLNode*)i)->cont;
}

inline void ASNumSymTabAVLMap::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int ASNumSymTabAVLMap::contains(ASNum  key)
{
  return seek(key) != 0;
}

#endif
