/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#ifndef _DBCNXN_H
#define _DBCNXN_H

#include <iostream.h>
#include <memory.h>
#include <stdio.h>
#include <string.h>
#include "Error.h"

// The Database Connection Object
// Handles connection management, reading from and writing to a connection.

class DBCnxn
{
	private:
        /* Flag value definitions. */
        const unsigned int CSTATE = 0x1; // Connection State 1=Opened 0=Closed


		char          *dbname;
		char           localbuf[1024];
		char          *server;
		unsigned int   port;
		unsigned int   flags;
		FILE          *r_fileptr;
		FILE          *w_fileptr;

		/* methods to set the flags */
		void set_connection_state_flag(void) { flags |= CSTATE; }
		void reset_connection_state_flag(void) { flags &= ~CSTATE;}

		/* methods to view the flags */
		inline int is_connection_open(void) {return( CSTATE & flags );}

	public:
		DBCnxn(void);
		~DBCnxn(void);
		void open(char *server_name = "toad.merit.edu", int port_num = 43);
		int close(void);

		char read_response(int &bytes_read,
		                   char *inbuf,
		                   unsigned int buf_size);
		char readn_response(int  &bytes_read, 
		                    char *&inbuf, 
		                    unsigned int bytes_expected );
		int write_query(const char *query_string);
		Error *SelectDatabase( const char* );
};

#endif
