// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#include <iostream.h>
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
}
#include "Node.h"

Node::Node( void )
{
	num_child = 0;
	increment_size = 5;
	max_children = 0;
	children = (Node **) NULL;
}

Node::~Node( void )
{
	// Delete all children first.
	for(int i = 0; i < num_child; i++)
		delete children[i];

	delete[] children;
}

static Node **new_stroller( Node **old_stroller, int old_size, int new_size )
{
    Node **new_s;

	if ( old_size > new_size ) {
		cerr << "Error:" << __FILE__ << "(" << __LINE__ << ") old_size > new_size\n";
		abort();
	}

	new_s = new Node*[ sizeof(Node*) * (new_size + 1)];

	int i;
	for(i = 0; i < old_size; i++)
		new_s[i] = old_stroller[i];

	for(; i <= new_size; i++)
		new_s[i] = (Node *) NULL;

	delete[] old_stroller;

	return( new_s );
}

void Node::AddChildren( Node *one, ...)
{
    int     i,
            num_new_kids = 0,
            num_old_kids = 0,
            new_family_size,
            new_array_size;
    va_list ap;
    Node    *child,
            **stroller;

	if ( one == NULL )    // Make it idiot-proof.
		return;

	va_start(ap, one);
	num_new_kids++;

	for( child = va_arg(ap, Node*); child; child = va_arg(ap, Node*) )
		num_new_kids++;

	va_end(ap);


	num_old_kids = num_child;
	new_family_size = num_old_kids + num_new_kids;

	if ( new_family_size > max_children ) {
		new_array_size = max_children + increment_size;

		if ( num_old_kids )
			children =  new_stroller( children,  max_children, new_array_size );

		else
			children = new Node*[ sizeof(Node*) * ( new_array_size + 1) ];

		max_children = new_array_size;
	}


	// Now, actually add the children

	va_start(ap, one);

	children[num_old_kids] = one;

	for(i = num_old_kids+1; i < new_family_size; i++)
		children[i] = va_arg(ap, Node*);

	va_end(ap);

	children[new_family_size] = (Node*) NULL;
	num_child = new_family_size;
}

Node *Node::GetChild( int child_no )  // Child_no's start at 0.
{
	Node *ptr;

	if ( child_no >= num_child || num_child == 0 )
		ptr = (Node*) NULL;

	else
		ptr = children[ child_no ];

	return( ptr );
}


Node *Node::RmChild( int child_no ) // Child_no's start at 0.
{
	Node *ptr;

	if ( child_no >= num_child || num_child == 0 )
		return( NULL );

	ptr = children[ child_no ];

	for(int i = child_no; i < num_child; i++ )
		children[i] = children[i+1];
			
	num_child--;

	return( ptr );
}

// It would be better to modifiy walk_tree_in_order() to only optionally fill
// in an array.  That way cannonical_print() could call walk_tree_in_order()
// twice.  The first time to figure out how big the resulting string will be,
// the second time to hand in a newly allocated chunk of memeory of the 
// appropriate size. -ala

char *cannonical_print( Node &node )
{
   char buf[1024],
        *ptr;
   int  pos;

	pos = 0;

	node.SInOrderPrint( buf, pos );
	ptr = strdup( buf );
	return( ptr );
}
