// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#ifndef _NODE_H
#define _NODE_H

extern "C" {
#include <stdarg.h>
}

#include <iostream.h>

#include "peval.hh"
#include "NE.hh"

#define netlist_type     500
#define policy_type      501
#define and_type         503
#define not_type         505
#define metric_type      506
#define policyline_type  507
#define dbsel_type       508
#define or_type          509
#define asmacro_type     510
#define comm_type        511
#define any_type         512
#define as_type          513
#define aspath_type      514


#define FROM_TOK    258
#define ACCEPT_TOK  259
#define PRFMSK_TOK  260
#define NUM_TOK     262
#define DBSEL_TOK   263
#define ASNUM_TOK   264
#define ASMACRO_TOK 265
#define CNAME_TOK   266
#define ERR_TOK     267
#define ANY_TOK     268
#define OR_TOK      269
#define AND_TOK     270
#define NOT_TOK     271
#define ASPATH_TOK  272

class Node
{
	private:
		int increment_size;
		int max_children;
		int num_child;
		Node **children;
  
	public:
		Node( void );
		virtual ~Node( void );
		virtual void AddChildren( Node*, ... );
		Node *RmChild( int );
		Node *GetChild( int );
		int NumChildren( void ) { return( num_child ); }
		virtual int Type( void ) = 0;
		virtual void InOrderPrint( void ) = 0;
		virtual void SInOrderPrint( char*, int& ) = 0; /* Print to a char buf. */
		virtual void PostOrderPrint( void ) = 0;

		virtual NormalExpression *Evaluate(int expand) = 0;
};

#endif
