// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#include <iostream.h>
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
}
#include "NodeNetList.h"
#include "NodePRFMSK.h"

void NetListNode::SInOrderPrint( char *buf, int &pos )
{
	Node *ptr;
	int   i;

	sprintf(&buf[pos], "{ ");
	pos += strlen("{ ");

	for( i = 0; ptr = GetChild(i); i++) {
		ptr->SInOrderPrint( buf, pos );
		sprintf(&buf[pos],", ");
		pos += strlen(&buf[pos]);
	}

	pos = pos - 2;
	sprintf(&buf[pos], "}");
	pos += strlen(&buf[pos]);
}

void NetListNode::InOrderPrint( void )
{
	Node *ptr;
	int  i;

	cout << "{ ";

	GetChild( 0 )->InOrderPrint();

	for( i = 1; ptr = GetChild(i); i++) {
		cout << ", "; 
		ptr->InOrderPrint();
	}

	cout << " }";
}

void NetListNode::PostOrderPrint( void )
{
	int i;
	Node *ptr;

	cout << "{ ";

	ptr = GetChild( 0 );
	ptr->PostOrderPrint();

	for( i = 1; ptr = GetChild( i ); i++) {
		cout << ", "; 
		ptr->PostOrderPrint();
	}

	cout << " }";
}

NormalExpression *NetListNode::Evaluate(int expand) {
   NormalExpression *ne = new NormalExpression;
   NormalTerm *nt = new NormalTerm;
   PRFMSKNode *ptr;

   nt->make_universal(PRFX);       // this makes it universal
 
   for(int i = 0; ptr = (PRFMSKNode *) GetChild(i); i++) 
      nt->prfx_set.add((int) ptr->val);

   *ne += nt;
   return ne;
}
