// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#include <iostream.h>
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
}
#include "NodeOR.h"

void ORNode::SInOrderPrint( char *buf, int &pos )
{
    int i;
		Node *ptr;

		/* Go left, print then right */
		for( i = 0; ptr = GetChild(i); i++) {
			ptr->SInOrderPrint( buf, pos );
			sprintf(&buf[pos], "OR ");
			pos += strlen(&buf[pos]);
		}

	pos = pos - strlen( "OR" ) - 1;  // Backup len of "OR" and trailing 'space'.
	buf[pos] = '\0';
}

void ORNode::InOrderPrint( void )
{
    int i;
		Node *ptr;

	/* Go left, print then right */
	ptr = GetChild( 0 );
	ptr->InOrderPrint();

	for( i = 1; ptr = GetChild(i); i++) {
		cout << "OR ";
		ptr->InOrderPrint();
	}
}

void ORNode::PostOrderPrint( void )
{
	Node *ptr;
	int i;

	cout << "( ";

	for( i = 0; ptr = GetChild( i ); i++ )
		ptr->PostOrderPrint();

	cout << ") OR ";
}

// OR nodes may only have 2 children... And they must both be added at the
// same time.

void ORNode::AddChildren( Node *one, ... )
{
	va_list ap;
	Node    *two;
	int      num_new_kids = 0;
	
	if ( one == NULL ) {
		cerr << "Error:" << __FILE__ << "(" << __LINE__ <<"): An OR node must have exactly ";
		cerr << "2 children." << endl;
		abort();
	}

	va_start( ap, one );
	num_new_kids++;

	for( two = va_arg(ap, Node*); two; two = va_arg(ap, Node*) )
		num_new_kids++;

	va_end( ap );

	if ( num_new_kids != 2 ) {
		cerr << "Error:" << __FILE__ << "(" << __LINE__ <<"): An OR node must have exactly ";
		cerr << "2 children." << endl;
		abort();
	}

	va_start( ap, one );
	two = va_arg(ap, Node*);

	Node::AddChildren( one, two, NULL );

	return;
}


NormalExpression *ORNode::Evaluate(int expand) {
   NormalExpression *ne  = GetChild( 0 )->Evaluate(expand);
   NormalExpression *ne2 = GetChild( 1 )->Evaluate(expand);

   ne->do_or(*ne2);

   delete ne2;

   return ne;
}
