// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _PrefaskAVL_h
#ifdef __GNUG__
#pragma interface
#endif
#define _PrefaskAVL_h 1

#include "Prefask.Set.h"

struct PrefaskAVLNode
{
  PrefaskAVLNode*         lt;
  PrefaskAVLNode*         rt;
  Prefask                 item;
  char                stat;
                      PrefaskAVLNode(Prefask  h, PrefaskAVLNode* l=0, PrefaskAVLNode* r=0);
                      ~PrefaskAVLNode();
};

inline PrefaskAVLNode::PrefaskAVLNode(Prefask  h, PrefaskAVLNode* l, PrefaskAVLNode* r)
:item(h), lt(l), rt(r), stat(0) {}

inline PrefaskAVLNode::~PrefaskAVLNode() {}

typedef PrefaskAVLNode* PrefaskAVLNodePtr;


class PrefaskAVLSet : public PrefaskSet
{
protected:
  PrefaskAVLNode*   root;

                PrefaskAVLSet(PrefaskAVLNode* p, int l);

  PrefaskAVLNode*   leftmost();
  PrefaskAVLNode*   rightmost();
  PrefaskAVLNode*   pred(PrefaskAVLNode* t);
  PrefaskAVLNode*   succ(PrefaskAVLNode* t);
  void          _kill(PrefaskAVLNode* t);
  void          _add(PrefaskAVLNode*& t);
  void          _del(PrefaskAVLNode* p, PrefaskAVLNode*& t);

public:
  void                  dump();  // Andy added this.
                PrefaskAVLSet();
                PrefaskAVLSet(PrefaskAVLSet& a);
                ~PrefaskAVLSet();

  Pix           add(Prefask  item);
  void          del(Prefask  item);
  int           contains(Prefask  item);

  void          clear();

  Pix           first();
  void          next(Pix& i);
  Prefask&          operator () (Pix i);
  int           owns(Pix i);
  Pix           seek(Prefask  item);

  Pix           last();
  void          prev(Pix& i);

  void          operator |= (PrefaskAVLSet& b);
  void          operator -= (PrefaskAVLSet& b);
  void          operator &= (PrefaskAVLSet& b);

  int           operator == (PrefaskAVLSet& b);
  int           operator != (PrefaskAVLSet& b);
  int           operator <= (PrefaskAVLSet& b); 

  int           OK();
};

inline PrefaskAVLSet::~PrefaskAVLSet()
{
  _kill(root);
}

inline PrefaskAVLSet::PrefaskAVLSet()
{
  root = 0;
  count = 0;
}

inline PrefaskAVLSet::PrefaskAVLSet(PrefaskAVLNode* p, int l)
{
  root = p;
  count = l;
}

inline int PrefaskAVLSet::operator != (PrefaskAVLSet& b)
{
  return ! ((*this) == b);
}

inline Pix PrefaskAVLSet::first()
{
  return Pix(leftmost());
}

inline Pix PrefaskAVLSet::last()
{
  return Pix(rightmost());
}

inline void PrefaskAVLSet::next(Pix& i)
{
  if (i != 0) i = Pix(succ((PrefaskAVLNode*)i));
}

inline void PrefaskAVLSet::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((PrefaskAVLNode*)i));
}

inline Prefask& PrefaskAVLSet::operator () (Pix i)
{
  if (i == 0) error("null Pix");
  return ((PrefaskAVLNode*)i)->item;
}

inline void PrefaskAVLSet::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int PrefaskAVLSet::contains(Prefask  key)
{
  return seek(key) != 0;
}

#endif
