// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _SymTabSTNameAVLMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _SymTabSTNameAVLMap_h 1

#include "SymTab.STName.Map.h"

struct SymTabSTNameAVLNode
{
  SymTabSTNameAVLNode*      lt;
  SymTabSTNameAVLNode*      rt;
  SymTab                 item;
  STName                 cont;
  char                stat;
                      SymTabSTNameAVLNode(SymTab& h, STName  c, 
                                    SymTabSTNameAVLNode* l=0, SymTabSTNameAVLNode* r=0);
                      ~SymTabSTNameAVLNode();
};

inline SymTabSTNameAVLNode::SymTabSTNameAVLNode(SymTab& h, STName  c, 
                                    SymTabSTNameAVLNode* l, SymTabSTNameAVLNode* r)
     :item(h), cont(c), lt(l), rt(r), stat(0) {}

inline SymTabSTNameAVLNode::~SymTabSTNameAVLNode() {}

typedef SymTabSTNameAVLNode* SymTabSTNameAVLNodePtr;


class SymTabSTNameAVLMap : public SymTabSTNameMap
{
protected:
  SymTabSTNameAVLNode*   root;

  SymTabSTNameAVLNode*   leftmost();
  SymTabSTNameAVLNode*   rightmost();
  SymTabSTNameAVLNode*   pred(SymTabSTNameAVLNode* t);
  SymTabSTNameAVLNode*   succ(SymTabSTNameAVLNode* t);
  void            _kill(SymTabSTNameAVLNode* t);
  void            _add(SymTabSTNameAVLNode*& t);
  void            _del(SymTabSTNameAVLNode* p, SymTabSTNameAVLNode*& t);

public:
                SymTabSTNameAVLMap(STName  dflt);
                SymTabSTNameAVLMap(SymTabSTNameAVLMap& a);
                ~SymTabSTNameAVLMap();

  STName&          operator [] (SymTab& key);

  void          del(SymTab& key);

  Pix           first();
  void          next(Pix& i);
  SymTab&          key(Pix i);
  STName&          contents(Pix i);

  Pix           seek(SymTab& key);
  int           contains(SymTab& key);

  void          clear(); 

  Pix           last();
  void          prev(Pix& i);

  int           OK();
};

inline SymTabSTNameAVLMap::~SymTabSTNameAVLMap()
{
  _kill(root);
}

inline SymTabSTNameAVLMap::SymTabSTNameAVLMap(STName  dflt) :SymTabSTNameMap(dflt)
{
  root = 0;
}

inline Pix SymTabSTNameAVLMap::first()
{
  return Pix(leftmost());
}

inline Pix SymTabSTNameAVLMap::last()
{
  return Pix(rightmost());
}

inline void SymTabSTNameAVLMap::next(Pix& i)
{
  if (i != 0) i = Pix(succ((SymTabSTNameAVLNode*)i));
}

inline void SymTabSTNameAVLMap::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((SymTabSTNameAVLNode*)i));
}

inline SymTab& SymTabSTNameAVLMap::key(Pix i)
{
  if (i == 0) error("null Pix");
  return ((SymTabSTNameAVLNode*)i)->item;
}

inline STName& SymTabSTNameAVLMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return ((SymTabSTNameAVLNode*)i)->cont;
}

inline void SymTabSTNameAVLMap::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int SymTabSTNameAVLMap::contains(SymTab& key)
{
  return seek(key) != 0;
}

#endif
