#include "SymTab.h"
#include <builtin.h>
// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _SymTabdefs_h
#define _SymTabdefs_h 1


// equality operator
#ifndef SymTabEQ
#define SymTabEQ(a, b)  ((a.value) == (b.value))
#endif

// less-than-or-equal
#ifndef SymTabLE
#define SymTabLE(a, b)  ((a.value) <= (b.value))
#endif

// comparison : less-than -> < 0; equal -> 0; greater-than -> > 0
#ifndef SymTabCMP
#define SymTabCMP(a, b) ( ((a.value) <= (b.value))? (((a.value) == (b.value))? 0 : -1) : 1 )
#endif

// hash function
#ifndef SymTabHASH
extern unsigned int multiplicativehash(SymTab&);
#define SymTabHASH(x)  multiplicativehash((int) x.value)
#endif

// initial capacity for structures requiring one

#ifndef DEFAULT_INITIAL_CAPACITY
#define DEFAULT_INITIAL_CAPACITY 100
#endif


#endif
