/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

#include <iostream.h>
extern "C" {
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <memory.h>
#include <string.h>
extern int socket(int, int, int);
//extern struct hostent *gethostbyname(char*);
extern struct hostent *gethostbyname __P((const char *));
extern int connect(int, struct sockaddr_in*, int);
}

#include "DBCnxn.h"
#include "trace.hh"



/* The default DBCnxn constructor. */
DBCnxn::DBCnxn(void)
{
	flags = 0;
	dbname = strdup( "default" );
}

DBCnxn::~DBCnxn(void)
{

	/* If the connection is still open, close it. */
	delete[] dbname;
	delete[] server;
	if ( is_connection_open() )
		(void) close();
}

void DBCnxn::open(char *server_name, int port_num)
{
    struct sockaddr_in server_sockaddr;
    struct hostent *hp;
    int sock,
        rc;      // Return Code

	Trace(TR_DBCXN_QUERY) << "DBCnxn: Open" << endl;

	int len = strlen( server_name );
	server = new char[ len + 1 ];
	strcpy( server, server_name );
	port   = port_num;

	hp = gethostbyname(server_name);
	if (!hp) {
		cerr << "Error:" << __FILE__ << "(" << __LINE__ << ") Can't gethostbyname.\n";
		abort();
	}

	server_sockaddr.sin_family = AF_INET;
	memcpy(&(server_sockaddr.sin_addr.s_addr), hp->h_addr, hp->h_length);
	server_sockaddr.sin_port = htons(port);

	sock = socket( AF_INET, SOCK_STREAM, 0 );

	if (sock < 0) {
		cerr << "Error:" << __FILE__ << "(" << __LINE__ << ") Can't open socket.\n";
		abort();
	}

	if ( connect(sock, &server_sockaddr, sizeof(server_sockaddr)) < 0) {
		perror("connect()");

		// ::close(sock);

		abort();
	}

	r_fileptr = fdopen(sock, "r");
	w_fileptr = fdopen(sock, "w");
	set_connection_state_flag();

	(void) write_query("!!");  // Tell server that we're in multi-query mode,
                             // and not one-shot command mode.
/*
	fdclose(sock);
*/    

}

int DBCnxn::close(void)
{
    Trace(TR_DBCXN_QUERY) << "DBCnxn: Close" << endl;

	(void) write_query("q");  // Tell server that we're quitting.
	reset_connection_state_flag();
	fclose(r_fileptr);
	fclose(w_fileptr);


	return(0);
}

Error *DBCnxn::SelectDatabase( const char *dbname )
{
	int bytes_read;
	char rc;
	Error *err = (Error*) NULL;

	Trace(TR_DBCXN_QUERY) << "DBCnxn: SelectDatabase(" << dbname << ")" << endl;

	sprintf( localbuf, "s%s", dbname );
	write_query( localbuf );
	rc = read_response( bytes_read, localbuf, sizeof( localbuf ) );

/*
	if ( rc !=  )
		err = new Error( x, localbuf );
*/
	return( err );
}

int DBCnxn::write_query(const char *query_string)
{
    int bytes_xmited;

	Trace(TR_DBCXN_QUERY) << "DBCnxn: Query(" << query_string << ")" << endl;

	bytes_xmited = fprintf(w_fileptr, "%s\n", query_string);
	fflush(w_fileptr);

#ifdef never
	cout << "wrote : " << bytes_xmited << "bytes \n";
	cout << "wrote string : '" << query_string << "'\n";
#endif

	return(bytes_xmited);
}

char DBCnxn::read_response(int  &bytes_read, 
                           char *inbuf, 
                           unsigned int buf_size )
{ 
	char rtn_code_buf[10];	

	// First read the 1-byte return code, then read the data.

	memset( (void*) rtn_code_buf, (int) 0, sizeof(rtn_code_buf) );

	(void) fgets( rtn_code_buf, 2, r_fileptr );
	(void) fgets( inbuf, buf_size, r_fileptr ); 

#ifdef never
	cout << "Read :'" << inbuf << "'\n";
	cout << "Read " << strlen(inbuf) << " bytes.\n";
#endif

	Trace(TR_DBCXN_REPLY) << "DBCnxn: Reply(" << inbuf << ")" << endl;

	*strchr(inbuf, (int) '\n') = '\0';    // Overwrite \n with \0.

	bytes_read = strlen(inbuf);

	return( rtn_code_buf[0] );
}

// The strings array below is sized to be 2 bytes larger than bytes_expected
// in order to accomodate the way fgets() works (down in read_response())
// and to accomodate the 1-byte char code that begins each new line.
// read_response() uses fgets(char *inbuf, int count, FILE *fileptr) to read 
// in lines and it stops reading when either a newline has been read, or 
// 'count-1' bytes have been read. It only reads count-1 bytes because it
// terminates every string it reads with a null, \0. 
// Note that if fgets() reads a newline, it does not throw it away.  
//
// The 'while' loop below reads each new line
// into the next available position in the strings array, and decrements
// the bytes_left by the number of bytes just read.  After fgets() places the
// string in the buffer, read_response() over-writes the leading 1-byte
// command code by shifting the entire string left 1 byte.  read_response()
// also kills the newline by overwriting it with a \0.  When it comes time
// to read the last data line, we need enough free bytes in the strings 
// array to hold the 1-byte command code and the \0 that fgets() always
// adds, even though read_response() will eat these two bytes anyway.
// Therefore, the strings array must be 2 bytes larger than bytes_expected.

char DBCnxn::readn_response(int  &bytes_read, 
                            char *&inbuf, 
                            unsigned int bytes_expected )
{ 
	char rtn_code_buf[10],
	     *old_ptr,
	     *ptr;

	bytes_read = 0;
	inbuf = new char[ bytes_expected + 1 ];
	ptr = inbuf;
	memset( (void*) rtn_code_buf, (int) 0, sizeof(rtn_code_buf) );

	while ( bytes_read < bytes_expected ) {

		(void) fgets(rtn_code_buf, 2, r_fileptr);  // Read the command code byte.
		bytes_read++; // Count the command code byte.

		if ( rtn_code_buf[0] != 'B' )
			return( rtn_code_buf[0] );

		(void) fgets(ptr, inbuf + bytes_expected - ptr + 1 , r_fileptr); 
#ifdef never
	cout << "Read :'" << ptr << "'\n";
	cout << "Read " << strlen(ptr)+1 << " bytes.\n";
#endif
		Trace(TR_DBCXN_REPLY) << "DBCnxn: Reply(" << inbuf << ")" << endl;

		for(old_ptr = ptr; *ptr; ptr++ )
			if ( *ptr == '\n' )
				*ptr = '\0';

		bytes_read = bytes_read + ptr - old_ptr;
	}

	return( rtn_code_buf[0] );
}
