/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

extern "C" {
#include <stdlib.h>
#include <memory.h>
#include <string.h>
}

#include "DBCnxn.h"

Error *get_routes_by_origin(DBCnxn &dbcnxn, const char *asnum, char **&routes)
{
    char rc,
         buf[100],
         *strings;              // Array of route strings.
    int  bytes_read,
         bytes_expected,       // Total num of bytes we expect to read.
         num_routes;           // Number of routes read.

	sprintf(buf,"gas%s\n", asnum);
	(void) dbcnxn.write_query(buf); // Write query. Throw away return code.

	// Read the first line to determine how much mem to malloc.
	rc = dbcnxn.read_response( bytes_read, buf, sizeof(buf) );

	if ( rc != 'A' ) {                  // Verify that we did in fact read the
		routes = NULL;                  // line type we expected to read.
		return( new Error(rc, buf) );
	}

	bytes_expected = atoi( buf );

	rc = dbcnxn.readn_response( bytes_read, strings, bytes_expected );

	if ( rc != 'B' ) {
		cerr << "Error:" << __FILE__<< "(" <<__LINE__<<") Expected to read ";
		cerr << bytes_expected <<" but only read "<< bytes_read << " bytes.\n";
		cerr << "Error:Last 1-byte code read was '" << rc << "'.\n'";
		abort();
	}

	// Have read the exact number of bytes that we were told to expect, we
	// now expect to see the End of Data line.  If we don't read an EOD line,
	// we clean up and return an error.
	{
		int tmp_bytes_read;
		if ((rc = dbcnxn.read_response( tmp_bytes_read, buf, sizeof(buf) )) != 'C')
		{
			Error *error = new Error(rc, buf);
			delete[] strings;
			return( error );
		}
	}
	
	// If we got here, then we read an End Of Data line, just as expected.
	// Count the number of routes (routes are separated by spaces), plant
	// \0's between each one and fill out the routes array.

	char *ptr;
	for( ptr = strings, num_routes = 0; ptr = strchr(ptr, (int) ' '); num_routes++)
	{
		*ptr = '\0';
		ptr++;	
	}

//	cout << "numroutes = " << num_routes << "\n";
	routes = new char*[num_routes + 1]; 
	memset( (void*) routes, (int) 0, sizeof(char*) * (num_routes + 1));

	routes[0] = strings;

	for( int j = 1; j < num_routes; j++ )
		routes[j] = strchr( routes[j-1], (int) '\0' ) + 1;

	return( (Error *) NULL);
}
