/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

extern "C" {
#include <string.h>
}
#include <std.h>
#include <iostream.h>
#include "polparse.h"

extern void x_get_as_in_lines( void );
extern void x_get_routes_by_origin( void );
extern void x_get_routes_by_comm( void );
extern void x_routes_by_comm( void );
extern void x_expand_as_macro( void );
extern void x_get_short_policy( void );
extern void x_get_expanded_policy( void );
extern void x_get_short_policy_trees( void );
extern void x_get_expanded_policy_trees( void );
extern void x_select_db( void );
extern void list_commands( void );

static DBCnxn dbcnxn;

typedef struct _Cmd {
    char *cmd_name;
    void (*fn)();
    char *help;
} Cmd;

static Cmd CmdArray[] = {
"as in lines",      x_get_as_in_lines,           NULL,
"routes by origin", x_get_routes_by_origin,      NULL,
"routes by comm",   x_get_routes_by_comm,        NULL,
"expand as macro",  x_expand_as_macro,           NULL,
"short policy",     x_get_short_policy,    "Get policy with unexpanded AS & community names",
"long policy",      x_get_expanded_policy, "Get policy with expanded AS & community names",
"short tree",       x_get_short_policy_trees,    NULL,
"long tree",        x_get_expanded_policy_trees, NULL,
"list",             list_commands,         "This list of commands",
"help",             list_commands,         "This list of commands",
"db",               x_select_db,           "Select databases",
NULL,               NULL,                        NULL
};

void list_commands( void )
{
    int i;

	for( i = 0; CmdArray[i].cmd_name; i++) {
		cout << CmdArray[i].cmd_name;

		if ( CmdArray[i].help )
			cout << "\t" << CmdArray[i].help;

		cout << "\n";
	}
}

void x_select_db( void )
{
	char buf[100];
	Error *error;

	cout << "Enter database names: ";
	cin.getline(buf, sizeof(buf));

	error = dbcnxn.SelectDatabase( buf );

	if ( error )
		cout << "Error code:" << error->get_code() << " Error msg: " << error->get_msg() << "\n";
}

void x_get_as_in_lines( void )
{
    char buf[100];
    Error *error;

	cout << "Enter AS number : ";
	cin.getline(buf, sizeof(buf));

	cout << "*** Fetching as-in lines ***\n";

	char **as_in_lines;
	error = get_as_in_lines(dbcnxn, buf, as_in_lines);
	if (error)
		cout << "Code: " << error->get_code()<<" Msg:'"<<error->get_msg() <<"'\n";
	else
	{
		for( int i = 0; as_in_lines[i]; i++ )
			cout << as_in_lines[i] << "\n";

		delete[] as_in_lines[0];
		delete[] as_in_lines;
	}
}

void x_get_routes_by_origin( void )
{
    char buf[100];
    Error *error;

	cout << "Enter AS number : ";
	cin.getline(buf, sizeof(buf));

	cout << "*** Fetching routes by origin ***\n";

	char **routes;
	error = get_routes_by_origin( dbcnxn, buf, routes );

	if (error)
		cout << "Code: " << error->get_code()<<" Msg:'"<<error->get_msg() <<"'\n";

	else {
		for( int i = 0; routes[i]; i++ )
			cout << routes[i] << "\n";

		delete[] routes[0];
		delete[] routes;
	}
}

void x_get_routes_by_comm( void )
{
    char buf[100];
    Error *error;

	cout << "Enter Community Name : ";
	cin.getline(buf, sizeof(buf) );

	cout << "*** Fetching Routes by Community Name ***\n";

	char **routes;
	error = get_routes_by_comm(dbcnxn, buf, routes);
	if (error)
		cout << "Code: " << error->get_code()<<" Msg:'"<<error->get_msg() <<"'\n";

	else
	{
		for( int i = 0; routes[i]; i++ )
			cout << routes[i] << "\n";

		delete[] routes[0];
		delete[] routes;
	}
}

void x_expand_as_macro( void )
{
    char buf[100];
    Error *error;

	cout << "Enter AS Macro Name : ";
	cin.getline(buf, sizeof(buf) );

	cout << "*** Expanding AS Macro ***\n";

	char **as_nums;
	error = expand_as_macro(dbcnxn, buf, as_nums);
	if (error)
		cout << "Code: " << error->get_code()<<" Msg:'"<<error->get_msg() <<"'\n";

	else
	{
		for( int i = 0; as_nums[i]; i++)
			cout << as_nums[i] << "\n";

		delete[] as_nums[0];
		delete[] as_nums;
	}
}

void x_get_short_policy( void )
{
    char as1[12], as2[12];
    char **policies;

         

	cout << "Enter accepting AS number (sans 'AS'): ";
	cin.getline( as1, sizeof(as1) );

	cout << "Enter annnouncing AS number (sans 'AS'): ";
	cin.getline( as2, sizeof(as2) );

	policies = get_short_policy( dbcnxn, as1, as2 );

	if ( policies )
	{
		for( int i = 0; policies[i]; i++) {
			cout << policies[i] << "\n";
			delete[] policies[i];
		}

		delete[] policies;
	}
}

void x_get_expanded_policy( void )
{
    char as1[12], as2[12];
         

	cout << "Enter accepting AS number : ";
	cin.getline( as1, sizeof(as1) );

	cout << "Enter annnouncing AS number : ";
	cin.getline( as2, sizeof(as2) );

	char **policies;

	policies = get_expanded_policy( dbcnxn, as1, as2 );

	if ( policies )
	{
		for( int i = 0; policies[i]; i++) {
			cout << policies[i] << "\n";
			delete[] policies[i];
		}

		delete[] policies;
	}
}

void x_get_short_policy_trees( void )
{
    char as1[12], as2[12];
    Node **trees;

         

	cout << "Enter accepting AS number : ";
	cin.getline( as1, sizeof(as1) );

	cout << "Enter annnouncing AS number : ";
	cin.getline( as2, sizeof(as2) );

	trees = get_short_policy_trees( dbcnxn, as1, as2 );

	if ( trees )
	{
		for( int i = 0; trees[i]; i++) {
			trees[i]->InOrderPrint();
			cout << "\n";
			delete trees[i];
		}

		delete[] trees;
	}
}

void x_get_expanded_policy_trees( void )
{
    char as1[12], as2[12];
         

	cout << "Enter accepting AS number : ";
	cin.getline( as1, sizeof(as1) );

	cout << "Enter annnouncing AS number : ";
	cin.getline( as2, sizeof(as2) );

	Node **trees;

	trees = get_expanded_policy_trees( dbcnxn, as1, as2 );

	if ( trees )
	{
		for( int i = 0; trees[i]; i++) {
			trees[i]->InOrderPrint();
			cout << "\n";
			delete trees[i];
		}

		delete[] trees;
	}
}

int main(int argc, char *argv[])
{
    char inbuf[255];

	// Connect to Global Routing Registry. If this fails, we don't return.
	// dbcnxn is a global variable _for_ _this_ _file_ _only_.

	dbcnxn.open( "toad.merit.edu", 43 );
	init_symbol_tables();

	cout << "Enter command : ";
	cin.getline(inbuf, sizeof(inbuf));

	while( strcasecmp(inbuf, "quit") )
	{

		int i;

		for( i = 0; CmdArray[i].cmd_name; i++)
			if ( !strcasecmp( CmdArray[i].cmd_name, inbuf ) )
				break;

		if ( CmdArray[i].cmd_name )
			CmdArray[i].fn();

		else
			cout << "Unknown command: '" << inbuf << "'\n";

		cout << "Enter command : ";
		cin.getline(inbuf, sizeof(inbuf));
	}

	dbcnxn.close(); // Close connection to the routing registry.
}
