
/*  A Bison parser, made from parser.y with Bison version GNU Bison version 1.22
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	FROM_TOK	258
#define	ASPATH_TOK	272
#define	ACCEPT_TOK	259
#define	PRFMSK_TOK	260
#define	NUM_TOK	262
#define	DBSEL_TOK	263
#define	ASNUM_TOK	264
#define	ASMACRO_TOK	265
#define	CNAME_TOK	266
#define	ERR_TOK	267
#define	ANY_TOK	268
#define	OR_TOK	269
#define	AND_TOK	270
#define	NOT_TOK	271

#line 1 "parser.y"

// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

extern "C" {
#include <memory.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
}

#include <std.h>
#include <stdarg.h>
#include "DBCnxn.h"
#include "NodeAS.h"
#include "NodeMetric.h"
#include "NodeNetList.h"
#include "NodeNot.h"
#include "NodeAND.h"
#include "NodeOR.h"
#include "NodePRFMSK.h"
#include "NodePolicyLine.h"
#include "NodeDBSel.h"
#include "NodeANY.h"
#include "NodeComm.h"
#include "NodeASMacro.h"
#include "NodeASPath.h"
#include "typedefs.h"

#define DPRINTF if (debug) printf

ParseErrRec parse_error_rec;

static int debug = 0;
PolicyLineNode   *Big_Root;
DBCnxn *parser_db_ptr;
ASMacroMap *ASMacroST;        /* AS Macro name symbol table */
CommDBSelMap *CommDBSelST;    /* Community Name & DB Selector symbol tbl. */
PrefaskAVLSet *PrefaskST;     /* Prefix/Mask symbol table */
ASMap *ASST;                  /* AS number symbol table */
ASPathMap *ASPathST;          /* AS path symbol table */

static char *new_strdup( char *str );
extern int yyerror(char *);
extern int yylex();
extern char *lex_buf;
extern int lex_pos;
static Pix ASIntoSymTab( char *as );

extern Error *get_routes_by_origin(DBCnxn &, const char*, char **&);
extern Error *expand_as_macro(DBCnxn &, const char*, char **&);

#line 109 "parser.y"
typedef union {
char *val;
Node *node_ptr;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		37
#define	YYFLAG		-32768
#define	YYNTBASE	22

#define YYTRANSLATE(x) ((unsigned)(x) <= 272 ? yytranslate[x] : 28)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    17,
    18,     2,     2,    21,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    19,     2,    20,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     5,     6,
     2,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,     4
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     6,    10,    12,    16,    19,    21,    25,    27,    30,
    34,    36,    38,    40,    42,    44,    48,    50,    52,    54
};

static const short yyrhs[] = {     3,
     9,     7,     5,    23,     0,     9,     7,    23,     0,    23,
     0,    23,    14,    24,     0,    23,    24,     0,    24,     0,
    24,    15,    25,     0,    25,     0,    16,    25,     0,    17,
    23,    18,     0,    26,     0,     9,     0,    10,     0,    11,
     0,    13,     0,    19,    27,    20,     0,     8,     0,     4,
     0,     6,     0,    27,    21,     6,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   137,   155,   173,   191,   202,   211,   216,   227,   231,   241,
   246,   253,   265,   296,   323,   332,   338,   373,   391,   410
};

static const char * const yytname[] = {   "$","error","$illegal.","FROM_TOK",
"ASPATH_TOK","ACCEPT_TOK","PRFMSK_TOK","NUM_TOK","DBSEL_TOK","ASNUM_TOK","ASMACRO_TOK",
"CNAME_TOK","ERR_TOK","ANY_TOK","OR_TOK","AND_TOK","NOT_TOK","'('","')'","'{'",
"'}'","','","policy_line","rpe","rpe_term","rpe_factor","operand","netlist",
""
};
#endif

static const short yyr1[] = {     0,
    22,    22,    22,    23,    23,    23,    24,    24,    25,    25,
    25,    26,    26,    26,    26,    26,    26,    26,    27,    27
};

static const short yyr2[] = {     0,
     5,     3,     1,     3,     2,     1,     3,     1,     2,     3,
     1,     1,     1,     1,     1,     3,     1,     1,     1,     3
};

static const short yydefact[] = {     0,
     0,    18,    17,    12,    13,    14,    15,     0,     0,     0,
     3,     6,     8,    11,     0,     0,    12,     9,     0,    19,
     0,     0,     5,     0,     0,     2,    10,    16,     0,     4,
     7,     0,    20,     1,     0,     0,     0
};

static const short yydefgoto[] = {    35,
    11,    12,    13,    14,    21
};

static const short yypact[] = {    18,
    -8,-32768,-32768,    -1,-32768,-32768,-32768,    62,    62,     1,
    48,    -3,-32768,-32768,     3,    62,-32768,-32768,    32,-32768,
   -16,    62,    -3,    62,     8,    48,-32768,-32768,    10,    -3,
-32768,    62,-32768,    48,    14,    17,-32768
};

static const short yypgoto[] = {-32768,
    -7,   -11,    -5,-32768,-32768
};


#define	YYLAST		81


static const short yytable[] = {    23,
    15,    19,    18,    28,    29,    16,    20,    23,    26,    25,
    30,    24,    32,    36,    23,    33,    37,     0,    31,     0,
     1,     2,    23,     0,    34,     3,     4,     5,     6,     0,
     7,     0,     0,     8,     9,     2,    10,     0,     0,     3,
    17,     5,     6,     0,     7,    22,     0,     8,     9,    27,
    10,     2,     0,     0,     0,     3,    17,     5,     6,     0,
     7,    22,     0,     8,     9,     2,    10,     0,     0,     3,
    17,     5,     6,     0,     7,     0,     0,     8,     9,     0,
    10
};

static const short yycheck[] = {    11,
     9,     9,     8,    20,    21,     7,     6,    19,    16,     7,
    22,    15,     5,     0,    26,     6,     0,    -1,    24,    -1,
     3,     4,    34,    -1,    32,     8,     9,    10,    11,    -1,
    13,    -1,    -1,    16,    17,     4,    19,    -1,    -1,     8,
     9,    10,    11,    -1,    13,    14,    -1,    16,    17,    18,
    19,     4,    -1,    -1,    -1,     8,     9,    10,    11,    -1,
    13,    14,    -1,    16,    17,     4,    19,    -1,    -1,     8,
     9,    10,    11,    -1,    13,    -1,    -1,    16,    17,    -1,
    19
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/nfs/cat1/public//lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 184 "/nfs/cat1/public//lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 138 "parser.y"
{
	ASNode     *as_node;
	MetricNode *metric_node;
	ASMap &symtbl = *ASST;
	Pix p;

	DPRINTF("policy_line := FROM_TOK ASNUM_TOK NUM_TOK ACCEPT_TOK rpe\n");

	p = ASIntoSymTab( yyvsp[-3].val );

	Big_Root    = new PolicyLineNode;
	as_node     = new ASNode( p );
	metric_node = new MetricNode( yyvsp[-2].val );
	Big_Root->AddChildren( as_node, metric_node, yyvsp[0].node_ptr, NULL );
	
	yyval.node_ptr = Big_Root;
;
    break;}
case 2:
#line 156 "parser.y"
{
	ASNode *as_node;
	MetricNode *metric_node;
	ASMap &symtbl = *ASST;
	Pix p;

	DPRINTF("policy_line := ASNUM_TOK NUM_TOK rpe\n");

	p = ASIntoSymTab( yyvsp[-2].val );

	Big_Root    = new PolicyLineNode;
	as_node     = new ASNode( p );
	metric_node = new MetricNode( yyvsp[-1].val );
	
	Big_Root->AddChildren( as_node, metric_node, yyvsp[0].node_ptr, NULL );
	yyval.node_ptr = Big_Root;
;
    break;}
case 3:
#line 174 "parser.y"
{
	ASNode *as_node;
	MetricNode *metric_node;
	Pix p;

	DPRINTF("policy_line := rpe\n");

	p = ASIntoSymTab( new_strdup( "AS1" ) );

	Big_Root    = new PolicyLineNode;
	as_node     = new ASNode( p );
	metric_node = new MetricNode( 0 );
	
	Big_Root->AddChildren( as_node, metric_node, yyvsp[0].node_ptr, NULL );
	yyval.node_ptr = Big_Root;
;
    break;}
case 4:
#line 192 "parser.y"
{

	ORNode *or_ptr;

	DPRINTF("rpt := rpe OR_TOK rpe_term\n");

	or_ptr = new ORNode;
	or_ptr->AddChildren( yyvsp[-2].node_ptr, yyvsp[0].node_ptr, NULL );
	yyval.node_ptr = or_ptr;
;
    break;}
case 5:
#line 203 "parser.y"
{
    ORNode *OR_ptr;

	DPRINTF("rpe := rpe rpe_term\n");
	OR_ptr = new ORNode;
	OR_ptr->AddChildren( yyvsp[-1].node_ptr, yyvsp[0].node_ptr, NULL );
	yyval.node_ptr = OR_ptr;
;
    break;}
case 6:
#line 212 "parser.y"
{
	DPRINTF("rpe := rpe_term\n");
;
    break;}
case 7:
#line 217 "parser.y"
{

	ANDNode *and_ptr;

	DPRINTF("rpt := rpe_term AND_TOK rpe_factor\n");

	and_ptr = new ANDNode;
	and_ptr->AddChildren( yyvsp[-2].node_ptr, yyvsp[0].node_ptr, NULL );
	yyval.node_ptr = and_ptr;
;
    break;}
case 9:
#line 232 "parser.y"
{
    NotNode *op_ptr;

	DPRINTF("rpe := NOT_TOK rpe_factor\n");

	op_ptr = new NotNode;
	op_ptr->AddChildren( yyvsp[0].node_ptr, NULL );
	yyval.node_ptr = op_ptr;
;
    break;}
case 10:
#line 242 "parser.y"
{
	DPRINTF("rpe := ( rpe )\n");
	yyval.node_ptr = yyvsp[-1].node_ptr;
;
    break;}
case 11:
#line 247 "parser.y"
{
	DPRINTF("rpe := operand\n");
 	yyval.node_ptr = yyvsp[0].node_ptr; 
;
    break;}
case 12:
#line 254 "parser.y"
{
	ASMap &symtbl = *ASST;
	Pix p;

	DPRINTF("operand := ASNUM_TOK\n");

	p = ASIntoSymTab( yyvsp[0].val );

	yyval.node_ptr = new ASNode( p );
;
    break;}
case 13:
#line 266 "parser.y"
{
	Node *node_ptr;
	DPRINTF("operand := ASMACRO_TOK\n");

	// Add the macro name to the ASMacroST symbol table.
	ASMacroMap &symtbl = *ASMacroST;
	Pix p, q;
	char not_buf[128];

	if ( !(p = symtbl.seek( yyvsp[0].val )) ) {
		(void) symtbl[ yyvsp[0].val ];
		p = symtbl.seek( yyvsp[0].val );
	}
	else delete[] yyvsp[0].val;

	sprintf(not_buf,"Not %s", symtbl.key( p ) );

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup(not_buf) ];
		q = symtbl.seek( not_buf );
	}

	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;
	node_ptr = new ASMacroNode( p );

	yyval.node_ptr = node_ptr;
;
    break;}
case 14:
#line 297 "parser.y"
{
	Node *node_ptr;
	DPRINTF("operand := CNAME_TOK\n");

	CommDBSelMap &symtbl = *CommDBSelST;
	Pix p,q;
	char not_buf[128];

	(void) symtbl[ yyvsp[0].val ];	

	sprintf(not_buf,"Not %s", yyvsp[0].val);

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup(not_buf) ];
		q = symtbl.seek( not_buf );
	}

	p = symtbl.seek( yyvsp[0].val );
	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;
	node_ptr = new CommNode( p );

	yyval.node_ptr = node_ptr;
;
    break;}
case 15:
#line 324 "parser.y"
{
	ANYNode *any_ptr;
	DPRINTF("operand := ANY_TOK\n");

	any_ptr = new ANYNode;
	yyval.node_ptr = any_ptr;
;
    break;}
case 16:
#line 333 "parser.y"
{ 
	DPRINTF("operand := { netlist }\n");
	yyval.node_ptr = yyvsp[-1].node_ptr; 
;
    break;}
case 17:
#line 339 "parser.y"
{
	CommDBSelMap &symtbl = *CommDBSelST;
	Pix p, q;
	char not_buf[128];

	if ( !(p = symtbl.seek( yyvsp[0].val )) ) {
		(void) symtbl[ yyvsp[0].val ];	
		p = symtbl.seek( yyvsp[0].val );
	}
	else delete[] yyvsp[0].val;

	// The following 'if' stmt is necessary because we don't want to allocate 
	// memory that we never free.  The problem is that the call symtbl[] doesn't 
	// make a copy of the string you hand it.  We don't know apriori if we've
	// installed "Not $1" yet.  And what's worse, the call to symtbl[] doesn't
	// tell you if the string(aka 'key') is already there or not.  If we make
	// a copy of "Not $1" and call symtbl[], we wouldn't know if the string was
	// already in the Map and thus if we should free the string.  The way around
	// this is to seek() for it first, and if not found, strdup and install.
	// 
	// Note that this situation occurs at several other locations in this file.

	sprintf(not_buf,"Not %s", symtbl.key( p ));

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup( not_buf ) ];
		q = symtbl.seek( not_buf );
	}

	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;
	yyval.node_ptr = new DBSelNode( p );
;
    break;}
case 18:
#line 374 "parser.y"
{
	Pix q;
	ASPathMap &path_symtbl = *ASPathST;

	DPRINTF("operand := ASPATH_TOK\n");

	// BIG Question:  What to store in the symbol table for AS paths?
	if ( !(q = path_symtbl.seek( yyvsp[0].val ) ) ) {
		(void) path_symtbl[ yyvsp[0].val ];
		q = path_symtbl.seek( yyvsp[0].val );
	}
	else delete[] yyvsp[0].val;

	yyval.node_ptr = new ASPathNode( q );
;
    break;}
case 19:
#line 392 "parser.y"
{
	PRFMSKNode *prefix_node;
	NetListNode *netlist_node;
	PrefaskAVLSet &symtbl = *PrefaskST;
	Pix p;

	DPRINTF("netlist := PRFMSK_TOK\n");

	if ( !( p = symtbl.seek( yyvsp[0].val ) ) )
		p = symtbl.add( yyvsp[0].val );
	else delete[] yyvsp[0].val;

	prefix_node = new PRFMSKNode( p );

	netlist_node = new NetListNode;
	netlist_node->AddChildren( prefix_node, NULL );
	yyval.node_ptr = netlist_node;
;
    break;}
case 20:
#line 411 "parser.y"
{
	PRFMSKNode *new_node;
	PrefaskAVLSet &symtbl = *PrefaskST;
	Pix p;

	DPRINTF("netlist := netlist ',' PRFMSK_TOK\n");

	if ( !( p = symtbl.seek( yyvsp[0].val )) )
		p = symtbl.add( yyvsp[0].val );
	else delete[] yyvsp[0].val;

	new_node = new PRFMSKNode( p );
	yyvsp[-2].node_ptr->AddChildren( new_node, NULL );
	yyval.node_ptr = yyvsp[-2].node_ptr;
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 465 "/nfs/cat1/public//lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 428 "parser.y"


yyerror(char *s)
{
//	printf("line(%d):'%s'\n", lex_pos, lex_buf);
	parse_error_rec.line = lex_buf;
	parse_error_rec.pos = lex_pos;
	lex_pos = 0;

	return( parse_error_rec.pos );
}

void init_symbol_tables( void )
{
	SymTab dflt;

	PrefaskST   = new PrefaskAVLSet();
	ASMacroST   = new ASMacroMap( dflt );
	CommDBSelST = new CommDBSelMap( PrefaskST, dflt );
	ASST        = new ASMap( PrefaskST, dflt );
	ASPathST    = new ASPathMap( ASST, dflt );
}

void kill_symbol_tables( void )
{
	delete PrefaskST; PrefaskST = NULL;
	delete ASMacroST; ASMacroST = NULL;
	delete CommDBSelST; CommDBSelST = NULL;
	delete ASST; ASST = NULL;
	delete ASPathST; ASPathST = NULL;
}

void print_symbol_tables( void )
{
	cout << "Symbol Table Dump Of AS-MACROs\n";
	ASMacroST->dump();

	cout << "\nSymbol Table Dump Of Communities\n";
	CommDBSelST->dump();

	cout << "\nSymbol Table Dump Of Prefix/Masks\n";
	PrefaskST->dump();   

	cout << "\nSymbol Table Dump Of AS Numbers\n";
	ASST->dump();   

	cout << "\nSymbol Table Dump Of AS Paths\n";
	ASPathST->dump();   
}

void expand_tables( unsigned int flags )
{
	unsigned int unknown = 0;

	if ( flags == ~(unsigned int) 0 ) {
		ASMacroST->expand( parser_db_ptr );
		CommDBSelST->expand( parser_db_ptr );
		ASST->expand( parser_db_ptr );
		return;
	}

	unknown = flags & ~(EXPAND_AS_MACROS|EXPAND_COMMUNITIES|EXPAND_AS);
	if ( unknown ) {
		cerr << "Error: " << __FILE__ << "(" << __LINE__ << ")" << endl;
		cerr << "Error: Unrecognized flag in " << hex << flags << endl;
		cerr << "Error: The unrecognized flags are " << hex << unknown << endl;
		abort();
	}

	if ( flags & EXPAND_AS_MACROS )
			ASMacroST->expand( parser_db_ptr );

	if (flags & EXPAND_COMMUNITIES )
			CommDBSelST->expand( parser_db_ptr );

	if (flags & EXPAND_AS )
			ASST->expand( parser_db_ptr );

}

static void add_routes( _SetOfInt &PRFXset, const char *as_str )
{
	Error *error;
	PrefaskAVLSet &symtbl = *PrefaskST;
	int i;
	Pix prfsk_pix;	
	char **routes;

	error = get_routes_by_origin( *parser_db_ptr, as_str+2, routes );

	if ( !routes )
		cerr << "Warning: Cannot get_routes_by_orgin for " << as_str << endl;

	else {

		for( i = 0; routes[i]; i++ ) {
			if ( !(prfsk_pix = symtbl.seek( routes[i] ) ) )
				prfsk_pix = symtbl.add( new_strdup( routes[i] ) );

			PRFXset.add( (int) prfsk_pix );
		}
		delete[] routes[0];  // Obscure.  Not good code.
		delete[] routes;
	}

	delete error;
}

void AS2AdrPrfx( _SetOfInt &ASSet, _SetOfInt &PRFXset )
{
	PrefaskAVLSet &symtbl = *PrefaskST;
	ASMap &lasmap = *ASST;
	Pix r, p;
	char *as_str;

	for( r = ASSet.first(); r; ASSet.next( r ) ) {
		as_str = lasmap.key( (Pix) ASSet( r ) );

		p = lasmap.seek( as_str ); // Thus must always find as_str.
		if ( lasmap.contents(p).evaluated ) // AS in tbl & evaluated
			PRFXset |= lasmap.contents(p).value;

		else { // AS in tbl but not evaluated
			add_routes( lasmap.contents(p).value, as_str );
			lasmap.contents(p).evaluated = 1;
			PRFXset |= lasmap.contents(p).value;
		}
	}
}

// This routine could be used more throughout the source in this file.
// IE, the only place from where it is currently called is 
// as_macro_expand( char *name ).
static Pix ASIntoSymTab( char *as )
{
	ASMap &symtbl = *ASST;
	Pix p, q;
	char not_buf[128];


	if ( !(p = symtbl.seek( as )) ) {
		(void) symtbl[ as ];
		p = symtbl.seek( as );
	}
	else
		delete[] as;

	sprintf(not_buf,"Not %s", as);

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup( not_buf ) ];
		q = symtbl.seek( not_buf );
	}

	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;

	return( p );
}

// A version of strdup using new.  I'm trying to avoid mixing and matching
// memory allocators.
static char *new_strdup( char *str )
{
	int len = strlen( str );
	char *new_str = new char[ len + 1 ];
	strcpy( new_str, str );

	return( new_str );
}
