%{
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

/*
 *[C] The Regents of the University of Michigan and Merit Network, Inc.1993 
 *All Rights Reserved 
 *  
 *  Permission to use, copy, modify, and distribute this software and its 
 *  documentation for any purpose and without fee is hereby granted, provided 
 *  that the above copyright notice and this permission notice appear in all 
 *  copies of the software and derivative works or modified versions thereof, 
 *  and that both the copyright notice and this permission and disclaimer 
 *  notice appear in supporting documentation. 
 *   
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
 *   EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 *   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE REGENTS OF THE 
 *   UNIVERSITY OF MICHIGAN AND MERIT NETWORK, INC. DO NOT WARRANT THAT THE 
 *   FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR 
 *   THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the 
 *   University of Michigan and Merit Network, Inc. shall not be liable for any 
 *   special, indirect, incidental or consequential damages with respect to any 
 *   claim by Licensee or any third party arising from use of the software. 
 */

extern "C" {
#include <memory.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
}

#include <std.h>
#include <stdarg.h>
#include "DBCnxn.h"
#include "NodeAS.h"
#include "NodeMetric.h"
#include "NodeNetList.h"
#include "NodeNot.h"
#include "NodeAND.h"
#include "NodeOR.h"
#include "NodePRFMSK.h"
#include "NodePolicyLine.h"
#include "NodeDBSel.h"
#include "NodeANY.h"
#include "NodeComm.h"
#include "NodeASMacro.h"
#include "NodeASPath.h"
#include "typedefs.h"

#define DPRINTF if (debug) printf

ParseErrRec parse_error_rec;

static int debug = 0;
PolicyLineNode   *Big_Root;
DBCnxn *parser_db_ptr;
ASMacroMap *ASMacroST;        /* AS Macro name symbol table */
CommDBSelMap *CommDBSelST;    /* Community Name & DB Selector symbol tbl. */
PrefaskAVLSet *PrefaskST;     /* Prefix/Mask symbol table */
ASMap *ASST;                  /* AS number symbol table */
ASPathMap *ASPathST;          /* AS path symbol table */

static char *new_strdup( char *str );
extern int yyerror(char *);
extern int yylex();
extern char *lex_buf;
extern int lex_pos;
static Pix ASIntoSymTab( char *as );

extern Error *get_routes_by_origin(DBCnxn &, const char*, char **&);
extern Error *expand_as_macro(DBCnxn &, const char*, char **&);
%}

%union {
char *val;
Node *node_ptr;
}

/* Careful with the token values, below. They must match the values in Node.h */
%token <val> FROM_TOK    258
%token <val> ASPATH_TOK  272
%token <val> ACCEPT_TOK  259
%token <val> PRFMSK_TOK  260
%token <val> NUM_TOK     262
%token <val> DBSEL_TOK   263
%token <val> ASNUM_TOK   264
%token <val> ASMACRO_TOK 265
%token <val> CNAME_TOK   266
%token <val> ERR_TOK     267
%token <val> ANY_TOK     268
%left  <val> OR_TOK      269
%left  <val> AND_TOK     270
%right <val> NOT_TOK     271
%type <node_ptr> rpe
%type <node_ptr> rpe_term
%type <node_ptr> rpe_factor
%type <node_ptr> operand
%type <node_ptr> netlist
%type <node_ptr> policy_line

%%
policy_line: FROM_TOK ASNUM_TOK NUM_TOK ACCEPT_TOK rpe
{
	ASNode     *as_node;
	MetricNode *metric_node;
	ASMap &symtbl = *ASST;
	Pix p;

	DPRINTF("policy_line := FROM_TOK ASNUM_TOK NUM_TOK ACCEPT_TOK rpe\n");

	p = ASIntoSymTab( $2 );

	Big_Root    = new PolicyLineNode;
	as_node     = new ASNode( p );
	metric_node = new MetricNode( $3 );
	Big_Root->AddChildren( as_node, metric_node, $5, NULL );
	
	$$ = Big_Root;
}
           | ASNUM_TOK NUM_TOK rpe
{
	ASNode *as_node;
	MetricNode *metric_node;
	ASMap &symtbl = *ASST;
	Pix p;

	DPRINTF("policy_line := ASNUM_TOK NUM_TOK rpe\n");

	p = ASIntoSymTab( $1 );

	Big_Root    = new PolicyLineNode;
	as_node     = new ASNode( p );
	metric_node = new MetricNode( $2 );
	
	Big_Root->AddChildren( as_node, metric_node, $3, NULL );
	$$ = Big_Root;
}
           | rpe
{
	ASNode *as_node;
	MetricNode *metric_node;
	Pix p;

	DPRINTF("policy_line := rpe\n");

	p = ASIntoSymTab( new_strdup( "AS1" ) );

	Big_Root    = new PolicyLineNode;
	as_node     = new ASNode( p );
	metric_node = new MetricNode( 0 );
	
	Big_Root->AddChildren( as_node, metric_node, $1, NULL );
	$$ = Big_Root;
};

rpe:     rpe OR_TOK rpe_term
{

	ORNode *or_ptr;

	DPRINTF("rpt := rpe OR_TOK rpe_term\n");

	or_ptr = new ORNode;
	or_ptr->AddChildren( $1, $3, NULL );
	$$ = or_ptr;
}
    | rpe rpe_term %prec OR_TOK
{
    ORNode *OR_ptr;

	DPRINTF("rpe := rpe rpe_term\n");
	OR_ptr = new ORNode;
	OR_ptr->AddChildren( $1, $2, NULL );
	$$ = OR_ptr;
}
| rpe_term
{
	DPRINTF("rpe := rpe_term\n");
}
;
rpe_term : rpe_term AND_TOK rpe_factor
{

	ANDNode *and_ptr;

	DPRINTF("rpt := rpe_term AND_TOK rpe_factor\n");

	and_ptr = new ANDNode;
	and_ptr->AddChildren( $1, $3, NULL );
	$$ = and_ptr;
}
|
rpe_factor
;

rpe_factor :  NOT_TOK rpe_factor
{
    NotNode *op_ptr;

	DPRINTF("rpe := NOT_TOK rpe_factor\n");

	op_ptr = new NotNode;
	op_ptr->AddChildren( $2, NULL );
	$$ = op_ptr;
}
		| '(' rpe ')'
{
	DPRINTF("rpe := ( rpe )\n");
	$$ = $2;
}
    | operand 
{
	DPRINTF("rpe := operand\n");
 	$$ = $1; 
}	
;

operand: ASNUM_TOK
{
	ASMap &symtbl = *ASST;
	Pix p;

	DPRINTF("operand := ASNUM_TOK\n");

	p = ASIntoSymTab( $1 );

	$$ = new ASNode( p );
}

    | ASMACRO_TOK
{
	Node *node_ptr;
	DPRINTF("operand := ASMACRO_TOK\n");

	// Add the macro name to the ASMacroST symbol table.
	ASMacroMap &symtbl = *ASMacroST;
	Pix p, q;
	char not_buf[128];

	if ( !(p = symtbl.seek( $1 )) ) {
		(void) symtbl[ $1 ];
		p = symtbl.seek( $1 );
	}
	else delete[] $1;

	sprintf(not_buf,"Not %s", symtbl.key( p ) );

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup(not_buf) ];
		q = symtbl.seek( not_buf );
	}

	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;
	node_ptr = new ASMacroNode( p );

	$$ = node_ptr;
}

    | CNAME_TOK
{
	Node *node_ptr;
	DPRINTF("operand := CNAME_TOK\n");

	CommDBSelMap &symtbl = *CommDBSelST;
	Pix p,q;
	char not_buf[128];

	(void) symtbl[ $1 ];	

	sprintf(not_buf,"Not %s", $1);

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup(not_buf) ];
		q = symtbl.seek( not_buf );
	}

	p = symtbl.seek( $1 );
	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;
	node_ptr = new CommNode( p );

	$$ = node_ptr;
}

    | ANY_TOK
{
	ANYNode *any_ptr;
	DPRINTF("operand := ANY_TOK\n");

	any_ptr = new ANYNode;
	$$ = any_ptr;
}

    | '{' netlist '}' 
{ 
	DPRINTF("operand := { netlist }\n");
	$$ = $2; 
}

    | DBSEL_TOK
{
	CommDBSelMap &symtbl = *CommDBSelST;
	Pix p, q;
	char not_buf[128];

	if ( !(p = symtbl.seek( $1 )) ) {
		(void) symtbl[ $1 ];	
		p = symtbl.seek( $1 );
	}
	else delete[] $1;

	// The following 'if' stmt is necessary because we don't want to allocate 
	// memory that we never free.  The problem is that the call symtbl[] doesn't 
	// make a copy of the string you hand it.  We don't know apriori if we've
	// installed "Not $1" yet.  And what's worse, the call to symtbl[] doesn't
	// tell you if the string(aka 'key') is already there or not.  If we make
	// a copy of "Not $1" and call symtbl[], we wouldn't know if the string was
	// already in the Map and thus if we should free the string.  The way around
	// this is to seek() for it first, and if not found, strdup and install.
	// 
	// Note that this situation occurs at several other locations in this file.

	sprintf(not_buf,"Not %s", symtbl.key( p ));

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup( not_buf ) ];
		q = symtbl.seek( not_buf );
	}

	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;
	$$ = new DBSelNode( p );
}
| ASPATH_TOK
{
	Pix q;
	ASPathMap &path_symtbl = *ASPathST;

	DPRINTF("operand := ASPATH_TOK\n");

	// BIG Question:  What to store in the symbol table for AS paths?
	if ( !(q = path_symtbl.seek( $1 ) ) ) {
		(void) path_symtbl[ $1 ];
		q = path_symtbl.seek( $1 );
	}
	else delete[] $1;

	$$ = new ASPathNode( q );
}
;

netlist:  PRFMSK_TOK
{
	PRFMSKNode *prefix_node;
	NetListNode *netlist_node;
	PrefaskAVLSet &symtbl = *PrefaskST;
	Pix p;

	DPRINTF("netlist := PRFMSK_TOK\n");

	if ( !( p = symtbl.seek( $1 ) ) )
		p = symtbl.add( $1 );
	else delete[] $1;

	prefix_node = new PRFMSKNode( p );

	netlist_node = new NetListNode;
	netlist_node->AddChildren( prefix_node, NULL );
	$$ = netlist_node;
}
        | netlist ',' PRFMSK_TOK
{
	PRFMSKNode *new_node;
	PrefaskAVLSet &symtbl = *PrefaskST;
	Pix p;

	DPRINTF("netlist := netlist ',' PRFMSK_TOK\n");

	if ( !( p = symtbl.seek( $3 )) )
		p = symtbl.add( $3 );
	else delete[] $3;

	new_node = new PRFMSKNode( p );
	$1->AddChildren( new_node, NULL );
	$$ = $1;
}
;

%%

yyerror(char *s)
{
//	printf("line(%d):'%s'\n", lex_pos, lex_buf);
	parse_error_rec.line = lex_buf;
	parse_error_rec.pos = lex_pos;
	lex_pos = 0;

	return( parse_error_rec.pos );
}

void init_symbol_tables( void )
{
	SymTab dflt;

	PrefaskST   = new PrefaskAVLSet();
	ASMacroST   = new ASMacroMap( dflt );
	CommDBSelST = new CommDBSelMap( PrefaskST, dflt );
	ASST        = new ASMap( PrefaskST, dflt );
	ASPathST    = new ASPathMap( ASST, dflt );
}

void kill_symbol_tables( void )
{
	delete PrefaskST; PrefaskST = NULL;
	delete ASMacroST; ASMacroST = NULL;
	delete CommDBSelST; CommDBSelST = NULL;
	delete ASST; ASST = NULL;
	delete ASPathST; ASPathST = NULL;
}

void print_symbol_tables( void )
{
	cout << "Symbol Table Dump Of AS-MACROs\n";
	ASMacroST->dump();

	cout << "\nSymbol Table Dump Of Communities\n";
	CommDBSelST->dump();

	cout << "\nSymbol Table Dump Of Prefix/Masks\n";
	PrefaskST->dump();   

	cout << "\nSymbol Table Dump Of AS Numbers\n";
	ASST->dump();   

	cout << "\nSymbol Table Dump Of AS Paths\n";
	ASPathST->dump();   
}

void expand_tables( unsigned int flags )
{
	unsigned int unknown = 0;

	if ( flags == ~(unsigned int) 0 ) {
		ASMacroST->expand( parser_db_ptr );
		CommDBSelST->expand( parser_db_ptr );
		ASST->expand( parser_db_ptr );
		return;
	}

	unknown = flags & ~(EXPAND_AS_MACROS|EXPAND_COMMUNITIES|EXPAND_AS);
	if ( unknown ) {
		cerr << "Error: " << __FILE__ << "(" << __LINE__ << ")" << endl;
		cerr << "Error: Unrecognized flag in " << hex << flags << endl;
		cerr << "Error: The unrecognized flags are " << hex << unknown << endl;
		abort();
	}

	if ( flags & EXPAND_AS_MACROS )
			ASMacroST->expand( parser_db_ptr );

	if (flags & EXPAND_COMMUNITIES )
			CommDBSelST->expand( parser_db_ptr );

	if (flags & EXPAND_AS )
			ASST->expand( parser_db_ptr );

}

static void add_routes( _SetOfInt &PRFXset, const char *as_str )
{
	Error *error;
	PrefaskAVLSet &symtbl = *PrefaskST;
	int i;
	Pix prfsk_pix;	
	char **routes;

	error = get_routes_by_origin( *parser_db_ptr, as_str+2, routes );

	if ( !routes )
		cerr << "Warning: Cannot get_routes_by_orgin for " << as_str << endl;

	else {

		for( i = 0; routes[i]; i++ ) {
			if ( !(prfsk_pix = symtbl.seek( routes[i] ) ) )
				prfsk_pix = symtbl.add( new_strdup( routes[i] ) );

			PRFXset.add( (int) prfsk_pix );
		}
		delete[] routes[0];  // Obscure.  Not good code.
		delete[] routes;
	}

	delete error;
}

void AS2AdrPrfx( _SetOfInt &ASSet, _SetOfInt &PRFXset )
{
	PrefaskAVLSet &symtbl = *PrefaskST;
	ASMap &lasmap = *ASST;
	Pix r, p;
	char *as_str;

	for( r = ASSet.first(); r; ASSet.next( r ) ) {
		as_str = lasmap.key( (Pix) ASSet( r ) );

		p = lasmap.seek( as_str ); // Thus must always find as_str.
		if ( lasmap.contents(p).evaluated ) // AS in tbl & evaluated
			PRFXset |= lasmap.contents(p).value;

		else { // AS in tbl but not evaluated
			add_routes( lasmap.contents(p).value, as_str );
			lasmap.contents(p).evaluated = 1;
			PRFXset |= lasmap.contents(p).value;
		}
	}
}

// This routine could be used more throughout the source in this file.
// IE, the only place from where it is currently called is 
// as_macro_expand( char *name ).
static Pix ASIntoSymTab( char *as )
{
	ASMap &symtbl = *ASST;
	Pix p, q;
	char not_buf[128];


	if ( !(p = symtbl.seek( as )) ) {
		(void) symtbl[ as ];
		p = symtbl.seek( as );
	}
	else
		delete[] as;

	sprintf(not_buf,"Not %s", as);

	if ( !(q = symtbl.seek( not_buf )) ) {
		(void) symtbl[ new_strdup( not_buf ) ];
		q = symtbl.seek( not_buf );
	}

	symtbl.contents(p).not = q;
	symtbl.contents(q).not = p;
	symtbl.contents(q).evaluated = 2;

	return( p );
}

// A version of strdup using new.  I'm trying to avoid mixing and matching
// memory allocators.
static char *new_strdup( char *str )
{
	int len = strlen( str );
	char *new_str = new char[ len + 1 ];
	strcpy( new_str, str );

	return( new_str );
}
