// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include "polparse.h"
#include "NodePolicyLine.h"
#include "typedefs.h"
#include "debug.hh"
#include "trace.hh"
#include "rusage.hh"
#include "f_peval.hh"
#include "f_gated.hh"

extern int yyparse(void);
extern char *lex_buf;
extern DBCnxn *parser_db_ptr;
extern PolicyLineNode *Big_Root;
extern ParseErrRec parse_error_rec;


Rusage ru;

void sync_w_caller () {
   cout.flush(); // just in case
   clog.flush(); // just in case
   cerr << "END" << endl;
   cerr.flush(); // just in case
}

char opt_hostname[256] = "radb.ra.net";
char opt_database[256] = ""; // "radb,prdb,ripe,mci,canet";
int  opt_port          = 5042;
int  opt_expand        = 0;
int  opt_config        = 0;
int  opt_sync          = 0;
int  opt_rusage        = 0;
int  opt_import        = 1;
int  opt_print_cmmnts  = 0;
char opt_exec_arg[256] = "";

char address_prefix_format[64] = "";
char peer_as_no[64] = "";
char view_name[64] = "";

void usage(char *argv[]) {
   printf("Usage: %s to be written later\n", argv[0]);
   exit(1);
}

config_format_type config_formats[] = {
   { "peval",       peval_process_line },
   { "gated",       gated_process_line },
   { "routeserver", gated_process_line },
   { "", 0 }
};

void init_and_set_options (int argc, char **argv) {

   for (int i = 1; i < argc && *argv[i] == '-'; i++)  {
      if (strcmp(argv[i], "-T") == 0)  { // trace
         i++;
         if (i >= argc)
            usage(argv);
         trace.enable(argv[i]);
         continue;
      }
      if (strcmp(argv[i], "-D") == 0)  {
         i++;
         if (i >= argc)
            usage(argv);
         Debug(dbg.enable(atoi(argv[i])));
         continue;
      }
      if (strcmp(argv[i], "-h") == 0)  {
         i++;
         if (i >= argc)
            usage(argv);
         strcpy(opt_hostname, argv[i]);
         continue;
      }
      if (strcmp(argv[i], "-p") == 0)  {
         i++;
         if (i >= argc)
            usage(argv);
         opt_port = atoi(argv[i]);
         continue;
      }
      if (strcmp(argv[i], "-s") == 0)  {
         i++;
         if (i >= argc)
            usage(argv);
         strcpy(opt_database, argv[i]);
         continue;
      }
      if (strcmp(argv[i], "-config") == 0)  {
         i++;
         if (i >= argc)
            usage(argv);
	 for (opt_config = 0; *config_formats[opt_config].name; opt_config++)
	    if (strcmp(argv[i], config_formats[opt_config].name) == 0)
	       break;
	 if (! *config_formats[opt_config].name) {
	    cerr << "Error: config file format '" << argv[i] << "' is not supported..." << endl;
	    exit(1);
	 }	    
         continue;
      }
      if (strcmp(argv[i], "-sync") == 0)  {
	 opt_sync = 1;
         continue;
      }
      if (strcmp(argv[i], "-rusage") == 0)  {
	 opt_rusage = 1;
         continue;
      }
      if (strcmp(argv[i], "-import") == 0)  {
	 opt_import = 1;
         continue;
      }
      if (strcmp(argv[i], "-export") == 0)  {
	 opt_import = 0;
         continue;
      }
      if (strcmp(argv[i], "-expand_as_macros") == 0)  {
	 opt_expand |= EXPAND_AS_MACROS;
         continue;
      }
      if (strcmp(argv[i], "-expand_communities") == 0)  {
	 opt_expand |= EXPAND_COMMUNITIES;
         continue;
      }
      if (strcmp(argv[i], "-expand_as") == 0)  {
	 opt_expand |= EXPAND_AS;
         continue;
      }
      if (strcmp(argv[i], "-expand_all") == 0)  {
	 opt_expand |= EXPAND_ALL;
         continue;
      }
      if (strcmp(argv[i], "-e") == 0)  {
         i++;
         if (i >= argc)
            usage(argv);
         strcpy(opt_exec_arg, argv[i]);
         continue;
      }
      usage(argv);
   }
}


void process_escape_command(char *str) {
   if (strcmp(str, "!flush") == 0)  {
      Trace(TR_INPUT) << "Peval: flushing caches on request" << endl;
      kill_symbol_tables();
      init_symbol_tables();
      return;
   }
   if (strcmp(str, "!export") == 0)  {
      Trace(TR_INPUT) << "Peval: will output export filters" << endl;
      opt_import = 0;
      return;
   }
   if (strcmp(str, "!import") == 0)  {
      Trace(TR_INPUT) << "Peval: will output import filters" << endl;
      opt_import = 1;
      return;
   }
   if (strncmp(str, "!address_prefix_format=", 23) == 0)  {
      strcpy(address_prefix_format, strchr(str, '=')+1);
      Trace(TR_INPUT) << "Peval: address_prefix_format is '" 
		      << address_prefix_format << "'" << endl;
      return;
   }
   if (strncmp(str, "!peer_as_no=", 12) == 0)  {
      strcpy(peer_as_no, strchr(str, '=')+1);
      Trace(TR_INPUT) << "Peval: peer_as_no is '" 
		      << peer_as_no << "'" << endl;
      return;
   }
   if (strncmp(str, "!view_name=", 11) == 0)  {
      strcpy(view_name, strchr(str, '=')+1);
      Trace(TR_INPUT) << "Peval: view_name is '" 
		      << view_name << "'" << endl;
      return;
   }
   cerr << "Peval: unrecognized escape command: '" << str << "'" << endl;
} 



static DBCnxn dbcnxn;

NormalExpression* parse_and_evaluate (char *str, int expand) {
   NormalExpression* result;
   parser_db_ptr = &dbcnxn;

   lex_buf = str;  // lex_buf is a global variable.

   if ( yyparse() ) {
      cerr << "Error: '" << str << "'\n" 
	   << "Error:  " << setw(parse_error_rec.pos) << "^" 
	   << endl;
      return 0;
   } else {
      if (expand) {
	 ASMacroST->expand(&dbcnxn);
	 CommDBSelST->expand(&dbcnxn);
      }

      result = Big_Root->Evaluate(expand);
      delete Big_Root;
      return result;
   }

   ASSERT(0);
   return 0;
}


main (int argc, char **argv) {
   char str[64*1024];
   Error *error;

   init_and_set_options(argc, argv);

   // Open database connection
   if (opt_expand) { 
      dbcnxn.open(opt_hostname, opt_port);

      if (*opt_database != 0)
	 if (dbcnxn.SelectDatabase(opt_database)) { // returns true if error
	    clog << "Error opening " << opt_database 
		 << ": (" << error->get_code() 
		 << ") "  << error->get_msg() 
		 << endl;
	 }
   }

   init_symbol_tables();

   if (opt_sync)
      sync_w_caller();
   
   if (*opt_exec_arg == 0) 
      while (cin.getline(str,64*1024)) {
	 Trace(TR_INPUT) << "input: '" << str << "'" << endl;

	 if (*str == '!') 
	    process_escape_command(str);
	 else  
	    (*config_formats[opt_config].process_line)
	       (str, opt_expand, opt_import);
	       
	 if (opt_sync)
	    sync_w_caller();
	 if (!opt_config) { // 0 is peval itseld, i.e. no config
	    kill_symbol_tables();
	    init_symbol_tables();
	 }
      }
   else {
      Trace(TR_INPUT) << "input: '" << opt_exec_arg << "'" << endl;
      (*config_formats[opt_config].process_line)
	 (opt_exec_arg, opt_expand, opt_import);
      kill_symbol_tables();
      init_symbol_tables();
   }
      
	
   // check why the loop ended
   if (cin.fail() && !cin.eof()) { // IO failure
      cerr << "Error: while reading input, perhaps input is too long..." << endl;
   }
   
   kill_symbol_tables();

   CLASS_DEBUG_MEMORY_PRINT(Set);
   CLASS_DEBUG_MEMORY_PRINT(NormalTerm);
   CLASS_DEBUG_MEMORY_PRINT(NormalExpression);
   CLASS_DEBUG_MEMORY_PRINT(SymbolConjunct);

   if (opt_expand) 
      dbcnxn.close(); // Close connection to the routing registry.

   if (opt_rusage)
      clog << ru;

   if (opt_sync)
      sync_w_caller();
}
