// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef PEVAL_H
#define PEVAL_H

#define EXPAND_AS_MACROS         0x000001
#define EXPAND_COMMUNITIES       0x000002
#define EXPAND_AS                0x000004
#define EXPAND_NOTHING           0
#define EXPAND_ALL               (~0)

extern char *AS_format(int i);
extern char *AS_Path_format(int i);
extern char *PRFX_format(int i);
extern char *AS_SYM_format(int i);
extern char *AS_MACROS_format(int i);
extern char *PRFX_MACROS_format(int i);

extern char opt_hostname[256];
extern char opt_database[256];
extern int  opt_port;
extern int  opt_config;
extern int  opt_sync;
extern int  opt_expand;
extern int  opt_rusage;
extern int  opt_import;
extern int  opt_print_cmmnts;

extern char address_prefix_format[];
extern char peer_as_no[];
extern char view_name[];

typedef struct {
   char *name;
   void (*process_line)(char *, int, int);
} config_format_type;

extern config_format_type config_formats[];

#define CONFIG_PEVAL          0
#define CONFIG_GATED          1
#define CONFIG_ROUTESERVER    2

#endif // PEVAL_H
