#!/usr/local/bin/perl
# $Id: eg:routeserver.pl,v 1.4 95/04/17 15:54:39 cengiz Exp $
# 
#  Copyright (c) 1994 by the University of Southern California
#  and/or the International Business Machines Corporation.
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation in source and binary forms for lawful
#  non-commercial purposes and without fee is hereby granted, provided
#  that the above copyright notice appear in all copies and that both
#  the copyright notice and this permission notice appear in supporting
#  documentation, and that any documentation, advertising materials,
#  and other materials related to such distribution and use acknowledge
#  that the software was developed by the University of Southern
#  California, Information Sciences Institute and/or the International
#  Business Machines Corporation.  The name of the USC or IBM may not
#  be used to endorse or promote products derived from this software
#  without specific prior written permission.
#
#  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
#  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
#  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
#  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
#  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
#  NON-INFRINGEMENT.
#
#  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
#  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
#  THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#  Questions concerning this software should be directed to 
#  info-ra@isi.edu.
#
#  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

push(@INC, "lib");
require "config_routeserver.pl";

$whoishost      = "radb.ra.net";
$port           = 5042;
#$database       = "radb,prdb,ripe,mci,canet";
$database       = "jyy,radb,prdb,ripe,mci,canet";

require "getopts.pl";
do Getopts('h:p:s:');	

$whoishost = $opt_h if ($opt_h);
$port = $opt_p if ($opt_p);
$database = $opt_s if ($opt_s);

$preference_offset = 100;

$peval          = "../peval/peval";
$peval_options  = "-h $whoishost -p $port -s $database -expand_all -config routeserver -sync";

############### Route server specific part #################################

print "# this is the config file prolog\n\n";

&pol2filters_init();

# view 1 is for 198.32.132.12/32 in AS3561
# import routes from 198.32.132.10/32
&pol2import_filters("AS3561", "198.32.132.12/32", "AS690", "198.32.132.10/32",
	    "view 1");
# import routes from 198.32.132.13/32
&pol2import_filters("AS3561", "198.32.132.12/32", "AS1239", "198.32.132.13/32",
	    "view 1");
# export routes advertised by 198.32.132.10/32
# note that we are exporting to 198.32.132.12/32

print "export proto bgp as 3561 {\n";
&pol2export_filters("AS3561", "198.32.132.12/32", "AS690", "198.32.132.10/32",
	    "view 1");
# export routes advertised by 198.32.132.10/32
&pol2export_filters("AS3561", "198.32.132.12/32", "AS1239", "198.32.132.13/32",
	    "view 1");
print "}\n";

&pol2filters_end();

print "\n# this is the config file epilog\n";
