#!/local/bin/perl
# $Id: config_gated.pl,v 1.3 95/04/17 15:55:00 cengiz Exp $
# 
#  Copyright (c) 1994 by the University of Southern California
#  and/or the International Business Machines Corporation.
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation in source and binary forms for lawful
#  non-commercial purposes and without fee is hereby granted, provided
#  that the above copyright notice appear in all copies and that both
#  the copyright notice and this permission notice appear in supporting
#  documentation, and that any documentation, advertising materials,
#  and other materials related to such distribution and use acknowledge
#  that the software was developed by the University of Southern
#  California, Information Sciences Institute and/or the International
#  Business Machines Corporation.  The name of the USC or IBM may not
#  be used to endorse or promote products derived from this software
#  without specific prior written permission.
#
#  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
#  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
#  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
#  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
#  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
#  NON-INFRINGEMENT.
#
#  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
#  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
#  THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#  Questions concerning this software should be directed to 
#  info-ra@isi.edu.
#
#  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

# Gated configuration driver

require "qradbserver.pl";
require "data2policy.pl";
require "policy2filters.pl";
require "pevalclient.pl";

select (STDERR); $| = 1;
select (STDOUT); $| = 1;

$lastas = "";

sub pol2filters_init {
    &OpenConnection($whoishost,$port);
    &AskServer("s$database", *ignored);
    &StartPeval($peval, $peval_options);
}

sub pol2filters_end {
    &EndPeval();
    &CloseConnection($whoishost,$port);
}

sub pol2import_filters {
    local ($as, $br, $peeras, $peerbr) = @_;
    # the config file is for $br in as $as
    # we are importing routes from $peerbr in as $peeras

    &__pol2filters($as, $br, $peeras, $peerbr, 0);
}

sub pol2export_filters {
    local ($as, $br, $peeras, $peerbr) = @_;
    # the config file is for $br in as $as
    # we are exporting routes to $peerbr in as $peeras

    &__pol2filters($as, $br, $peeras, $peerbr, 1);
}

sub __pol2filters {
    local ($as, $br, $peeras, $peerbr, $exportflag) = @_;

    if ($as ne $lastas) {
	@data = ();
	&AskServer("man,$as", *data);
	%policy = ();
	&data2policy($as, *data, *policy);
	$lastas = $as;
	&AskPeval("!flush");
    }

    %filters = ();
    local($peerasno) = $peeras;
    $peerasno =~ s/AS//iog;
    local($asno) = $as;
    $asno =~ s/AS//iog;

    if ($exportflag) {
	&policy2export_filters(*policy, *filters, $as, $peeras, $br, $peerbr);
	print "export proto bgp as $peerasno {\n";

	&AskPeval("!export");
	&AskPeval("!address_prefix_format=      %s masklen %s exact");
	&AskPeval("!peer_as_no=$asno");
	&AskPeval($filters{"export%$as%$peeras%$br%$peerbr"});

	print "};\n";
    } else {
	&policy2import_filters(*policy, *filters, $as, $peeras, $br, $peerbr);

	&AskPeval("!import");
	&AskPeval("!address_prefix_format=   %s masklen %s exact");
	&AskPeval("!peer_as_no=$peerasno");
	&AskPeval($filters{"import%$as%$peeras%$br%$peerbr"});

    }
}

1;
