#!/local/bin/perl
# $Id: config_routeserver.pl,v 1.4 95/04/17 15:55:01 cengiz Exp $
# 
#  Copyright (c) 1994 by the University of Southern California
#  and/or the International Business Machines Corporation.
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation in source and binary forms for lawful
#  non-commercial purposes and without fee is hereby granted, provided
#  that the above copyright notice appear in all copies and that both
#  the copyright notice and this permission notice appear in supporting
#  documentation, and that any documentation, advertising materials,
#  and other materials related to such distribution and use acknowledge
#  that the software was developed by the University of Southern
#  California, Information Sciences Institute and/or the International
#  Business Machines Corporation.  The name of the USC or IBM may not
#  be used to endorse or promote products derived from this software
#  without specific prior written permission.
#
#  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
#  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
#  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
#  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
#  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
#  NON-INFRINGEMENT.
#
#  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
#  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
#  THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#  Questions concerning this software should be directed to 
#  info-ra@isi.edu.
#
#  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

# Route server configuration driver

require "qradbserver.pl";
require "data2policy.pl";
require "policy2filters.pl";
require "pevalclient.pl";

select (STDERR); $| = 1;
select (STDOUT); $| = 1;

$lastas = ""; 
$lastpeeras = "";

sub pol2filters_init {
    &OpenConnection($whoishost,$port);
    &AskServer("s$database", *ignored);
    &StartPeval($peval, $peval_options);
}

sub pol2filters_end {
    &EndPeval();
    &CloseConnection($whoishost,$port);
}

sub pol2export_filters {
    local ($as, $br, $peeras, $peerbr, $view) = @_;
    # the name of the view is $view
    # the view is for peer $br in as $as
    # we are exporting routes that are advertised by $peerbr in as $peeras
    
    print STDERR "Warning: pol2export_filters just prints 'proto bgp aspath .* { all; };'...\n";

    print "   proto bgp aspath .* {\n      all;\n   };\n";
}

sub pol2import_filters {
    local ($as, $br, $peeras, $peerbr, $view) = @_;
    # the name of the view is $view
    # the view is for peer $br in as $as
    # we are importing routes from $peerbr in as $peeras

    &AskPeval("!flush") 
	if ($as ne $lastas && $peeras ne $lastpeeras);

    if ($as ne $lastas) {
	@data = ();
	&AskServer("man,$as", *data);
	%policy = ();
	&data2policy($as, *data, *policy);
	$lastas = $as;
    }

    if ($peeras ne $lastpeeras) {
	@data = ();
	&AskServer("man,$peeras", *data);
	%peerpolicy = ();
	&data2policy($peeras, *data, *peerpolicy);
	$lastpeeras = $peeras;
    }
	
    %filters = ();
    local($peerasno) = $peeras;
    $peerasno =~ s/AS//iog;
    local($asno) = $as;
    $asno =~ s/AS//iog;

    &policy2import_filters(*policy, *filters, $as,$peeras, $br,$peerbr);
    &policy2export_filters(*peerpolicy, *filters, $peeras,$as, $peerbr,$br);

    local (@export_filter) = 
      split(/\+/, $filters{"export%$peeras%$as%$peerbr%$br"});
    local (@import_filter) = 
      split(/\+/, $filters{"import%$as%$peeras%$br%$peerbr"});

    local (@filter) = ();
    local ($cost, $im_expr, $med,  $ex_expr);
    local ($i);
    local ($j);

    foreach $i (0..$#import_filter) {
      foreach $j (0..$#export_filter) {
	($cost, $im_expr) = split(/\s/, $import_filter[$i], 2);
	$cost =~ s/:MED//o;
	($med,  $ex_expr) = split(/\s/, $export_filter[$j], 2);
	push(@filter, "$cost:$med ($im_expr) AND ($ex_expr)");
      }
    }

    &AskPeval("!import");
    &AskPeval("!address_prefix_format=   %s masklen %s exact");
    &AskPeval("!peer_as_no=$peerasno");
    &AskPeval("!view_name=$view");
    &AskPeval(join('+', @filter));

}

1;
