#!/local/bin/perl
# $Id: data2policy.pl,v 1.3 95/03/16 19:27:21 cengiz Exp $
# 
#  Copyright (c) 1994 by the University of Southern California
#  and/or the International Business Machines Corporation.
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation in source and binary forms for lawful
#  non-commercial purposes and without fee is hereby granted, provided
#  that the above copyright notice appear in all copies and that both
#  the copyright notice and this permission notice appear in supporting
#  documentation, and that any documentation, advertising materials,
#  and other materials related to such distribution and use acknowledge
#  that the software was developed by the University of Southern
#  California, Information Sciences Institute and/or the International
#  Business Machines Corporation.  The name of the USC or IBM may not
#  be used to endorse or promote products derived from this software
#  without specific prior written permission.
#
#  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
#  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
#  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
#  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
#  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
#  NON-INFRINGEMENT.
#
#  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
#  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
#  THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#  Questions concerning this software should be directed to 
#  info-ra@isi.edu.
#
#  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

sub data2policy {
    local ($as, *data, *policy) = (@_);
    local ($peeras, $rest, $tmp, $pref, $br, $peerbr) = "";

# A note on ripe 181: A line can be continued to the next line 
# by repeating everything upto the policy expression.
# E.g.
# as-in: AS1 1 ANY AND NOT
# as-in: AS1 1 AS1
#
# is equivalant to
# as-in: AS1 1 ANY AND NOT AS1
#
# the following variables are used to handle this.
    local ($lastline, $thisline) = "";

    local($i) = 0;
    local($extended) = 0;

    # just keep the policy lines
    @data = grep(/^((extended-)?(inter)?as-(in|out)|\*(ai|ao|it|io|xa|xb|xc|xd)):/, @data);

    # convert case and get rid of optional keywords
    foreach $_ (@data) {
	&transform(*_);
    }

    # handle extended and original attribute interaction
    # find the peer AS's for which an extended attribute is used.

    #print STDERR join("\n", @data), "\n" if $opt_d;

    foreach $_ (grep(/^(extended-.*|\*x[abcd]):/, @data)) {
	/^(extended-.*|\*x[abcd]):\s*(AS[0-9]+)\s.*$/;
        # delete the original attributes
	$peeras = $2;
	@data = grep(!/^((inter)?as-(in|out)|\*(ai|ao|it|io)):\s*$peeras\s/, @data);
    }
    # @data now contains either original or extended attributes for each peer AS
    #print "---\n", join("\n", @data), "\n" if $opt_d;

    foreach $i (0..$#data) {
	$_ = $data[$i];

# split policy lines into peer, weight and policy expression parts

# as-in lines
	if ((/^as-in:/ || /^\*ai:/ 
	     || /^extended-as-in:/ || /^\*xa:/)) {

	    ($tmp, $peeras, $pref, $rest) = split(/[\s\t]+/, $_, 4);

	    $policy{"c-as-in%$as%$peeras"} .=  $rest . " ";
	    $thisline = "as-in%$as%$peeras%$pref";
	    if ($thisline eq $lastline) {
                # get rid of last +, and do not add pref
		chop $policy{"as-in%$as%$peeras"}; 
		$policy{"as-in%$as%$peeras"}   .= " $rest+";
	    } else {
		$policy{"as-in%$as%$peeras"}   .= "$pref $rest+";
		$policy{"p-as-in%$as"} .= "$pref+";
	    }
	    $lastline = $thisline;
	    next;
	}

# as-out lines
	if ((/^as-out:/ || /^\*ao:/ 
	     || /^extended-as-out:/ || /^\*xb:/)) {

	    ($tmp, $peeras, $rest) = split(/[\s\t]+/, $_, 3);

	    $policy{"c-as-out%$as%$peeras"} .= $rest . " ";
	    $thisline = "as-out%$as%$peeras";
	    if ($thisline eq $lastline) {
                # get rid of last +
		chop $policy{"as-out%$as%$peeras"};
		$policy{"as-out%$as%$peeras"} .= " $rest+";
	    } else {
		$policy{"as-out%$as%$peeras"} .= "$rest+";
	    }
	    $lastline = $thisline;
	    next;
	}

# interas-in lines
	if ((/^interas-in:/ || /^\*it:/ 
	     || /^extended-interas-in:/ || /^\*xc:/)) {

	    ($tmp, $peeras, $br, $peerbr, $rest) = split(/[\s\t]+/, $_, 5);
	    $rest =~ /\(\s*PREF\s*=\s*([^)\s]*)\s*\)\s*(.*)$/o;
	    $pref = $1;
	    $rest = $2;

	    $policy{"c-interas-in%$as%$peeras"} .= $rest . " ";
	    $thisline = "interas-in%$as%$peeras%$br%$peerbr%$pref";
	    if ($thisline eq $lastline) {
                # get rid of last +, and do not add pref
		chop $policy{"interas-in%$as%$peeras%$br%$peerbr"}; 
		$policy{"interas-in%$as%$peeras%$br%$peerbr"} .= " $rest+";
	    } else {
		$policy{"interas-in%$as%$peeras%$br%$peerbr"} .= "$pref $rest+";
		$policy{"p-interas-in%$as%$peeras"} .= "$pref+";
	    }
	    $lastline = $thisline;
	    next;
	}

# interas-out lines
	if ((/^interas-out:/ || /^\*io:/ 
	     || /^extended-interas-out:/ || /^\*xd:/)) {

	    ($tmp, $peeras, $br, $peerbr, $rest) = split(/[\s\t]+/, $_, 5);
	    if ($rest =~ /\(\s*METRIC-OUT\s*=\s*([^)\s]*)\s*\)?\s*(.*)$/o) {
               $pref = $1;
               $rest = $2;
	     } else {
	       $pref = "?";
	     }

	    $policy{"c-interas-out%$as%$peeras"} .= $rest . " ";
	    $thisline = "interas-out%$as%$peeras%$br%$peerbr%$pref";
	    if ($thisline eq $lastline) {
                # get rid of last +, and do not add pref
		chop $policy{"interas-out%$as%$peeras%$br%$peerbr"}; 
		$policy{"interas-out%$as%$peeras%$br%$peerbr"} .=" $rest+";
	    } else {
		$policy{"interas-out%$as%$peeras%$br%$peerbr"} .="$pref $rest+";
	    }
	    $lastline = $thisline;
	    next;
	}
        $lastline = "";			# non policy line
   }

   # calculate left over routes
   foreach $peeras (grep(s/c-as-in%$as%//, keys %policy)) {
 	$policy{"l-as-in%$as%$peeras"} = 
 	    &setminus($policy{"c-as-in%$as%$peeras"}, 
                      $policy{"c-interas-in%$as%$peeras"});
   }

   foreach $peeras (grep(s/c-as-out%$as%//, keys %policy)) {
 	$policy{"l-as-out%$as%$peeras"} = 
 	    &setminus($policy{"c-as-out%$as%$peeras"}, 
                      $policy{"c-interas-out%$as%$peeras"});
   }

}

sub transform {
    local (*str) = @_;

    $str =~ s/from//gio;
    $str =~ s/to//gio;
    $str =~ s/accept//gio;
    $str =~ s/announce//gio;
    $str =~ s/pref/PREF/gio;
    $str =~ s/metric-out/METRIC-OUT/gio;
}

sub setminus {
    local ($p1, $p2) = (@_);

    return "NOT ANY" if (!$p1 || $p1 eq "NOT ANY" || $p1 eq $p2);
    return $p1       if (!$p2 || $p2 eq "NOT ANY");
    return "($p1) AND NOT ($p2)";
    
}

1;
