#!/local/bin/perl
# $Id: pevalclient.pl,v 1.2 95/03/30 17:33:57 cengiz Exp $
# 
#  Copyright (c) 1994 by the University of Southern California
#  and/or the International Business Machines Corporation.
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation in source and binary forms for lawful
#  non-commercial purposes and without fee is hereby granted, provided
#  that the above copyright notice appear in all copies and that both
#  the copyright notice and this permission notice appear in supporting
#  documentation, and that any documentation, advertising materials,
#  and other materials related to such distribution and use acknowledge
#  that the software was developed by the University of Southern
#  California, Information Sciences Institute and/or the International
#  Business Machines Corporation.  The name of the USC or IBM may not
#  be used to endorse or promote products derived from this software
#  without specific prior written permission.
#
#  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
#  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
#  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
#  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
#  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
#  NON-INFRINGEMENT.
#
#  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
#  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
#  THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#  Questions concerning this software should be directed to 
#  info-ra@isi.edu.
#
#  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

# file descriptors and their meanings
# read from PEVALERR what peval wrote to stderr
# read from PEVALOUT what peval wrote to stdout
# write to  PEVALIN  what peval will read from stdin

sub StartPeval {
    local ($peval, $peval_options) = (@_);

    pipe(PEVALERR,PEVALERR2);
    pipe(PEVALIN2,PEVALIN);
    select (PEVALERR2); $| = 1;
    select (PEVALIN); $| = 1;
    select (STDOUT);

    if (fork() == 0) { # child process
	close PEVALERR;
	close PEVALIN;
	close STDIN;
	open(STDIN, "<&PEVALIN2");
	close STDERR;
	open(STDERR, ">&PEVALERR2");
	exec "$peval $peval_options";
	die "Error: could not start peval...\n";
    }
    close PEVALERR2;
    close PEVALIN2;
    &GetSyncWithPeval();
}

sub EndPeval {
    close PEVALIN;
    &GetSyncWithPeval();
    close PEVALERR;
}

sub AskPeval {
    local ($input) = (@_);
    local ($output) = "";

    print PEVALIN $input, "\n";
    &GetSyncWithPeval();
}

sub GetSyncWithPeval {
    while (($_ = <PEVALERR>) && $_ ne "END\n") {
	print STDERR $_;
    }
}

1;
